/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.File;
import java.util.concurrent.Semaphore;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.ApplicationDescription;
import org.apache.spark.deploy.ApplicationDescription$;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.client.AppClient;
import org.apache.spark.deploy.client.AppClientListener;
import org.apache.spark.launcher.LauncherBackend;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend$class;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.SparkDeploySchedulerBackend$;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h!B\u0001\u0003\u0001\u0019a!aG*qCJ\\G)\u001a9m_f\u001c6\r[3ek2,'OQ1dW\u0016tGM\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(BA\u0003\u0007\u0003%\u00198\r[3ek2,'O\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\u0011\u0001Q\"E\r\u0011\u00059yQ\"\u0001\u0002\n\u0005A\u0011!!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0005I9R\"A\n\u000b\u0005Q)\u0012AB2mS\u0016tGO\u0003\u0002\u0017\r\u00051A-\u001a9m_fL!\u0001G\n\u0003#\u0005\u0003\bo\u00117jK:$H*[:uK:,'\u000f\u0005\u0002\u001b75\ta!\u0003\u0002\u001d\r\t9Aj\\4hS:<\u0007\u0002C\u0003\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0004\u0001A\u0011\u0001%I\u0007\u0002\t%\u0011!\u0005\u0002\u0002\u0012)\u0006\u001c8nU2iK\u0012,H.\u001a:J[Bd\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0005M\u001c\u0007C\u0001\u000e'\u0013\t9cA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003\u001di\u0017m\u001d;feN\u00042a\u000b\u00181\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#!B!se\u0006L\bCA\u00195\u001d\tY#'\u0003\u00024Y\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019D\u0006C\u00039\u0001\u0011\u0005\u0011(\u0001\u0004=S:LGO\u0010\u000b\u0005umbT\b\u0005\u0002\u000f\u0001!)Qa\u000ea\u0001?!)Ae\u000ea\u0001K!)\u0011f\u000ea\u0001U!9A\u0003\u0001a\u0001\n\u0013yT#\u0001!\u0011\u0005I\t\u0015B\u0001\"\u0014\u0005%\t\u0005\u000f]\"mS\u0016tG\u000fC\u0004E\u0001\u0001\u0007I\u0011B#\u0002\u0015\rd\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002G\u0013B\u00111fR\u0005\u0003\u00112\u0012A!\u00168ji\"9!jQA\u0001\u0002\u0004\u0001\u0015a\u0001=%c!1A\n\u0001Q!\n\u0001\u000bqa\u00197jK:$\b\u0005C\u0004O\u0001\u0001\u0007I\u0011B(\u0002\u0011M$x\u000e\u001d9j]\u001e,\u0012\u0001\u0015\t\u0003WEK!A\u0015\u0017\u0003\u000f\t{w\u000e\\3b]\"9A\u000b\u0001a\u0001\n\u0013)\u0016\u0001D:u_B\u0004\u0018N\\4`I\u0015\fHC\u0001$W\u0011\u001dQ5+!AA\u0002ACa\u0001\u0017\u0001!B\u0013\u0001\u0016!C:u_B\u0004\u0018N\\4!\u0011\u001dQ\u0006A1A\u0005\nm\u000bq\u0002\\1v]\u000eDWM\u001d\"bG.,g\u000eZ\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011qLB\u0001\tY\u0006,hn\u00195fe&\u0011\u0011M\u0018\u0002\u0010\u0019\u0006,hn\u00195fe\n\u000b7m[3oI\"11\r\u0001Q\u0001\nq\u000b\u0001\u0003\\1v]\u000eDWM\u001d\"bG.,g\u000e\u001a\u0011\t\u0013\u0015\u0004\u0001\u0019!a\u0001\n\u00031\u0017\u0001E:ikR$wn\u001e8DC2d'-Y2l+\u00059\u0007\u0003B\u0016iu\u0019K!!\u001b\u0017\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"C6\u0001\u0001\u0004\u0005\r\u0011\"\u0001m\u0003Q\u0019\b.\u001e;e_^t7)\u00197mE\u0006\u001c7n\u0018\u0013fcR\u0011a)\u001c\u0005\b\u0015*\f\t\u00111\u0001h\u0011\u0019y\u0007\u0001)Q\u0005O\u0006\t2\u000f[;uI><hnQ1mY\n\f7m\u001b\u0011)\u00059\f\bCA\u0016s\u0013\t\u0019HF\u0001\u0005w_2\fG/\u001b7f\u0011%)\b\u00011AA\u0002\u0013%a/A\u0003baBLE-F\u00011\u0011%A\b\u00011AA\u0002\u0013%\u00110A\u0005baBLEm\u0018\u0013fcR\u0011aI\u001f\u0005\b\u0015^\f\t\u00111\u00011\u0011\u0019a\b\u0001)Q\u0005a\u00051\u0011\r\u001d9JI\u0002B#a_9\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003\t1C]3hSN$(/\u0019;j_:\u0014\u0015M\u001d:jKJ,\"!a\u0001\u0011\t\u0005\u0015\u00111C\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u00055\u0011qB\u0001\u0005kRLGN\u0003\u0002\u0002\u0012\u0005!!.\u0019<b\u0013\u0011\t)\"a\u0002\u0003\u0013M+W.\u00199i_J,\u0007\u0002CA\r\u0001\u0001\u0006I!a\u0001\u0002)I,w-[:ue\u0006$\u0018n\u001c8CCJ\u0014\u0018.\u001a:!\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\"\u0001\u0005nCb\u001cuN]3t+\t\t\t\u0003E\u0003,\u0003G\t9#C\u0002\u0002&1\u0012aa\u00149uS>t\u0007cA\u0016\u0002*%\u0019\u00111\u0006\u0017\u0003\u0007%sG\u000f\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0011\u0003%i\u0017\r_\"pe\u0016\u001c\b\u0005C\u0005\u00024\u0001\u0011\r\u0011\"\u0003\u00026\u0005\u0011Bo\u001c;bY\u0016C\b/Z2uK\u0012\u001cuN]3t+\t\t9\u0003\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u0014\u0003M!x\u000e^1m\u000bb\u0004Xm\u0019;fI\u000e{'/Z:!\u0011\u001d\ti\u0004\u0001C!\u0003\u007f\tQa\u001d;beR$\u0012A\u0012\u0005\b\u0003\u0007\u0002A\u0011IA \u0003\u0011\u0019Ho\u001c9\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J\u0005I1m\u001c8oK\u000e$X\r\u001a\u000b\u0004\r\u0006-\u0003BB;\u0002F\u0001\u0007\u0001\u0007C\u0004\u0002P\u0001!\t%a\u0010\u0002\u0019\u0011L7oY8o]\u0016\u001cG/\u001a3\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V\u0005!A-Z1e)\r1\u0015q\u000b\u0005\b\u00033\n\t\u00061\u00011\u0003\u0019\u0011X-Y:p]\"9\u0011Q\f\u0001\u0005B\u0005}\u0013!D3yK\u000e,Ho\u001c:BI\u0012,G\rF\u0006G\u0003C\n)'!\u001b\u0002n\u0005E\u0004bBA2\u00037\u0002\r\u0001M\u0001\u0007MVdG.\u00133\t\u000f\u0005\u001d\u00141\fa\u0001a\u0005Aqo\u001c:lKJLE\rC\u0004\u0002l\u0005m\u0003\u0019\u0001\u0019\u0002\u0011!|7\u000f\u001e)peRD\u0001\"a\u001c\u0002\\\u0001\u0007\u0011qE\u0001\u0006G>\u0014Xm\u001d\u0005\t\u0003g\nY\u00061\u0001\u0002(\u00051Q.Z7pefDq!a\u001e\u0001\t\u0003\nI(A\bfq\u0016\u001cW\u000f^8s%\u0016lwN^3e)\u001d1\u00151PA?\u0003\u0003Cq!a\u0019\u0002v\u0001\u0007\u0001\u0007C\u0004\u0002\u0000\u0005U\u0004\u0019\u0001\u0019\u0002\u000f5,7o]1hK\"A\u00111QA;\u0001\u0004\t\t#\u0001\u0006fq&$8\u000b^1ukNDq!a\"\u0001\t\u0003\nI)A\u000ftk\u001a4\u0017nY5f]R\u0014Vm]8ve\u000e,7OU3hSN$XM]3e)\u0005\u0001\u0006bBAG\u0001\u0011\u0005\u0013qR\u0001\u000eCB\u0004H.[2bi&|g.\u00133\u0015\u0003ABq!a%\u0001\t#\n)*A\fe_J+\u0017/^3tiR{G/\u00197Fq\u0016\u001cW\u000f^8sgR\u0019\u0001+a&\t\u0011\u0005e\u0015\u0011\u0013a\u0001\u0003O\taB]3rk\u0016\u001cH/\u001a3U_R\fG\u000eC\u0004\u0002\u001e\u0002!\t&a(\u0002\u001f\u0011|7*\u001b7m\u000bb,7-\u001e;peN$2\u0001UAQ\u0011!\t\u0019+a'A\u0002\u0005\u0015\u0016aC3yK\u000e,Ho\u001c:JIN\u0004R!a*\u00028BrA!!+\u00024:!\u00111VAY\u001b\t\tiKC\u0002\u00020z\ta\u0001\u0010:p_Rt\u0014\"A\u0017\n\u0007\u0005UF&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00161\u0018\u0002\u0004'\u0016\f(bAA[Y!9\u0011q\u0018\u0001\u0005\n\u0005}\u0012aE<bSR4uN\u001d*fO&\u001cHO]1uS>t\u0007bBAb\u0001\u0011%\u0011qH\u0001\u000e]>$\u0018NZ=D_:$X\r\u001f;\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002HR\u0019a)!3\t\u0011\u0005-\u0017Q\u0019a\u0001\u0003\u001b\f!BZ5oC2\u001cF/\u0019;f!\u0011\ty-!6\u000f\u0007u\u000b\t.C\u0002\u0002Tz\u000bab\u00159be.\f\u0005\u000f\u001d%b]\u0012dW-\u0003\u0003\u0002X\u0006e'!B*uCR,'bAAj=\"a\u0011Q\u001c\u0001\u0002\u0002\u0003%I!a$\u0002`\u0006\u00192/\u001e9fe\u0012\n\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI&!\u0011QRAq\u0013\r\t\u0019\u000f\u0002\u0002\u0011'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u0004")
public class SparkDeploySchedulerBackend
extends CoarseGrainedSchedulerBackend
implements AppClientListener {
    private final TaskSchedulerImpl scheduler;
    private final SparkContext sc;
    private final String[] masters;
    private AppClient client;
    private boolean stopping;
    private final LauncherBackend launcherBackend;
    private volatile Function1<SparkDeploySchedulerBackend, BoxedUnit> shutdownCallback;
    private volatile String appId;
    private final Semaphore registrationBarrier;
    private final Option<Object> maxCores;
    private final int totalExpectedCores;

    public String org$apache$spark$scheduler$cluster$SparkDeploySchedulerBackend$$super$applicationId() {
        return SchedulerBackend$class.applicationId(this);
    }

    private AppClient client() {
        return this.client;
    }

    private void client_$eq(AppClient x$1) {
        this.client = x$1;
    }

    private boolean stopping() {
        return this.stopping;
    }

    private void stopping_$eq(boolean x$1) {
        this.stopping = x$1;
    }

    private LauncherBackend launcherBackend() {
        return this.launcherBackend;
    }

    public Function1<SparkDeploySchedulerBackend, BoxedUnit> shutdownCallback() {
        return this.shutdownCallback;
    }

    public void shutdownCallback_$eq(Function1<SparkDeploySchedulerBackend, BoxedUnit> x$1) {
        this.shutdownCallback = x$1;
    }

    private String appId() {
        return this.appId;
    }

    private void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    private Semaphore registrationBarrier() {
        return this.registrationBarrier;
    }

    private Option<Object> maxCores() {
        return this.maxCores;
    }

    private int totalExpectedCores() {
        return this.totalExpectedCores;
    }

    @Override
    public void start() {
        super.start();
        this.launcherBackend().connect();
        String driverUrl = this.rpcEnv().uriOf(SparkEnv$.MODULE$.driverActorSystemName(), new RpcAddress(this.sc.conf().get("spark.driver.host"), new StringOps(Predef$.MODULE$.augmentString(this.sc.conf().get("spark.driver.port"))).toInt()), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME());
        Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--driver-url", driverUrl, "--executor-id", "{{EXECUTOR_ID}}", "--hostname", "{{HOSTNAME}}", "--cores", "{{CORES}}", "--app-id", "{{APP_ID}}", "--worker-url", "{{WORKER_URL}}"}));
        Seq extraJavaOpts = (Seq)this.sc.conf().getOption("spark.executor.extraJavaOptions").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String s) {
                return Utils$.MODULE$.splitCommandString(s);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        Seq classPathEntries = (Seq)this.sc.conf().getOption("spark.executor.extraClassPath").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$2) {
                return Predef$.MODULE$.refArrayOps((Object[])x$2.split(File.pathSeparator)).toSeq();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        Seq libraryPathEntries = (Seq)this.sc.conf().getOption("spark.executor.extraLibraryPath").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3.split(File.pathSeparator)).toSeq();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        Nil$ testingClassPath = package$.MODULE$.props().contains("spark.testing") ? Predef$.MODULE$.refArrayOps((Object[])((String)package$.MODULE$.props().apply((Object)"java.class.path")).split(File.pathSeparator)).toSeq() : Nil$.MODULE$;
        Seq<String> sparkJavaOpts2 = Utils$.MODULE$.sparkJavaOpts(this.conf(), (Function1<String, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String name) {
                return SparkConf$.MODULE$.isExecutorStartupConf(name);
            }
        });
        Seq javaOpts = (Seq)sparkJavaOpts2.$plus$plus((GenTraversableOnce)extraJavaOpts, Seq$.MODULE$.canBuildFrom());
        Command command = new Command("org.apache.spark.executor.CoarseGrainedExecutorBackend", (Seq<String>)args, (Map<String, String>)this.sc.executorEnvs(), (Seq<String>)((Seq)classPathEntries.$plus$plus((GenTraversableOnce)testingClassPath, Seq$.MODULE$.canBuildFrom())), (Seq<String>)libraryPathEntries, (Seq<String>)javaOpts);
        String appUIAddress = (String)this.sc.ui().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SparkUI x$4) {
                return x$4.appUIAddress();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        Option coresPerExecutor = this.conf().getOption("spark.executor.cores").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
            }
        });
        ApplicationDescription appDesc = new ApplicationDescription(this.sc.appName(), this.maxCores(), this.sc.executorMemory(), command, appUIAddress, this.sc.eventLogDir(), this.sc.eventLogCodec(), (Option<Object>)coresPerExecutor, ApplicationDescription$.MODULE$.$lessinit$greater$default$9());
        this.client_$eq(new AppClient(this.sc.env().rpcEnv(), this.masters, appDesc, this, this.conf()));
        this.client().start();
        this.launcherBackend().setState(SparkAppHandle.State.SUBMITTED);
        this.waitForRegistration();
        this.launcherBackend().setState(SparkAppHandle.State.RUNNING);
    }

    @Override
    public synchronized void stop() {
        this.org$apache$spark$scheduler$cluster$SparkDeploySchedulerBackend$$stop(SparkAppHandle.State.FINISHED);
    }

    @Override
    public void connected(String appId) {
        this.logInfo((Function0<String>)new Serializable(this, appId){
            public static final long serialVersionUID = 0L;
            private final String appId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Connected to Spark cluster with app ID ").append((Object)this.appId$1).toString();
            }
            {
                this.appId$1 = appId$1;
            }
        });
        this.appId_$eq(appId);
        this.notifyContext();
        this.launcherBackend().setAppId(appId);
    }

    @Override
    public void disconnected() {
        this.notifyContext();
        if (!this.stopping()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disconnected from Spark cluster! Waiting for reconnection...";
                }
            });
        }
    }

    @Override
    public void dead(String reason) {
        this.notifyContext();
        if (!this.stopping()) {
            this.launcherBackend().setState(SparkAppHandle.State.KILLED);
            this.logError((Function0<String>)new Serializable(this, reason){
                public static final long serialVersionUID = 0L;
                private final String reason$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Application has been killed. Reason: ").append((Object)this.reason$1).toString();
                }
                {
                    this.reason$1 = reason$1;
                }
            });
            this.scheduler.error(reason);
        }
        return;
        finally {
            this.sc.stop();
        }
    }

    @Override
    public void executorAdded(String fullId, String workerId, String hostPort, int cores, int memory) {
        this.logInfo((Function0<String>)new Serializable(this, fullId, hostPort, cores, memory){
            public static final long serialVersionUID = 0L;
            private final String fullId$1;
            private final String hostPort$1;
            private final int cores$1;
            private final int memory$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Granted executor ID %s on hostPort %s with %d cores, %s RAM")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullId$1, this.hostPort$1, BoxesRunTime.boxToInteger((int)this.cores$1), Utils$.MODULE$.megabytesToString(this.memory$1)}));
            }
            {
                this.fullId$1 = fullId$1;
                this.hostPort$1 = hostPort$1;
                this.cores$1 = cores$1;
                this.memory$1 = memory$1;
            }
        });
    }

    @Override
    public void executorRemoved(String fullId, String message, Option<Object> exitStatus) {
        Option<Object> option;
        block4: {
            ExecutorLossReason executorLossReason;
            block3: {
                block2: {
                    option = exitStatus;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    int code = BoxesRunTime.unboxToInt((Object)some.x());
                    executorLossReason = new ExecutorExited(code, true, message);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                executorLossReason = new SlaveLost(message);
            }
            ExecutorLossReason reason = executorLossReason;
            this.logInfo((Function0<String>)new Serializable(this, fullId, message){
                public static final long serialVersionUID = 0L;
                private final String fullId$2;
                private final String message$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Executor %s removed: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullId$2, this.message$1}));
                }
                {
                    this.fullId$2 = fullId$2;
                    this.message$1 = message$1;
                }
            });
            this.removeExecutor(fullId.split("/")[1], reason);
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public boolean sufficientResourcesRegistered() {
        return (double)this.totalCoreCount().get() >= (double)this.totalExpectedCores() * this.minRegisteredRatio();
    }

    @Override
    public String applicationId() {
        return (String)Option$.MODULE$.apply((Object)this.appId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkDeploySchedulerBackend $outer;

            public final String apply() {
                this.$outer.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Application ID is not initialized yet.";
                    }
                });
                return this.$outer.org$apache$spark$scheduler$cluster$SparkDeploySchedulerBackend$$super$applicationId();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean doRequestTotalExecutors(int requestedTotal) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)this.client());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    AppClient c = (AppClient)some.x();
                    bl = c.requestTotalExecutors(requestedTotal);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Attempted to request executors before driver fully initialized.";
                    }
                });
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public boolean doKillExecutors(Seq<String> executorIds) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)this.client());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    AppClient c = (AppClient)some.x();
                    bl = c.killExecutors(executorIds);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Attempted to kill executors before driver fully initialized.";
                    }
                });
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    private void waitForRegistration() {
        this.registrationBarrier().acquire();
    }

    private void notifyContext() {
        this.registrationBarrier().release();
    }

    public synchronized void org$apache$spark$scheduler$cluster$SparkDeploySchedulerBackend$$stop(SparkAppHandle.State finalState) {
        try {
            this.stopping_$eq(true);
            super.stop();
            this.client().stop();
            Function1<SparkDeploySchedulerBackend, BoxedUnit> callback = this.shutdownCallback();
            if (callback != null) {
                callback.apply((Object)this);
            }
            return;
        }
        finally {
            this.launcherBackend().setState(finalState);
            this.launcherBackend().close();
        }
    }

    public SparkDeploySchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, String[] masters) {
        this.scheduler = scheduler;
        this.sc = sc;
        this.masters = masters;
        super(scheduler, sc.env().rpcEnv());
        this.client = null;
        this.stopping = false;
        this.launcherBackend = new $anon$1(this);
        this.registrationBarrier = new Semaphore(0);
        this.maxCores = this.conf().getOption("spark.cores.max").map((Function1)new $anonfun$2(this));
        this.totalExpectedCores = BoxesRunTime.unboxToInt((Object)this.maxCores().getOrElse((Function0)new $anonfun$1(this)));
    }
}

