/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListener$class;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StorageStatus;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001-\u0011Qc\u0015;pe\u0006<Wm\u0015;biV\u001cH*[:uK:,'O\u0003\u0002\u0004\t\u000591\u000f^8sC\u001e,'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019b#D\u0001\u0015\u0015\t)B!A\u0005tG\",G-\u001e7fe&\u0011q\u0003\u0006\u0002\u000e'B\f'o\u001b'jgR,g.\u001a:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\u0002\u0003\u0010\u0001\u0005\u0004%\tAA\u0010\u00023\u0015DXmY;u_JLE\rV8Ti>\u0014\u0018mZ3Ti\u0006$Xo]\u000b\u0002AA!\u0011E\n\u00150\u001b\u0005\u0011#BA\u0012%\u0003\u001diW\u000f^1cY\u0016T!!\n\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002(E\t\u0019Q*\u00199\u0011\u0005%bcBA\u0007+\u0013\tYc\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016\u000f!\ta\u0002'\u0003\u00022\u0005\ti1\u000b^8sC\u001e,7\u000b^1ukNDaa\r\u0001!\u0002\u0013\u0001\u0013AG3yK\u000e,Ho\u001c:JIR{7\u000b^8sC\u001e,7\u000b^1ukN\u0004\u0003\"B\u001b\u0001\t\u00031\u0014!E:u_J\fw-Z*uCR,8\u000fT5tiV\tq\u0007E\u00029\u0001>r!!\u000f \u000f\u0005ijT\"A\u001e\u000b\u0005qR\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tyd\"A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0013%aA*fc*\u0011qH\u0004\u0005\u0006\t\u0002!I!R\u0001\u0014kB$\u0017\r^3Ti>\u0014\u0018mZ3Ti\u0006$Xo\u001d\u000b\u0004\r&[\u0005CA\u0007H\u0013\tAeB\u0001\u0003V]&$\b\"\u0002&D\u0001\u0004A\u0013AB3yK\u000eLE\rC\u0003M\u0007\u0002\u0007Q*A\u0007va\u0012\fG/\u001a3CY>\u001c7n\u001d\t\u0004q\u0001s\u0005\u0003B\u0007P#RK!\u0001\u0015\b\u0003\rQ+\b\u000f\\33!\ta\"+\u0003\u0002T\u0005\t9!\t\\8dW&#\u0007C\u0001\u000fV\u0013\t1&AA\u0006CY>\u001c7n\u0015;biV\u001c\b\"\u0002#\u0001\t\u0013AFC\u0001$Z\u0011\u0015Qv\u000b1\u0001\\\u0003A)h\u000e]3sg&\u001cH/\u001a3S\t\u0012KE\r\u0005\u0002\u000e9&\u0011QL\u0004\u0002\u0004\u0013:$\b\"B0\u0001\t\u0003\u0002\u0017AD8o+:\u0004XM]:jgR\u0014F\t\u0012\u000b\u0003\r\u0006DQA\u00190A\u0002\r\fA\"\u001e8qKJ\u001c\u0018n\u001d;S\t\u0012\u0003\"a\u00053\n\u0005\u0015$\"!G*qCJ\\G*[:uK:,'/\u00168qKJ\u001c\u0018n\u001d;S\t\u0012CQa\u001a\u0001\u0005B!\f1c\u001c8CY>\u001c7.T1oC\u001e,'/\u00113eK\u0012$\"AR5\t\u000b)4\u0007\u0019A6\u0002#\tdwnY6NC:\fw-\u001a:BI\u0012,G\r\u0005\u0002\u0014Y&\u0011Q\u000e\u0006\u0002\u001f'B\f'o\u001b'jgR,g.\u001a:CY>\u001c7.T1oC\u001e,'/\u00113eK\u0012DQa\u001c\u0001\u0005BA\fQc\u001c8CY>\u001c7.T1oC\u001e,'OU3n_Z,G\r\u0006\u0002Gc\")!O\u001ca\u0001g\u0006\u0019\"\r\\8dW6\u000bg.Y4feJ+Wn\u001c<fIB\u00111\u0003^\u0005\u0003kR\u0011\u0001e\u00159be.d\u0015n\u001d;f]\u0016\u0014(\t\\8dW6\u000bg.Y4feJ+Wn\u001c<fI\")q\u000f\u0001C!q\u0006qqN\u001c\"m_\u000e\\W\u000b\u001d3bi\u0016$GC\u0001$z\u0011\u0015Qh\u000f1\u0001|\u00031\u0011Gn\\2l+B$\u0017\r^3e!\t\u0019B0\u0003\u0002~)\tI2\u000b]1sW2K7\u000f^3oKJ\u0014En\\2l+B$\u0017\r^3eQ\t\u0001q\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001B\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0005\u0003\u0007\u0011A\u0002R3wK2|\u0007/\u001a:Ba&\u0004")
public class StorageStatusListener
implements SparkListener {
    private final Map<String, StorageStatus> executorIdToStorageStatus;

    @Override
    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        SparkListener$class.onStageCompleted(this, stageCompleted);
    }

    @Override
    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        SparkListener$class.onStageSubmitted(this, stageSubmitted);
    }

    @Override
    public void onTaskStart(SparkListenerTaskStart taskStart) {
        SparkListener$class.onTaskStart(this, taskStart);
    }

    @Override
    public void onTaskGettingResult(SparkListenerTaskGettingResult taskGettingResult) {
        SparkListener$class.onTaskGettingResult(this, taskGettingResult);
    }

    @Override
    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        SparkListener$class.onTaskEnd(this, taskEnd);
    }

    @Override
    public void onJobStart(SparkListenerJobStart jobStart) {
        SparkListener$class.onJobStart(this, jobStart);
    }

    @Override
    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        SparkListener$class.onJobEnd(this, jobEnd);
    }

    @Override
    public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate environmentUpdate) {
        SparkListener$class.onEnvironmentUpdate(this, environmentUpdate);
    }

    @Override
    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        SparkListener$class.onApplicationStart(this, applicationStart);
    }

    @Override
    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        SparkListener$class.onApplicationEnd(this, applicationEnd);
    }

    @Override
    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate executorMetricsUpdate) {
        SparkListener$class.onExecutorMetricsUpdate(this, executorMetricsUpdate);
    }

    @Override
    public void onExecutorAdded(SparkListenerExecutorAdded executorAdded2) {
        SparkListener$class.onExecutorAdded(this, executorAdded2);
    }

    @Override
    public void onExecutorRemoved(SparkListenerExecutorRemoved executorRemoved2) {
        SparkListener$class.onExecutorRemoved(this, executorRemoved2);
    }

    public Map<String, StorageStatus> executorIdToStorageStatus() {
        return this.executorIdToStorageStatus;
    }

    public synchronized Seq<StorageStatus> storageStatusList() {
        return this.executorIdToStorageStatus().values().toSeq();
    }

    private void updateStorageStatus(String execId, Seq<Tuple2<BlockId, BlockStatus>> updatedBlocks) {
        this.executorIdToStorageStatus().get((Object)execId).foreach((Function1)new Serializable(this, updatedBlocks){
            public static final long serialVersionUID = 0L;
            private final Seq updatedBlocks$1;

            public final void apply(StorageStatus storageStatus2) {
                this.updatedBlocks$1.foreach((Function1)new Serializable(this, storageStatus2){
                    public static final long serialVersionUID = 0L;
                    private final StorageStatus storageStatus$1;

                    public final Object apply(Tuple2<BlockId, BlockStatus> x0$1) {
                        Tuple2<BlockId, BlockStatus> tuple2 = x0$1;
                        if (tuple2 != null) {
                            BoxedUnit boxedUnit;
                            BlockId blockId = (BlockId)tuple2._1();
                            BlockStatus updatedStatus = (BlockStatus)tuple2._2();
                            StorageLevel storageLevel = updatedStatus.storageLevel();
                            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                            if (!(storageLevel != null ? !((Object)storageLevel).equals(storageLevel2) : storageLevel2 != null)) {
                                boxedUnit = this.storageStatus$1.removeBlock(blockId);
                            } else {
                                this.storageStatus$1.updateBlock(blockId, updatedStatus);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return boxedUnit2;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.storageStatus$1 = storageStatus$1;
                    }
                });
            }
            {
                this.updatedBlocks$1 = updatedBlocks$1;
            }
        });
    }

    private void updateStorageStatus(int unpersistedRDDId) {
        this.storageStatusList().foreach((Function1)new Serializable(this, unpersistedRDDId){
            public static final long serialVersionUID = 0L;
            private final int unpersistedRDDId$1;

            public final void apply(StorageStatus storageStatus2) {
                storageStatus2.rddBlocksById(this.unpersistedRDDId$1).foreach((Function1)new Serializable(this, storageStatus2){
                    public static final long serialVersionUID = 0L;
                    private final StorageStatus storageStatus$2;

                    public final Option<BlockStatus> apply(Tuple2<BlockId, BlockStatus> x0$2) {
                        Tuple2<BlockId, BlockStatus> tuple2 = x0$2;
                        if (tuple2 != null) {
                            BlockId blockId = (BlockId)tuple2._1();
                            Option<BlockStatus> option = this.storageStatus$2.removeBlock(blockId);
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.storageStatus$2 = storageStatus$2;
                    }
                });
            }
            {
                this.unpersistedRDDId$1 = unpersistedRDDId$1;
            }
        });
    }

    @Override
    public synchronized void onUnpersistRDD(SparkListenerUnpersistRDD unpersistRDD) {
        this.updateStorageStatus(unpersistRDD.rddId());
    }

    @Override
    public synchronized void onBlockManagerAdded(SparkListenerBlockManagerAdded blockManagerAdded) {
        BlockManagerId blockManagerId = blockManagerAdded.blockManagerId();
        String executorId = blockManagerId.executorId();
        long maxMem = blockManagerAdded.maxMem();
        StorageStatus storageStatus2 = new StorageStatus(blockManagerId, maxMem);
        this.executorIdToStorageStatus().update((Object)executorId, (Object)storageStatus2);
    }

    @Override
    public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved blockManagerRemoved) {
        StorageStatusListener storageStatusListener = this;
        synchronized (storageStatusListener) {
            String executorId = blockManagerRemoved.blockManagerId().executorId();
            this.executorIdToStorageStatus().remove((Object)executorId);
            return;
        }
    }

    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated blockUpdated) {
        String executorId = blockUpdated.blockUpdatedInfo().blockManagerId().executorId();
        BlockId blockId = blockUpdated.blockUpdatedInfo().blockId();
        StorageLevel storageLevel = blockUpdated.blockUpdatedInfo().storageLevel();
        long memSize = blockUpdated.blockUpdatedInfo().memSize();
        long diskSize = blockUpdated.blockUpdatedInfo().diskSize();
        long externalSize = blockUpdated.blockUpdatedInfo().externalBlockStoreSize();
        BlockStatus blockStatus2 = new BlockStatus(storageLevel, memSize, diskSize, externalSize);
        this.updateStorageStatus(executorId, (Seq<Tuple2<BlockId, BlockStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)blockId, (Object)blockStatus2)}))));
    }

    public StorageStatusListener() {
        SparkListener$class.$init$(this);
        this.executorIdToStorageStatus = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

