/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.jetty.server.handler;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.spark-project.jetty.io.EndPoint;
import org.spark-project.jetty.server.AbstractHttpConnection;
import org.spark-project.jetty.server.Request;
import org.spark-project.jetty.server.handler.HandlerWrapper;

public class IdleTimeoutHandler
extends HandlerWrapper {
    private int _idleTimeoutMs = 1000;
    private boolean _applyToAsync = false;

    public boolean isApplyToAsync() {
        return this._applyToAsync;
    }

    public void setApplyToAsync(boolean applyToAsync) {
        this._applyToAsync = applyToAsync;
    }

    public long getIdleTimeoutMs() {
        return this._idleTimeoutMs;
    }

    public void setIdleTimeoutMs(int _idleTimeoutMs) {
        this._idleTimeoutMs = _idleTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int idle_timeout;
        EndPoint endp;
        AbstractHttpConnection connection = AbstractHttpConnection.getCurrentConnection();
        EndPoint endPoint = endp = connection == null ? null : connection.getEndPoint();
        if (endp == null) {
            idle_timeout = -1;
        } else {
            idle_timeout = endp.getMaxIdleTime();
            endp.setMaxIdleTime(this._idleTimeoutMs);
        }
        try {
            super.handle(target, baseRequest, request, response);
            if (endp == null) return;
        }
        catch (Throwable throwable) {
            if (endp == null) throw throwable;
            if (this._applyToAsync && request.isAsyncStarted()) {
                request.getAsyncContext().addListener(new AsyncListener(endp, idle_timeout){
                    final /* synthetic */ EndPoint val$endp;
                    final /* synthetic */ int val$idle_timeout;
                    {
                        this.val$endp = endPoint;
                        this.val$idle_timeout = n;
                    }

                    public void onTimeout(AsyncEvent event) throws IOException {
                    }

                    public void onStartAsync(AsyncEvent event) throws IOException {
                    }

                    public void onError(AsyncEvent event) throws IOException {
                        this.val$endp.setMaxIdleTime(this.val$idle_timeout);
                    }

                    public void onComplete(AsyncEvent event) throws IOException {
                        this.val$endp.setMaxIdleTime(this.val$idle_timeout);
                    }
                });
                throw throwable;
            } else {
                endp.setMaxIdleTime(idle_timeout);
            }
            throw throwable;
        }
        if (this._applyToAsync && request.isAsyncStarted()) {
            request.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
            return;
        } else {
            endp.setMaxIdleTime(idle_timeout);
        }
    }
}

