/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.File;
import java.util.Locale;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.MapOutputTrackerMasterEndpoint;
import org.apache.spark.MapOutputTrackerWorker;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.StaticMemoryManager;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.network.netty.NettyBlockTransferService;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnv$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMasterEndpoint;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class SparkEnv$
implements Logging {
    public static final SparkEnv$ MODULE$;
    private volatile SparkEnv env;
    private final String driverSystemName;
    private final String executorSystemName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkEnv$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private SparkEnv env() {
        return this.env;
    }

    private void env_$eq(SparkEnv x$1) {
        this.env = x$1;
    }

    public String driverSystemName() {
        return this.driverSystemName;
    }

    public String executorSystemName() {
        return this.executorSystemName;
    }

    public void set(SparkEnv e) {
        this.env_$eq(e);
    }

    public SparkEnv get() {
        return this.env();
    }

    public SparkEnv createDriverEnv(SparkConf conf, boolean isLocal, LiveListenerBus listenerBus, int numCores, Option<OutputCommitCoordinator> mockOutputCommitCoordinator) {
        Predef$.MODULE$.assert(conf.contains(package$.MODULE$.DRIVER_HOST_ADDRESS()), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not set on the driver!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.DRIVER_HOST_ADDRESS().key()}));
            }
        });
        Predef$.MODULE$.assert(conf.contains("spark.driver.port"), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "spark.driver.port is not set on the driver!";
            }
        });
        String bindAddress = conf.get(package$.MODULE$.DRIVER_BIND_ADDRESS());
        String advertiseAddress = conf.get(package$.MODULE$.DRIVER_HOST_ADDRESS());
        int port = new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.driver.port"))).toInt();
        None$ ioEncryptionKey = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.IO_ENCRYPTION_ENABLED())) ? new Some((Object)CryptoStreamUtils$.MODULE$.createKey(conf)) : None$.MODULE$;
        return this.create(conf, SparkContext$.MODULE$.DRIVER_IDENTIFIER(), bindAddress, advertiseAddress, port, isLocal, numCores, (Option<byte[]>)ioEncryptionKey, listenerBus, mockOutputCommitCoordinator);
    }

    public SparkEnv createExecutorEnv(SparkConf conf, String executorId, String hostname, int port, int numCores, Option<byte[]> ioEncryptionKey, boolean isLocal) {
        SparkEnv env = this.create(conf, executorId, hostname, hostname, port, isLocal, numCores, ioEncryptionKey, this.create$default$9(), this.create$default$10());
        this.set(env);
        return env;
    }

    private SparkEnv create(SparkConf conf, String executorId, String bindAddress, String advertiseAddress, int port, boolean isLocal, int numUsableCores, Option<byte[]> ioEncryptionKey, LiveListenerBus listenerBus, Option<OutputCommitCoordinator> mockOutputCommitCoordinator) {
        MetricsSystem metricsSystem;
        Object object;
        boolean isDriver;
        String string = executorId;
        String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isDriver = false);
        if (isDriver) {
            Predef$.MODULE$.assert(listenerBus != null, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Attempted to create driver SparkEnv with null listener bus!";
                }
            });
        }
        SecurityManager securityManager = new SecurityManager(conf, ioEncryptionKey);
        ioEncryptionKey.foreach((Function1)new Serializable(securityManager){
            public static final long serialVersionUID = 0L;
            private final SecurityManager securityManager$1;

            public final void apply(byte[] x$4) {
                if (!this.securityManager$1.isEncryptionEnabled()) {
                    SparkEnv$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "I/O encryption enabled without RPC encryption: keys will be visible on the wire.";
                        }
                    });
                }
            }
            {
                this.securityManager$1 = securityManager$1;
            }
        });
        String systemName = isDriver ? this.driverSystemName() : this.executorSystemName();
        RpcEnv rpcEnv = RpcEnv$.MODULE$.create(systemName, bindAddress, advertiseAddress, port, conf, securityManager, !isDriver);
        if (isDriver) {
            object = conf.set("spark.driver.port", ((Object)BoxesRunTime.boxToInteger((int)rpcEnv.address().port())).toString());
        } else {
            if (rpcEnv.address() != null) {
                conf.set("spark.executor.port", ((Object)BoxesRunTime.boxToInteger((int)rpcEnv.address().port())).toString());
                this.logInfo((Function0<String>)new Serializable(rpcEnv){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnv rpcEnv$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting spark.executor.port to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)BoxesRunTime.boxToInteger((int)this.rpcEnv$1.address().port())).toString()}));
                    }
                    {
                        this.rpcEnv$1 = rpcEnv$1;
                    }
                });
            }
            object = BoxedUnit.UNIT;
        }
        Serializer serializer = (Serializer)this.instantiateClassFromConf$1("spark.serializer", "org.apache.spark.serializer.JavaSerializer", conf, isDriver);
        this.logDebug((Function0<String>)new Serializable(serializer){
            public static final long serialVersionUID = 0L;
            private final Serializer serializer$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using serializer: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serializer$1.getClass()}));
            }
            {
                this.serializer$1 = serializer$1;
            }
        });
        SerializerManager serializerManager = new SerializerManager(serializer, conf, ioEncryptionKey);
        JavaSerializer closureSerializer = new JavaSerializer(conf);
        BroadcastManager broadcastManager = new BroadcastManager(isDriver, conf, securityManager);
        MapOutputTracker mapOutputTracker = isDriver ? new MapOutputTrackerMaster(conf, broadcastManager, isLocal) : new MapOutputTrackerWorker(conf);
        mapOutputTracker.trackerEndpoint_$eq(this.registerOrLookupEndpoint$1(MapOutputTracker$.MODULE$.ENDPOINT_NAME(), (Function0)new Serializable(conf, rpcEnv, mapOutputTracker){
            public static final long serialVersionUID = 0L;
            private final SparkConf conf$1;
            private final RpcEnv rpcEnv$1;
            private final MapOutputTracker mapOutputTracker$1;

            public final MapOutputTrackerMasterEndpoint apply() {
                return new MapOutputTrackerMasterEndpoint(this.rpcEnv$1, (MapOutputTrackerMaster)this.mapOutputTracker$1, this.conf$1);
            }
            {
                this.conf$1 = conf$1;
                this.rpcEnv$1 = rpcEnv$1;
                this.mapOutputTracker$1 = mapOutputTracker$1;
            }
        }, conf, isDriver, rpcEnv));
        Map shortShuffleMgrNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sort"), (Object)SortShuffleManager.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tungsten-sort"), (Object)SortShuffleManager.class.getName())}));
        String shuffleMgrName = conf.get("spark.shuffle.manager", "sort");
        String shuffleMgrClass = (String)shortShuffleMgrNames.getOrElse((Object)shuffleMgrName.toLowerCase(Locale.ROOT), (Function0)new Serializable(shuffleMgrName){
            public static final long serialVersionUID = 0L;
            private final String shuffleMgrName$1;

            public final String apply() {
                return this.shuffleMgrName$1;
            }
            {
                this.shuffleMgrName$1 = shuffleMgrName$1;
            }
        });
        ShuffleManager shuffleManager = (ShuffleManager)this.instantiateClass$1(shuffleMgrClass, conf, isDriver);
        boolean useLegacyMemoryManager = conf.getBoolean("spark.memory.useLegacyMode", false);
        MemoryManager memoryManager = useLegacyMemoryManager ? new StaticMemoryManager(conf, numUsableCores) : UnifiedMemoryManager$.MODULE$.apply(conf, numUsableCores);
        int blockManagerPort = isDriver ? BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT())) : BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.BLOCK_MANAGER_PORT()));
        NettyBlockTransferService blockTransferService = new NettyBlockTransferService(conf, securityManager, bindAddress, advertiseAddress, blockManagerPort, numUsableCores);
        BlockManagerMaster blockManagerMaster = new BlockManagerMaster(this.registerOrLookupEndpoint$1(BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME(), (Function0)new Serializable(conf, isLocal, listenerBus, rpcEnv){
            public static final long serialVersionUID = 0L;
            private final SparkConf conf$1;
            private final boolean isLocal$1;
            private final LiveListenerBus listenerBus$1;
            private final RpcEnv rpcEnv$1;

            public final BlockManagerMasterEndpoint apply() {
                return new BlockManagerMasterEndpoint(this.rpcEnv$1, this.isLocal$1, this.conf$1, this.listenerBus$1);
            }
            {
                this.conf$1 = conf$1;
                this.isLocal$1 = isLocal$1;
                this.listenerBus$1 = listenerBus$1;
                this.rpcEnv$1 = rpcEnv$1;
            }
        }, conf, isDriver, rpcEnv), conf, isDriver);
        BlockManager blockManager2 = new BlockManager(executorId, rpcEnv, blockManagerMaster, serializerManager, conf, memoryManager, mapOutputTracker, shuffleManager, blockTransferService, securityManager, numUsableCores);
        if (isDriver) {
            metricsSystem = MetricsSystem$.MODULE$.createMetricsSystem("driver", conf, securityManager);
        } else {
            conf.set("spark.executor.id", executorId);
            MetricsSystem ms = MetricsSystem$.MODULE$.createMetricsSystem("executor", conf, securityManager);
            ms.start();
            metricsSystem = ms;
        }
        MetricsSystem metricsSystem2 = metricsSystem;
        OutputCommitCoordinator outputCommitCoordinator = (OutputCommitCoordinator)mockOutputCommitCoordinator.getOrElse((Function0)new Serializable(conf, isDriver){
            public static final long serialVersionUID = 0L;
            private final SparkConf conf$1;
            private final boolean isDriver$1;

            public final OutputCommitCoordinator apply() {
                return new OutputCommitCoordinator(this.conf$1, this.isDriver$1);
            }
            {
                this.conf$1 = conf$1;
                this.isDriver$1 = isDriver$1;
            }
        });
        RpcEndpointRef outputCommitCoordinatorRef = this.registerOrLookupEndpoint$1("OutputCommitCoordinator", (Function0)new Serializable(rpcEnv, outputCommitCoordinator){
            public static final long serialVersionUID = 0L;
            private final RpcEnv rpcEnv$1;
            private final OutputCommitCoordinator outputCommitCoordinator$1;

            public final OutputCommitCoordinator.OutputCommitCoordinatorEndpoint apply() {
                return new OutputCommitCoordinator.OutputCommitCoordinatorEndpoint(this.rpcEnv$1, this.outputCommitCoordinator$1);
            }
            {
                this.rpcEnv$1 = rpcEnv$1;
                this.outputCommitCoordinator$1 = outputCommitCoordinator$1;
            }
        }, conf, isDriver, rpcEnv);
        outputCommitCoordinator.coordinatorRef_$eq((Option<RpcEndpointRef>)new Some((Object)outputCommitCoordinatorRef));
        SparkEnv envInstance = new SparkEnv(executorId, rpcEnv, serializer, closureSerializer, serializerManager, mapOutputTracker, shuffleManager, broadcastManager, blockManager2, securityManager, metricsSystem2, memoryManager, outputCommitCoordinator, conf);
        if (isDriver) {
            String sparkFilesDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.getLocalDir(conf), "userFiles").getAbsolutePath();
            envInstance.driverTmpDir_$eq((Option<String>)new Some((Object)sparkFilesDir));
        }
        return envInstance;
    }

    public Option<OutputCommitCoordinator> createDriverEnv$default$5() {
        return None$.MODULE$;
    }

    private LiveListenerBus create$default$9() {
        return null;
    }

    private Option<OutputCommitCoordinator> create$default$10() {
        return None$.MODULE$;
    }

    public Map<String, Seq<Tuple2<String, String>>> environmentDetails(SparkConf conf, String schedulingMode, Seq<String> addedJars, Seq<String> addedFiles) {
        Seq jvmInformation = (Seq)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Java Version", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Properties$.MODULE$.javaVersion(), Properties$.MODULE$.javaVendor()}))), new Tuple2((Object)"Java Home", (Object)Properties$.MODULE$.javaHome()), new Tuple2((Object)"Scala Version", (Object)Properties$.MODULE$.versionString())}))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Seq schedulerMode = conf.contains("spark.scheduler.mode") ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.scheduler.mode", (Object)schedulingMode)}));
        Tuple2[] sparkProperties = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])conf.getAll()).$plus$plus((GenTraversableOnce)schedulerMode, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Seq systemProperties = Utils$.MODULE$.getSystemProperties().toSeq();
        Seq otherProperties = (Seq)((SeqLike)systemProperties.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k;
                    String string = k = (String)tuple2._1();
                    String string2 = "java.class.path";
                    boolean bl = (string == null ? string2 != null : !string.equals(string2)) && !k.startsWith("spark.");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Tuple2[] classPathEntries = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Properties$.MODULE$.javaClassPath().split(File.pathSeparator)).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return x$5.isEmpty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String x$6) {
                return new Tuple2((Object)x$6, (Object)"System Classpath");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Seq addedJarsAndFiles = (Seq)((TraversableLike)addedJars.$plus$plus(addedFiles, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String x$7) {
                return new Tuple2((Object)x$7, (Object)"Added By User");
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq classPaths = (Seq)((SeqLike)addedJarsAndFiles.$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])classPathEntries), Seq$.MODULE$.canBuildFrom())).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JVM Information"), (Object)jvmInformation), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Spark Properties"), (Object)Predef$.MODULE$.wrapRefArray((Object[])sparkProperties)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"System Properties"), (Object)otherProperties), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Classpath Entries"), (Object)classPaths)}));
    }

    private final Object instantiateClass$1(String className, SparkConf conf$1, boolean isDriver$1) {
        Object obj;
        Class<?> cls = Utils$.MODULE$.classForName(className);
        try {
            obj = cls.getConstructor(SparkConf.class, Boolean.TYPE).newInstance(conf$1, new Boolean(isDriver$1));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                obj = cls.getConstructor(SparkConf.class).newInstance(conf$1);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                obj = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        return obj;
    }

    private final Object instantiateClassFromConf$1(String propertyName, String defaultClassName, SparkConf conf$1, boolean isDriver$1) {
        return this.instantiateClass$1(conf$1.get(propertyName, defaultClassName), conf$1, isDriver$1);
    }

    private final RpcEndpointRef registerOrLookupEndpoint$1(String name2, Function0 endpointCreator, SparkConf conf$1, boolean isDriver$1, RpcEnv rpcEnv$1) {
        RpcEndpointRef rpcEndpointRef;
        if (isDriver$1) {
            this.logInfo((Function0<String>)new Serializable(name2){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Registering ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = name$1;
                }
            });
            rpcEndpointRef = rpcEnv$1.setupEndpoint(name2, (RpcEndpoint)endpointCreator.apply());
        } else {
            rpcEndpointRef = RpcUtils$.MODULE$.makeDriverRef(name2, conf$1, rpcEnv$1);
        }
        return rpcEndpointRef;
    }

    private SparkEnv$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.driverSystemName = "sparkDriver";
        this.executorSystemName = "sparkExecutor";
    }
}

