/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.SerializableWritable;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.mapred.SparkHadoopMapRedUtil$;
import org.apache.spark.rdd.HadoopRDD$;
import org.apache.spark.util.SerializableJobConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00055h!B\u0001\u0003\u0001\u0019a!!E*qCJ\\\u0007*\u00193p_B<&/\u001b;fe*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\u0011%tG/\u001a:oC2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0005\u00015\u0019r\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Ui\u0011\u0001B\u0005\u0003-\u0011\u0011q\u0001T8hO&tw\r\u0005\u0002\u000f1%\u0011\u0011d\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t7\u0001\u0011\t\u0011)A\u0005;\u00059!n\u001c2D_:47\u0001\u0001\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\na!\\1qe\u0016$'B\u0001\u0012\t\u0003\u0019A\u0017\rZ8pa&\u0011Ae\b\u0002\b\u0015>\u00147i\u001c8g\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0019a\u0014N\\5u}Q\u0011\u0001F\u000b\t\u0003S\u0001i\u0011A\u0001\u0005\u00067\u0015\u0002\r!\b\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0003\rqwn^\u000b\u0002]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0005kRLGNC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\u0002$\u0001\u0002#bi\u0016Daa\u000e\u0001!\u0002\u0013q\u0013\u0001\u00028po\u0002Bq!\u000f\u0001C\u0002\u0013%!(\u0001\u0003d_:4W#A\u001e\u0011\u0005qrT\"A\u001f\u000b\u0005E2\u0011BA >\u0005M\u0019VM]5bY&T\u0018M\u00197f\u0015>\u00147i\u001c8g\u0011\u0019\t\u0005\u0001)A\u0005w\u0005)1m\u001c8gA!91\t\u0001a\u0001\n\u0013!\u0015!\u00026pE&#U#A#\u0011\u000591\u0015BA$\u0010\u0005\rIe\u000e\u001e\u0005\b\u0013\u0002\u0001\r\u0011\"\u0003K\u0003%QwNY%E?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011a\u0002T\u0005\u0003\u001b>\u0011A!\u00168ji\"9q\nSA\u0001\u0002\u0004)\u0015a\u0001=%c!1\u0011\u000b\u0001Q!\n\u0015\u000baA[8c\u0013\u0012\u0003\u0003bB*\u0001\u0001\u0004%I\u0001R\u0001\bgBd\u0017\u000e^%E\u0011\u001d)\u0006\u00011A\u0005\nY\u000b1b\u001d9mSRLEi\u0018\u0013fcR\u00111j\u0016\u0005\b\u001fR\u000b\t\u00111\u0001F\u0011\u0019I\u0006\u0001)Q\u0005\u000b\u0006A1\u000f\u001d7ji&#\u0005\u0005C\u0004\\\u0001\u0001\u0007I\u0011\u0002#\u0002\u0013\u0005$H/Z7qi&#\u0005bB/\u0001\u0001\u0004%IAX\u0001\u000eCR$X-\u001c9u\u0013\u0012{F%Z9\u0015\u0005-{\u0006bB(]\u0003\u0003\u0005\r!\u0012\u0005\u0007C\u0002\u0001\u000b\u0015B#\u0002\u0015\u0005$H/Z7qi&#\u0005\u0005C\u0004d\u0001\u0001\u0007I\u0011\u00023\u0002\u0007)LE)F\u0001f!\r1w-[\u0007\u0002\r%\u0011\u0001N\u0002\u0002\u0015'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z,sSR\f'\r\\3\u0011\u0005yQ\u0017BA6 \u0005\u0015QuNY%E\u0011\u001di\u0007\u00011A\u0005\n9\fqA[%E?\u0012*\u0017\u000f\u0006\u0002L_\"9q\n\\A\u0001\u0002\u0004)\u0007BB9\u0001A\u0003&Q-\u0001\u0003k\u0013\u0012\u0003\u0003bB:\u0001\u0001\u0004%I\u0001^\u0001\u0005i\u0006LE)F\u0001v!\r1wM\u001e\t\u0003=]L!\u0001_\u0010\u0003\u001bQ\u000b7o[!ui\u0016l\u0007\u000f^%E\u0011\u001dQ\b\u00011A\u0005\nm\f\u0001\u0002^1J\t~#S-\u001d\u000b\u0003\u0017rDqaT=\u0002\u0002\u0003\u0007Q\u000f\u0003\u0004\u007f\u0001\u0001\u0006K!^\u0001\u0006i\u0006LE\t\t\u0005\n\u0003\u0003\u0001\u0001\u0019!C\u0005\u0003\u0007\taa\u001e:ji\u0016\u0014XCAA\u0003!\u0015q\u0012qA\u0007\u000e\u0013\r\tIa\b\u0002\r%\u0016\u001cwN\u001d3Xe&$XM\u001d\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0005\u0003\u001f\t!b\u001e:ji\u0016\u0014x\fJ3r)\rY\u0015\u0011\u0003\u0005\n\u001f\u0006-\u0011\u0011!a\u0001\u0003\u000bA\u0001\"!\u0006\u0001A\u0003&\u0011QA\u0001\boJLG/\u001a:!Q\u0011\t\u0019\"!\u0007\u0011\u00079\tY\"C\u0002\u0002\u001e=\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0013\u0005\u0005\u0002\u00011A\u0005\n\u0005\r\u0012A\u00024pe6\fG/\u0006\u0002\u0002&A)a$a\n\u000e\u001b%\u0019\u0011\u0011F\u0010\u0003\u0019=+H\u000f];u\r>\u0014X.\u0019;\t\u0013\u00055\u0002\u00011A\u0005\n\u0005=\u0012A\u00034pe6\fGo\u0018\u0013fcR\u00191*!\r\t\u0013=\u000bY#!AA\u0002\u0005\u0015\u0002\u0002CA\u001b\u0001\u0001\u0006K!!\n\u0002\u000f\u0019|'/\\1uA!\"\u00111GA\r\u0011%\tY\u0004\u0001a\u0001\n\u0013\ti$A\u0005d_6l\u0017\u000e\u001e;feV\u0011\u0011q\b\t\u0004=\u0005\u0005\u0013bAA\"?\tyq*\u001e;qkR\u001cu.\\7jiR,'\u000fC\u0005\u0002H\u0001\u0001\r\u0011\"\u0003\u0002J\u0005i1m\\7nSR$XM]0%KF$2aSA&\u0011%y\u0015QIA\u0001\u0002\u0004\ty\u0004\u0003\u0005\u0002P\u0001\u0001\u000b\u0015BA \u0003)\u0019w.\\7jiR,'\u000f\t\u0015\u0005\u0003\u001b\nI\u0002C\u0005\u0002V\u0001\u0001\r\u0011\"\u0003\u0002X\u0005Q!n\u001c2D_:$X\r\u001f;\u0016\u0005\u0005e\u0003c\u0001\u0010\u0002\\%\u0019\u0011QL\u0010\u0003\u0015){'mQ8oi\u0016DH\u000fC\u0005\u0002b\u0001\u0001\r\u0011\"\u0003\u0002d\u0005q!n\u001c2D_:$X\r\u001f;`I\u0015\fHcA&\u0002f!Iq*a\u0018\u0002\u0002\u0003\u0007\u0011\u0011\f\u0005\t\u0003S\u0002\u0001\u0015)\u0003\u0002Z\u0005Y!n\u001c2D_:$X\r\u001f;!Q\u0011\t9'!\u0007\t\u0013\u0005=\u0004\u00011A\u0005\n\u0005E\u0014a\u0003;bg.\u001cuN\u001c;fqR,\"!a\u001d\u0011\u0007y\t)(C\u0002\u0002x}\u0011!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\"I\u00111\u0010\u0001A\u0002\u0013%\u0011QP\u0001\u0010i\u0006\u001c8nQ8oi\u0016DHo\u0018\u0013fcR\u00191*a \t\u0013=\u000bI(!AA\u0002\u0005M\u0004\u0002CAB\u0001\u0001\u0006K!a\u001d\u0002\u0019Q\f7o[\"p]R,\u0007\u0010\u001e\u0011)\t\u0005\u0005\u0015\u0011\u0004\u0005\b\u0003\u0013\u0003A\u0011AAF\u0003!\u0001(/Z*fiV\u0004H#A&\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u0006)1/\u001a;vaR91*a%\u0002\u0018\u0006m\u0005bBAK\u0003\u001b\u0003\r!R\u0001\u0006U>\u0014\u0017\u000e\u001a\u0005\b\u00033\u000bi\t1\u0001F\u0003\u001d\u0019\b\u000f\\5uS\u0012Dq!!(\u0002\u000e\u0002\u0007Q)A\u0005biR,W\u000e\u001d;jI\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005-\u0015\u0001B8qK:Dq!!*\u0001\t\u0003\t9+A\u0003xe&$X\rF\u0003L\u0003S\u000bi\u000bC\u0004\u0002,\u0006\r\u0006\u0019A\u0007\u0002\u0007-,\u0017\u0010C\u0004\u00020\u0006\r\u0006\u0019A\u0007\u0002\u000bY\fG.^3\t\u000f\u0005M\u0006\u0001\"\u0001\u0002\f\u0006)1\r\\8tK\"9\u0011q\u0017\u0001\u0005\u0002\u0005-\u0015AB2p[6LG\u000fC\u0004\u0002<\u0002!\t!a#\u0002\u0013\r|W.\\5u\u0015>\u0014\u0007bBA`\u0001\u0011%\u0011\u0011Y\u0001\u0010O\u0016$x*\u001e;qkR4uN]7biR\u0011\u0011Q\u0005\u0005\b\u0003\u000b\u0004A\u0011BAd\u0003I9W\r^(viB,HoQ8n[&$H/\u001a:\u0015\u0005\u0005}\u0002bBAf\u0001\u0011%\u0011QZ\u0001\u000eO\u0016$(j\u001c2D_:$X\r\u001f;\u0015\u0005\u0005e\u0003bBAi\u0001\u0011%\u00111[\u0001\u000fO\u0016$H+Y:l\u0007>tG/\u001a=u)\t\t\u0019\bC\u0004\u0002X\u0002!\t\"!7\u0002+9,w\u000fV1tW\u0006#H/Z7qi\u000e{g\u000e^3yiR1\u00111OAn\u0003;Da!OAk\u0001\u0004i\u0002bBAp\u0003+\u0004\rA^\u0001\nCR$X-\u001c9u\u0013\u0012Dq!a9\u0001\t\u0013\t)/\u0001\u0004tKRLEi\u001d\u000b\b\u0017\u0006\u001d\u0018\u0011^Av\u0011\u001d\t)*!9A\u0002\u0015Cq!!'\u0002b\u0002\u0007Q\tC\u0004\u0002\u001e\u0006\u0005\b\u0019A#")
public class SparkHadoopWriter
implements Logging,
Serializable {
    private final Date now;
    private final SerializableJobConf conf;
    private int jobID;
    private int splitID;
    private int attemptID;
    private SerializableWritable<JobID> jID;
    private SerializableWritable<TaskAttemptID> taID;
    private transient RecordWriter<Object, Object> writer;
    private transient OutputFormat<Object, Object> format;
    private transient org.apache.hadoop.mapred.OutputCommitter committer;
    private transient JobContext jobContext;
    private transient org.apache.hadoop.mapred.TaskAttemptContext taskContext;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private Date now() {
        return this.now;
    }

    private SerializableJobConf conf() {
        return this.conf;
    }

    private int jobID() {
        return this.jobID;
    }

    private void jobID_$eq(int x$1) {
        this.jobID = x$1;
    }

    private int splitID() {
        return this.splitID;
    }

    private void splitID_$eq(int x$1) {
        this.splitID = x$1;
    }

    private int attemptID() {
        return this.attemptID;
    }

    private void attemptID_$eq(int x$1) {
        this.attemptID = x$1;
    }

    private SerializableWritable<JobID> jID() {
        return this.jID;
    }

    private void jID_$eq(SerializableWritable<JobID> x$1) {
        this.jID = x$1;
    }

    private SerializableWritable<TaskAttemptID> taID() {
        return this.taID;
    }

    private void taID_$eq(SerializableWritable<TaskAttemptID> x$1) {
        this.taID = x$1;
    }

    private RecordWriter<Object, Object> writer() {
        return this.writer;
    }

    private void writer_$eq(RecordWriter<Object, Object> x$1) {
        this.writer = x$1;
    }

    private OutputFormat<Object, Object> format() {
        return this.format;
    }

    private void format_$eq(OutputFormat<Object, Object> x$1) {
        this.format = x$1;
    }

    private org.apache.hadoop.mapred.OutputCommitter committer() {
        return this.committer;
    }

    private void committer_$eq(org.apache.hadoop.mapred.OutputCommitter x$1) {
        this.committer = x$1;
    }

    private JobContext jobContext() {
        return this.jobContext;
    }

    private void jobContext_$eq(JobContext x$1) {
        this.jobContext = x$1;
    }

    private org.apache.hadoop.mapred.TaskAttemptContext taskContext() {
        return this.taskContext;
    }

    private void taskContext_$eq(org.apache.hadoop.mapred.TaskAttemptContext x$1) {
        this.taskContext = x$1;
    }

    public void preSetup() {
        this.setIDs(0, 0, 0);
        HadoopRDD$.MODULE$.addLocalConfiguration("", 0, 0, 0, this.conf().value());
        JobContext jCtxt = this.getJobContext();
        this.getOutputCommitter().setupJob(jCtxt);
    }

    public void setup(int jobid, int splitid, int attemptid) {
        this.setIDs(jobid, splitid, attemptid);
        HadoopRDD$.MODULE$.addLocalConfiguration(new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(this.now()), jobid, this.splitID(), this.attemptID(), this.conf().value());
    }

    public void open() {
        NumberFormat numfmt = NumberFormat.getInstance(Locale.US);
        numfmt.setMinimumIntegerDigits(5);
        numfmt.setGroupingUsed(false);
        String outputName = new StringBuilder().append((Object)"part-").append((Object)numfmt.format(this.splitID())).toString();
        Path path = FileOutputFormat.getOutputPath((JobConf)this.conf().value());
        FileSystem fs = path == null ? FileSystem.get((Configuration)this.conf().value()) : path.getFileSystem((Configuration)this.conf().value());
        this.getOutputCommitter().setupTask(this.getTaskContext());
        this.writer_$eq((RecordWriter<Object, Object>)this.getOutputFormat().getRecordWriter(fs, this.conf().value(), outputName, (Progressable)Reporter.NULL));
    }

    public void write(Object key, Object value2) {
        if (this.writer() == null) {
            throw new IOException("Writer is null, open() has not been called");
        }
        this.writer().write(key, value2);
    }

    public void close() {
        this.writer().close(Reporter.NULL);
    }

    public void commit() {
        SparkHadoopMapRedUtil$.MODULE$.commitTask((OutputCommitter)this.getOutputCommitter(), (TaskAttemptContext)this.getTaskContext(), this.jobID(), this.splitID());
    }

    public void commitJob() {
        org.apache.hadoop.mapred.OutputCommitter cmtr = this.getOutputCommitter();
        cmtr.commitJob(this.getJobContext());
    }

    private OutputFormat<Object, Object> getOutputFormat() {
        if (this.format() == null) {
            this.format_$eq((OutputFormat<Object, Object>)this.conf().value().getOutputFormat());
        }
        return this.format();
    }

    private org.apache.hadoop.mapred.OutputCommitter getOutputCommitter() {
        if (this.committer() == null) {
            this.committer_$eq(this.conf().value().getOutputCommitter());
        }
        return this.committer();
    }

    private JobContext getJobContext() {
        if (this.jobContext() == null) {
            this.jobContext_$eq((JobContext)new JobContextImpl(this.conf().value(), (org.apache.hadoop.mapreduce.JobID)this.jID().value()));
        }
        return this.jobContext();
    }

    private org.apache.hadoop.mapred.TaskAttemptContext getTaskContext() {
        if (this.taskContext() == null) {
            this.taskContext_$eq(this.newTaskAttemptContext(this.conf().value(), this.taID().value()));
        }
        return this.taskContext();
    }

    public org.apache.hadoop.mapred.TaskAttemptContext newTaskAttemptContext(JobConf conf, TaskAttemptID attemptId) {
        return new TaskAttemptContextImpl(conf, attemptId);
    }

    private void setIDs(int jobid, int splitid, int attemptid) {
        this.jobID_$eq(jobid);
        this.splitID_$eq(splitid);
        this.attemptID_$eq(attemptid);
        this.jID_$eq(new SerializableWritable<JobID>(SparkHadoopWriterUtils$.MODULE$.createJobID(this.now(), jobid)));
        this.taID_$eq(new SerializableWritable<TaskAttemptID>(new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)this.jID().value(), TaskType.MAP, this.splitID()), this.attemptID())));
    }

    public SparkHadoopWriter(JobConf jobConf) {
        Logging$class.$init$(this);
        this.now = new Date();
        this.conf = new SerializableJobConf(jobConf);
        this.jobID = 0;
        this.splitID = 0;
        this.attemptID = 0;
        this.jID = null;
        this.taID = null;
        this.writer = null;
        this.format = null;
        this.committer = null;
        this.jobContext = null;
        this.taskContext = null;
    }
}

