/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.spark.SparkConf;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tEb!B\u0001\u0003\u0001\u0011Q!!E*fe&\fG.\u001b>fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0003\u0005\u0013\u0001\t\u0005\t\u0015!\u0003\u0015\u0003E!WMZ1vYR\u001cVM]5bY&TXM]\u0002\u0001!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0006TKJL\u0017\r\\5{KJD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0005G>tg\r\u0005\u0002\u001c95\tA!\u0003\u0002\u001e\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005iQM\\2ssB$\u0018n\u001c8LKf\u00042\u0001D\u0011$\u0013\t\u0011SB\u0001\u0004PaRLwN\u001c\t\u0004\u0019\u00112\u0013BA\u0013\u000e\u0005\u0015\t%O]1z!\taq%\u0003\u0002)\u001b\t!!)\u001f;f\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u0019a\u0014N\\5u}Q!A&\f\u00180!\t)\u0002\u0001C\u0003\u0013S\u0001\u0007A\u0003C\u0003\u001aS\u0001\u0007!\u0004C\u0003 S\u0001\u0007\u0001\u0005C\u0003+\u0001\u0011\u0005\u0011\u0007F\u0002-eMBQA\u0005\u0019A\u0002QAQ!\u0007\u0019A\u0002iAa!\u000e\u0001!\u0002\u00131\u0014AD6ss>\u001cVM]5bY&TXM\u001d\t\u0003+]J!\u0001\u000f\u0002\u0003\u001d-\u0013\u0018p\\*fe&\fG.\u001b>fe\"1!\b\u0001Q\u0001\nm\nab\u001d;sS:<7\t\\1tgR\u000bw\rE\u0002=\u007f\u0005k\u0011!\u0010\u0006\u0003}5\tqA]3gY\u0016\u001cG/\u0003\u0002A{\tA1\t\\1tgR\u000bw\r\u0005\u0002C\u000b:\u0011AbQ\u0005\u0003\t6\ta\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011A)\u0004\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002&\u0002GA\u0014\u0018.\\5uSZ,\u0017I\u001c3Qe&l\u0017\u000e^5wK\u0006\u0013(/Y=DY\u0006\u001c8\u000fV1hgB\u0019!iS'\n\u00051;%aA*fiB\u0012a*\u0015\t\u0004y}z\u0005C\u0001)R\u0019\u0001!\u0011B\u0015%\u0002\u0002\u0003\u0005)\u0011A*\u0003\u0007}#\u0013'\u0005\u0002U/B\u0011A\"V\u0005\u0003-6\u0011qAT8uQ&tw\r\u0005\u0002\r1&\u0011\u0011,\u0004\u0002\u0004\u0003:L\bBB.\u0001A\u0003%A,A\td_6\u0004(/Z:t\u0005J|\u0017\rZ2bgR\u0004\"\u0001D/\n\u0005yk!a\u0002\"p_2,\u0017M\u001c\u0005\u0007A\u0002\u0001\u000b\u0011\u0002/\u0002\u001f\r|W\u000e\u001d:fgN\u001c\u0006.\u001e4gY\u0016DaA\u0019\u0001!\u0002\u0013a\u0016\u0001D2p[B\u0014Xm]:SI\u0012\u001c\bB\u00023\u0001A\u0003%A,\u0001\u000bd_6\u0004(/Z:t'\",hM\u001a7f'BLG\u000e\u001c\u0005\tM\u0002A)\u0019!C\u0005O\u0006\u00012m\\7qe\u0016\u001c8/[8o\u0007>$WmY\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eB\u0001\u0003S>L!!\u001c6\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0002C8\u0001\u0011\u0003\u0005\u000b\u0015\u00025\u0002#\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0005C\u0003r\u0001\u0011\u0005!/A\tf]\u000e\u0014\u0018\u0010\u001d;j_:,e.\u00192mK\u0012,\u0012\u0001\u0018\u0005\u0006i\u0002!\t!^\u0001\u000bG\u0006tWk]3Lef|GC\u0001/w\u0011\u001598\u000f1\u0001y\u0003\t\u0019G\u000f\r\u0002zwB\u0019Ah\u0010>\u0011\u0005A[H!\u0003?w\u0003\u0003\u0005\tQ!\u0001T\u0005\ryFe\r\u0005\u0006}\u0002!\ta`\u0001\u000eO\u0016$8+\u001a:jC2L'0\u001a:\u0015\u000bQ\t\t!!\u0004\t\r]l\b\u0019AA\u0002a\u0011\t)!!\u0003\u0011\tqz\u0014q\u0001\t\u0004!\u0006%AaCA\u0006\u0003\u0003\t\t\u0011!A\u0003\u0002M\u00131a\u0018\u00135\u0011\u0019\ty! a\u00019\u0006A\u0011-\u001e;p!&\u001c7\u000e\u0003\u0004\u007f\u0001\u0011\u0005\u00111\u0003\u000b\u0006)\u0005U\u00111\u0005\u0005\t\u0003/\t\t\u00021\u0001\u0002\u001a\u0005Y1.Z=DY\u0006\u001c8\u000fV1ha\u0011\tY\"a\b\u0011\tqz\u0014Q\u0004\t\u0004!\u0006}AaCA\u0011\u0003+\t\t\u0011!A\u0003\u0002M\u00131a\u0018\u00136\u0011!\t)#!\u0005A\u0002\u0005\u001d\u0012!\u0004<bYV,7\t\\1tgR\u000bw\r\r\u0003\u0002*\u00055\u0002\u0003\u0002\u001f@\u0003W\u00012\u0001UA\u0017\t-\ty#a\t\u0002\u0002\u0003\u0005)\u0011A*\u0003\u0007}#c\u0007C\u0004\u00024\u0001!I!!\u000e\u0002\u001dMDw.\u001e7e\u0007>l\u0007O]3tgR\u0019A,a\u000e\t\u0011\u0005e\u0012\u0011\u0007a\u0001\u0003w\tqA\u00197pG.LE\r\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005B\u0001\bgR|'/Y4f\u0013\u0011\t)%a\u0010\u0003\u000f\tcwnY6JI\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013AC<sCB\u001cFO]3b[R1\u0011QJA.\u0003;\u0002B!a\u0014\u0002X5\u0011\u0011\u0011\u000b\u0006\u0004W\u0006M#BAA+\u0003\u0011Q\u0017M^1\n\t\u0005e\u0013\u0011\u000b\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0002:\u0005\u001d\u0003\u0019AA\u001e\u0011!\ty&a\u0012A\u0002\u00055\u0013!A:\t\u000f\u0005%\u0003\u0001\"\u0001\u0002dQ1\u0011QMA6\u0003[\u0002B!a\u0014\u0002h%!\u0011\u0011NA)\u00051yU\u000f\u001e9viN#(/Z1n\u0011!\tI$!\u0019A\u0002\u0005m\u0002\u0002CA0\u0003C\u0002\r!!\u001a\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u0005\trO]1q\r>\u0014XI\\2ssB$\u0018n\u001c8\u0015\t\u00055\u0013Q\u000f\u0005\t\u0003?\ny\u00071\u0001\u0002N!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005eD\u0003BA3\u0003wB\u0001\"a\u0018\u0002x\u0001\u0007\u0011Q\r\u0005\b\u0003\u007f\u0002A\u0011AAA\u0003I9(/\u00199G_J\u001cu.\u001c9sKN\u001c\u0018n\u001c8\u0015\r\u0005\u0015\u00141QAC\u0011!\tI$! A\u0002\u0005m\u0002\u0002CA0\u0003{\u0002\r!!\u001a\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\nR1\u0011QJAF\u0003\u001bC\u0001\"!\u000f\u0002\b\u0002\u0007\u00111\b\u0005\t\u0003?\n9\t1\u0001\u0002N!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0015a\u00053bi\u0006\u001cVM]5bY&TXm\u0015;sK\u0006lW\u0003BAK\u0003O#\u0002\"a&\u0002,\u00065\u0016\u0011\u0017\u000b\u0005\u00033\u000by\nE\u0002\r\u00037K1!!(\u000e\u0005\u0011)f.\u001b;\t\u0015\u0005\u0005\u0016qRA\u0001\u0002\b\t\u0019+\u0001\u0006fm&$WM\\2fIE\u0002B\u0001P \u0002&B\u0019\u0001+a*\u0005\u000f\u0005%\u0016q\u0012b\u0001'\n\tA\u000b\u0003\u0005\u0002:\u0005=\u0005\u0019AA\u001e\u0011!\ty+a$A\u0002\u0005\u0015\u0014\u0001D8viB,Ho\u0015;sK\u0006l\u0007\u0002CAZ\u0003\u001f\u0003\r!!.\u0002\rY\fG.^3t!\u0019\t9,a2\u0002&:!\u0011\u0011XAb\u001d\u0011\tY,!1\u000e\u0005\u0005u&bAA`'\u00051AH]8pizJ\u0011AD\u0005\u0004\u0003\u000bl\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\fYM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t)-\u0004\u0005\b\u0003\u001f\u0004A\u0011AAi\u00035!\u0017\r^1TKJL\u0017\r\\5{KV!\u00111[Aw)\u0019\t).a<\u0002rR!\u0011q[As!\u0011\tI.!9\u000e\u0005\u0005m'bA6\u0002^*\u0019\u0011q\u001c\u0003\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\fYNA\tDQVt7.\u001a3CsR,')\u001e4gKJD!\"a:\u0002N\u0006\u0005\t9AAu\u0003))g/\u001b3f]\u000e,GE\r\t\u0005y}\nY\u000fE\u0002Q\u0003[$q!!+\u0002N\n\u00071\u000b\u0003\u0005\u0002:\u00055\u0007\u0019AA\u001e\u0011!\t\u0019,!4A\u0002\u0005M\bCBA\\\u0003\u000f\fY\u000fC\u0004\u0002x\u0002!\t!!?\u0002C\u0011\fG/Y*fe&\fG.\u001b>f/&$\b.\u0012=qY&\u001c\u0017\u000e^\"mCN\u001cH+Y4\u0015\u0011\u0005]\u00171`A\u007f\u0005\u0013A\u0001\"!\u000f\u0002v\u0002\u0007\u00111\b\u0005\t\u0003g\u000b)\u00101\u0001\u0002\u0000B\"!\u0011\u0001B\u0003!\u0019\t9,a2\u0003\u0004A\u0019\u0001K!\u0002\u0005\u0017\t\u001d\u0011Q`A\u0001\u0002\u0003\u0015\ta\u0015\u0002\u0004?\u0012:\u0004\u0002\u0003B\u0006\u0003k\u0004\rA!\u0004\u0002\u0011\rd\u0017m]:UC\u001e\u0004DAa\u0004\u0003\u0014A!Ah\u0010B\t!\r\u0001&1\u0003\u0003\f\u0005+\u0011I!!A\u0001\u0002\u000b\u00051KA\u0002`IaBqA!\u0007\u0001\t\u0003\u0011Y\"A\u000beCR\fG)Z:fe&\fG.\u001b>f'R\u0014X-Y7\u0016\t\tu!Q\u0005\u000b\u0007\u0005?\u0011YC!\f\u0015\t\t\u0005\"q\u0005\t\u0007\u0003o\u000b9Ma\t\u0011\u0007A\u0013)\u0003B\u0004\u0002*\n]!\u0019A*\t\u0011\t-!q\u0003a\u0001\u0005S\u0001B\u0001P \u0003$!A\u0011\u0011\bB\f\u0001\u0004\tY\u0004\u0003\u0005\u00030\t]\u0001\u0019AA'\u0003-Ig\u000e];u'R\u0014X-Y7")
public class SerializerManager {
    private final Serializer defaultSerializer;
    public final SparkConf org$apache$spark$serializer$SerializerManager$$conf;
    private final Option<byte[]> encryptionKey;
    private final KryoSerializer kryoSerializer;
    private final ClassTag<String> stringClassTag;
    private final Set<ClassTag<?>> primitiveAndPrimitiveArrayClassTags;
    private final boolean compressBroadcast;
    private final boolean compressShuffle;
    private final boolean compressRdds;
    private final boolean compressShuffleSpill;
    private CompressionCodec compressionCodec;
    private volatile boolean bitmap$0;

    private CompressionCodec compressionCodec$lzycompute() {
        SerializerManager serializerManager = this;
        synchronized (serializerManager) {
            if (!this.bitmap$0) {
                this.compressionCodec = CompressionCodec$.MODULE$.createCodec(this.org$apache$spark$serializer$SerializerManager$$conf);
                this.bitmap$0 = true;
            }
            return this.compressionCodec;
        }
    }

    private CompressionCodec compressionCodec() {
        return this.bitmap$0 ? this.compressionCodec : this.compressionCodec$lzycompute();
    }

    public boolean encryptionEnabled() {
        return this.encryptionKey.isDefined();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseKryo(ClassTag<?> ct) {
        if (this.primitiveAndPrimitiveArrayClassTags.contains(ct)) return true;
        ClassTag<?> classTag = ct;
        ClassTag<String> classTag2 = this.stringClassTag;
        if (classTag != null) {
            if (!classTag.equals(classTag2)) return false;
            return true;
        }
        if (classTag2 == null) return true;
        return false;
    }

    public Serializer getSerializer(ClassTag<?> ct, boolean autoPick) {
        return autoPick && this.canUseKryo(ct) ? this.kryoSerializer : this.defaultSerializer;
    }

    public Serializer getSerializer(ClassTag<?> keyClassTag, ClassTag<?> valueClassTag) {
        return this.canUseKryo(keyClassTag) && this.canUseKryo(valueClassTag) ? this.kryoSerializer : this.defaultSerializer;
    }

    private boolean shouldCompress(BlockId blockId) {
        BlockId blockId2 = blockId;
        boolean bl = blockId2 instanceof ShuffleBlockId ? this.compressShuffle : (blockId2 instanceof BroadcastBlockId ? this.compressBroadcast : (blockId2 instanceof RDDBlockId ? this.compressRdds : (blockId2 instanceof TempLocalBlockId ? this.compressShuffleSpill : (blockId2 instanceof TempShuffleBlockId ? this.compressShuffle : false))));
        return bl;
    }

    public InputStream wrapStream(BlockId blockId, InputStream s) {
        return this.wrapForCompression(blockId, this.wrapForEncryption(s));
    }

    public OutputStream wrapStream(BlockId blockId, OutputStream s) {
        return this.wrapForCompression(blockId, this.wrapForEncryption(s));
    }

    public InputStream wrapForEncryption(InputStream s) {
        return (InputStream)this.encryptionKey.map((Function1)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SerializerManager $outer;
            private final InputStream s$2;

            public final InputStream apply(byte[] key) {
                return CryptoStreamUtils$.MODULE$.createCryptoInputStream(this.s$2, this.$outer.org$apache$spark$serializer$SerializerManager$$conf, key);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.s$2 = s$2;
            }
        }).getOrElse((Function0)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final InputStream s$2;

            public final InputStream apply() {
                return this.s$2;
            }
            {
                this.s$2 = s$2;
            }
        });
    }

    public OutputStream wrapForEncryption(OutputStream s) {
        return (OutputStream)this.encryptionKey.map((Function1)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SerializerManager $outer;
            private final OutputStream s$1;

            public final OutputStream apply(byte[] key) {
                return CryptoStreamUtils$.MODULE$.createCryptoOutputStream(this.s$1, this.$outer.org$apache$spark$serializer$SerializerManager$$conf, key);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.s$1 = s$1;
            }
        }).getOrElse((Function0)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final OutputStream s$1;

            public final OutputStream apply() {
                return this.s$1;
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    public OutputStream wrapForCompression(BlockId blockId, OutputStream s) {
        return this.shouldCompress(blockId) ? this.compressionCodec().compressedOutputStream(s) : s;
    }

    public InputStream wrapForCompression(BlockId blockId, InputStream s) {
        return this.shouldCompress(blockId) ? this.compressionCodec().compressedInputStream(s) : s;
    }

    public <T> void dataSerializeStream(BlockId blockId, OutputStream outputStream, Iterator<T> values2, ClassTag<T> evidence$1) {
        BufferedOutputStream byteStream = new BufferedOutputStream(outputStream);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        SerializerInstance ser = this.getSerializer((ClassTag)Predef$.MODULE$.implicitly(evidence$1), autoPick).newInstance();
        ser.serializeStream(this.wrapForCompression(blockId, byteStream)).writeAll(values2, evidence$1).close();
    }

    public <T> ChunkedByteBuffer dataSerialize(BlockId blockId, Iterator<T> values2, ClassTag<T> evidence$2) {
        return this.dataSerializeWithExplicitClassTag(blockId, values2, (ClassTag)Predef$.MODULE$.implicitly(evidence$2));
    }

    public ChunkedByteBuffer dataSerializeWithExplicitClassTag(BlockId blockId, Iterator<?> values2, ClassTag<?> classTag) {
        ChunkedByteBufferOutputStream bbos = new ChunkedByteBufferOutputStream(0x400000, (Function1<Object, ByteBuffer>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ByteBuffer apply(int x$1) {
                return ByteBuffer.allocate(x$1);
            }
        });
        BufferedOutputStream byteStream = new BufferedOutputStream(bbos);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        SerializerInstance ser = this.getSerializer(classTag, autoPick).newInstance();
        ser.serializeStream(this.wrapForCompression(blockId, byteStream)).writeAll(values2, ClassTag$.MODULE$.apply(Object.class)).close();
        return bbos.toChunkedByteBuffer();
    }

    public <T> Iterator<T> dataDeserializeStream(BlockId blockId, InputStream inputStream, ClassTag<T> classTag) {
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        return this.getSerializer(classTag, autoPick).newInstance().deserializeStream(this.wrapForCompression(blockId, inputStream)).asIterator();
    }

    public SerializerManager(Serializer defaultSerializer, SparkConf conf, Option<byte[]> encryptionKey) {
        this.defaultSerializer = defaultSerializer;
        this.org$apache$spark$serializer$SerializerManager$$conf = conf;
        this.encryptionKey = encryptionKey;
        this.kryoSerializer = new KryoSerializer(conf);
        this.stringClassTag = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(String.class));
        Set primitiveClassTags = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassTag[]{ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.Byte(), ClassTag$.MODULE$.Char(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Float(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Null(), ClassTag$.MODULE$.Short()}));
        Set arrayClassTags = (Set)primitiveClassTags.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ClassTag<Object> apply(ClassTag<?> x$1) {
                return x$1.wrap();
            }
        }, Set$.MODULE$.canBuildFrom());
        this.primitiveAndPrimitiveArrayClassTags = (Set)primitiveClassTags.$plus$plus((GenTraversableOnce)arrayClassTags);
        this.compressBroadcast = conf.getBoolean("spark.broadcast.compress", true);
        this.compressShuffle = conf.getBoolean("spark.shuffle.compress", true);
        this.compressRdds = conf.getBoolean("spark.rdd.compress", false);
        this.compressShuffleSpill = conf.getBoolean("spark.shuffle.spill.compress", true);
    }

    public SerializerManager(Serializer defaultSerializer, SparkConf conf) {
        this(defaultSerializer, conf, (Option<byte[]>)None$.MODULE$);
    }
}

