/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.http;

import org.spark_project.jetty.http.BadMessageException;
import org.spark_project.jetty.http.HttpField;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.util.StringUtil;

public class HostPortHttpField
extends HttpField {
    private final String _host;
    private final int _port;

    public HostPortHttpField(String authority) {
        this(HttpHeader.HOST, HttpHeader.HOST.asString(), authority);
    }

    public HostPortHttpField(HttpHeader header, String name2, String authority) {
        super(header, name2, authority);
        if (authority == null || authority.length() == 0) {
            throw new IllegalArgumentException("No Authority");
        }
        try {
            if (authority.charAt(0) == '[') {
                int close2 = authority.lastIndexOf(93);
                if (close2 < 0) {
                    throw new BadMessageException(400, "Bad ipv6");
                }
                this._host = authority.substring(0, close2 + 1);
                if (authority.length() > close2 + 1) {
                    if (authority.charAt(close2 + 1) != ':') {
                        throw new BadMessageException(400, "Bad ipv6 port");
                    }
                    this._port = StringUtil.toInt(authority, close2 + 2);
                } else {
                    this._port = 0;
                }
            } else {
                int c = authority.lastIndexOf(58);
                if (c >= 0) {
                    this._host = authority.substring(0, c);
                    this._port = StringUtil.toInt(authority, c + 1);
                } else {
                    this._host = authority;
                    this._port = 0;
                }
            }
        }
        catch (BadMessageException bm) {
            throw bm;
        }
        catch (Exception e) {
            throw new BadMessageException(400, "Bad HostPort", e);
        }
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }
}

