/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.http;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.spark_project.jetty.http.Http1FieldPreEncoder;
import org.spark_project.jetty.http.HttpField;
import org.spark_project.jetty.http.HttpFieldPreEncoder;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.http.HttpVersion;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class PreEncodedHttpField
extends HttpField {
    private static final Logger LOG = Log.getLogger(PreEncodedHttpField.class);
    private static final HttpFieldPreEncoder[] __encoders;
    private final byte[][] _encodedField = new byte[2][];

    public PreEncodedHttpField(HttpHeader header, String name2, String value2) {
        super(header, name2, value2);
        HttpFieldPreEncoder[] httpFieldPreEncoderArray = __encoders;
        int n = httpFieldPreEncoderArray.length;
        for (int i = 0; i < n; ++i) {
            HttpFieldPreEncoder e;
            this._encodedField[(e = httpFieldPreEncoderArray[i]).getHttpVersion() == HttpVersion.HTTP_2 ? 1 : 0] = e.getEncodedField(header, header.asString(), value2);
        }
    }

    public PreEncodedHttpField(HttpHeader header, String value2) {
        this(header, header.asString(), value2);
    }

    public PreEncodedHttpField(String name2, String value2) {
        this(null, name2, value2);
    }

    public void putTo(ByteBuffer bufferInFillMode, HttpVersion version) {
        bufferInFillMode.put(this._encodedField[version == HttpVersion.HTTP_2 ? 1 : 0]);
    }

    static {
        ArrayList<HttpFieldPreEncoder> encoders = new ArrayList<HttpFieldPreEncoder>();
        Iterator<HttpFieldPreEncoder> iter = ServiceLoader.load(HttpFieldPreEncoder.class, PreEncodedHttpField.class.getClassLoader()).iterator();
        while (iter.hasNext()) {
            try {
                encoders.add(iter.next());
            }
            catch (Error | RuntimeException e) {
                LOG.debug(e);
            }
        }
        if (encoders.size() == 0) {
            encoders.add(new Http1FieldPreEncoder());
        }
        LOG.debug("HttpField encoders loaded: {}", encoders);
        __encoders = encoders.toArray(new HttpFieldPreEncoder[encoders.size()]);
    }
}

