/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.util;

import org.spark_project.jetty.util.log.Log;

public interface Promise<C> {
    public void succeeded(C var1);

    public void failed(Throwable var1);

    public static abstract class Wrapper<W>
    implements Promise<W> {
        private final Promise<W> promise;

        public Wrapper(Promise<W> promise) {
            this.promise = promise;
        }

        public Promise<W> getPromise() {
            return this.promise;
        }

        public Promise<W> unwrap() {
            Promise<W> result2 = this.promise;
            while (result2 instanceof Wrapper) {
                result2 = ((Wrapper)result2).unwrap();
            }
            return result2;
        }
    }

    public static class Adapter<C>
    implements Promise<C> {
        @Override
        public void succeeded(C result2) {
        }

        @Override
        public void failed(Throwable x) {
            Log.getLogger(this.getClass()).warn(x);
        }
    }
}

