/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.util.Distribution;
import org.apache.spark.util.Distribution$;
import org.apache.spark.util.StatCounter;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

public final class StatsReportListener$
implements Logging {
    public static final StatsReportListener$ MODULE$;
    private final int[] percentiles;
    private final double[] probabilities;
    private final String percentilesHeader;
    private final long seconds;
    private final long minutes;
    private final long hours;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StatsReportListener$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public int[] percentiles() {
        return this.percentiles;
    }

    public double[] probabilities() {
        return this.probabilities;
    }

    public String percentilesHeader() {
        return this.percentilesHeader;
    }

    public Option<Distribution> extractDoubleDistribution(Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics, Function2<TaskInfo, TaskMetrics, Object> getMetric) {
        return Distribution$.MODULE$.apply((Traversable<Object>)((Traversable)taskInfoMetrics.map((Function1)new Serializable(getMetric){
            public static final long serialVersionUID = 0L;
            private final Function2 getMetric$1;

            public final double apply(Tuple2<TaskInfo, TaskMetrics> x0$2) {
                Tuple2<TaskInfo, TaskMetrics> tuple2 = x0$2;
                if (tuple2 != null) {
                    TaskInfo info = (TaskInfo)tuple2._1();
                    TaskMetrics metric = (TaskMetrics)tuple2._2();
                    double d = BoxesRunTime.unboxToDouble((Object)this.getMetric$1.apply((Object)info, (Object)metric));
                    return d;
                }
                throw new MatchError(tuple2);
            }
            {
                this.getMetric$1 = getMetric$1;
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Option<Distribution> extractLongDistribution(Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics, Function2<TaskInfo, TaskMetrics, Object> getMetric) {
        return this.extractDoubleDistribution(taskInfoMetrics, (Function2<TaskInfo, TaskMetrics, Object>)new Serializable(getMetric){
            public static final long serialVersionUID = 0L;
            private final Function2 getMetric$2;

            public final double apply(TaskInfo info, TaskMetrics metric) {
                return BoxesRunTime.unboxToLong((Object)this.getMetric$2.apply((Object)info, (Object)metric));
            }
            {
                this.getMetric$2 = getMetric$2;
            }
        });
    }

    public void showDistribution(String heading, Distribution d, Function1<Object, String> formatNumber) {
        StatCounter stats2 = d.statCounter();
        IndexedSeq quantiles = (IndexedSeq)d.getQuantiles((Traversable<Object>)Predef$.MODULE$.wrapDoubleArray(this.probabilities())).map(formatNumber, IndexedSeq$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)new Serializable(heading, stats2){
            public static final long serialVersionUID = 0L;
            private final String heading$3;
            private final StatCounter stats$1;

            public final String apply() {
                return new StringBuilder().append((Object)this.heading$3).append((Object)this.stats$1).toString();
            }
            {
                this.heading$3 = heading$3;
                this.stats$1 = stats$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return StatsReportListener$.MODULE$.percentilesHeader();
            }
        });
        this.logInfo((Function0<String>)new Serializable(quantiles){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq quantiles$1;

            public final String apply() {
                return new StringBuilder().append((Object)"\t").append((Object)this.quantiles$1.mkString("\t")).toString();
            }
            {
                this.quantiles$1 = quantiles$1;
            }
        });
    }

    public void showDistribution(String heading, Option<Distribution> dOpt, Function1<Object, String> formatNumber) {
        dOpt.foreach((Function1)new Serializable(heading, formatNumber){
            public static final long serialVersionUID = 0L;
            private final String heading$2;
            private final Function1 formatNumber$1;

            public final void apply(Distribution d) {
                StatsReportListener$.MODULE$.showDistribution(this.heading$2, d, (Function1<Object, String>)this.formatNumber$1);
            }
            {
                this.heading$2 = heading$2;
                this.formatNumber$1 = formatNumber$1;
            }
        });
    }

    public void showDistribution(String heading, Option<Distribution> dOpt, String format2) {
        this.showDistribution(heading, dOpt, (Function1<Object, String>)new Serializable(format2){
            public static final long serialVersionUID = 0L;
            private final String format$1;

            public final String apply(double d) {
                return StatsReportListener$.MODULE$.org$apache$spark$scheduler$StatsReportListener$$f$1(d, this.format$1);
            }
            {
                this.format$1 = format$1;
            }
        });
    }

    public void showDistribution(String heading, String format2, Function2<TaskInfo, TaskMetrics, Object> getMetric, Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics) {
        this.showDistribution(heading, this.extractDoubleDistribution(taskInfoMetrics, getMetric), format2);
    }

    public void showBytesDistribution(String heading, Function2<TaskInfo, TaskMetrics, Object> getMetric, Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics) {
        this.showBytesDistribution(heading, this.extractLongDistribution(taskInfoMetrics, getMetric));
    }

    public void showBytesDistribution(String heading, Option<Distribution> dOpt) {
        dOpt.foreach((Function1)new Serializable(heading){
            public static final long serialVersionUID = 0L;
            private final String heading$1;

            public final void apply(Distribution dist) {
                StatsReportListener$.MODULE$.showBytesDistribution(this.heading$1, dist);
            }
            {
                this.heading$1 = heading$1;
            }
        });
    }

    public void showBytesDistribution(String heading, Distribution dist) {
        this.showDistribution(heading, dist, (Function1<Object, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(double d) {
                return Utils$.MODULE$.bytesToString((long)d);
            }
        });
    }

    public void showMillisDistribution(String heading, Option<Distribution> dOpt) {
        this.showDistribution(heading, dOpt, (Function1<Object, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(double d) {
                return StatsReportListener$.MODULE$.millisToString((long)d);
            }
        });
    }

    public void showMillisDistribution(String heading, Function2<TaskInfo, TaskMetrics, Object> getMetric, Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics) {
        this.showMillisDistribution(heading, this.extractLongDistribution(taskInfoMetrics, getMetric));
    }

    public long seconds() {
        return this.seconds;
    }

    public long minutes() {
        return this.minutes;
    }

    public long hours() {
        return this.hours;
    }

    public String millisToString(long ms) {
        Tuple2 tuple2;
        Tuple2 tuple22 = ms > this.hours() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)ms / (double)this.hours())), (Object)"hours") : (ms > this.minutes() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)ms / (double)this.minutes())), (Object)"min") : (tuple2 = ms > this.seconds() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)ms / (double)this.seconds())), (Object)"s") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)ms), (Object)"ms")));
        if (tuple2 != null) {
            Tuple2 tuple23;
            double size = tuple2._1$mcD$sp();
            String units = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)size), (Object)units);
            double size2 = tuple24._1$mcD$sp();
            String units2 = (String)tuple24._2();
            return new StringOps(Predef$.MODULE$.augmentString("%.1f %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)size2), units2}));
        }
        throw new MatchError((Object)tuple2);
    }

    public final String org$apache$spark$scheduler$StatsReportListener$$f$1(double d, String format$1) {
        return new StringOps(Predef$.MODULE$.augmentString(format$1)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)d)}));
    }

    private StatsReportListener$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.percentiles = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 5, 10, 25, 50, 75, 90, 95, 100}), ClassTag$.MODULE$.Int());
        this.probabilities = (double[])Predef$.MODULE$.intArrayOps(this.percentiles()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int x$11) {
                return this.apply$mcDI$sp(x$11);
            }

            public double apply$mcDI$sp(int x$11) {
                return (double)x$11 / 100.0;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        this.percentilesHeader = new StringBuilder().append((Object)"\t").append((Object)Predef$.MODULE$.intArrayOps(this.percentiles()).mkString("%\t")).append((Object)"%").toString();
        this.seconds = 1000L;
        this.minutes = this.seconds() * 60L;
        this.hours = this.minutes() * 60L;
    }
}

