/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics.sink;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.sink.Sink;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea!\u0002\u0010 \u0001\rJ\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011}\u0002!\u0011!Q\u0001\n]B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!\u0011\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0005\"AA\n\u0001B\u0001B\u0003%Q\nC\u0003R\u0001\u0011\u0005!\u000bC\u0004X\u0001\t\u0007I\u0011\u0001-\t\r}\u0003\u0001\u0015!\u0003Z\u0011\u001d\u0001\u0007A1A\u0005\u0002aCa!\u0019\u0001!\u0002\u0013I\u0006b\u00022\u0001\u0005\u0004%\t\u0001\u0017\u0005\u0007G\u0002\u0001\u000b\u0011B-\t\u000f\u0011\u0004!\u0019!C\u0001K\"1\u0011\u000e\u0001Q\u0001\n\u0019DqA\u001b\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004l\u0001\u0001\u0006I!\u0017\u0005\bY\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019i\u0007\u0001)A\u00053\"9a\u000e\u0001b\u0001\n\u0003)\u0007BB8\u0001A\u0003%a\rC\u0004q\u0001\t\u0007I\u0011A9\t\ra\u0004\u0001\u0015!\u0003s\u0011\u001dI\bA1A\u0005\u0002aCaA\u001f\u0001!\u0002\u0013I\u0006bB>\u0001\u0005\u0004%\t\u0001 \u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003~\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\u0004\u0001\t\u0003\n)\u0001C\u0004\u0002\u0010\u0001!\t%!\u0002\u0003\u000f\r\u001bhoU5oW*\u0011\u0001%I\u0001\u0005g&t7N\u0003\u0002#G\u00059Q.\u001a;sS\u000e\u001c(B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0014\u0007\u0001Q\u0003\u0007\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VM\u001a\t\u0003cIj\u0011aH\u0005\u0003g}\u0011AaU5oW\u0006A\u0001O]8qKJ$\u0018p\u0001\u0001\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014H\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\u001d:pa\u0016\u0014H/\u001f\u0011\u0002\u0011I,w-[:uef,\u0012A\u0011\t\u0003\u0007&k\u0011\u0001\u0012\u0006\u0003E\u0015S!AR$\u0002\u0011\r|G-\u00195bY\u0016T\u0011\u0001S\u0001\u0004G>l\u0017B\u0001&E\u00059iU\r\u001e:jGJ+w-[:uef\f\u0011B]3hSN$(/\u001f\u0011\u0002\u0017M,7-\u001e:jifluM\u001d\t\u0003\u001d>k\u0011aI\u0005\u0003!\u000e\u0012qbU3dkJLG/_'b]\u0006<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM#VK\u0016\t\u0003c\u0001AQ\u0001\u000e\u0004A\u0002]BQ\u0001\u0011\u0004A\u0002\tCQ\u0001\u0014\u0004A\u00025\u000babQ*W?.+\u0015l\u0018)F%&{E)F\u0001Z!\tQV,D\u0001\\\u0015\ta6(\u0001\u0003mC:<\u0017B\u00010\\\u0005\u0019\u0019FO]5oO\u0006y1i\u0015,`\u0017\u0016Kv\fU#S\u0013>#\u0005%\u0001\u0007D'Z{6*R-`+:KE+A\u0007D'Z{6*R-`+:KE\u000bI\u0001\f\u0007N3vlS#Z?\u0012K%+\u0001\u0007D'Z{6*R-`\t&\u0013\u0006%\u0001\nD'Z{F)\u0012$B+2#v\fU#S\u0013>#U#\u00014\u0011\u0005-:\u0017B\u00015-\u0005\rIe\u000e^\u0001\u0014\u0007N3v\fR#G\u0003VcEk\u0018)F%&{E\tI\u0001\u0011\u0007N3v\fR#G\u0003VcEkX+O\u0013R\u000b\u0011cQ*W?\u0012+e)Q+M)~+f*\u0013+!\u0003=\u00195KV0E\u000b\u001a\u000bU\u000b\u0014+`\t&\u0013\u0016\u0001E\"T-~#UIR!V\u0019R{F)\u0013*!\u0003)\u0001x\u000e\u001c7QKJLw\u000eZ\u0001\fa>dG\u000eU3sS>$\u0007%\u0001\u0005q_2dWK\\5u+\u0005\u0011\bCA:w\u001b\u0005!(BA;:\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003oR\u0014\u0001\u0002V5nKVs\u0017\u000e^\u0001\na>dG.\u00168ji\u0002\nq\u0001]8mY\u0012K'/\u0001\u0005q_2dG)\u001b:!\u0003!\u0011X\r]8si\u0016\u0014X#A?\u0011\u0005\rs\u0018BA@E\u0005-\u00195O\u001e*fa>\u0014H/\u001a:\u0002\u0013I,\u0007o\u001c:uKJ\u0004\u0013!B:uCJ$HCAA\u0004!\rY\u0013\u0011B\u0005\u0004\u0003\u0017a#\u0001B+oSR\fAa\u001d;pa\u00061!/\u001a9peR\u0004")
public class CsvSink
implements Sink {
    private final Properties property;
    private final MetricRegistry registry;
    private final String CSV_KEY_PERIOD;
    private final String CSV_KEY_UNIT;
    private final String CSV_KEY_DIR;
    private final int CSV_DEFAULT_PERIOD;
    private final String CSV_DEFAULT_UNIT;
    private final String CSV_DEFAULT_DIR;
    private final int pollPeriod;
    private final TimeUnit pollUnit;
    private final String pollDir;
    private final CsvReporter reporter;

    public Properties property() {
        return this.property;
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public String CSV_KEY_PERIOD() {
        return this.CSV_KEY_PERIOD;
    }

    public String CSV_KEY_UNIT() {
        return this.CSV_KEY_UNIT;
    }

    public String CSV_KEY_DIR() {
        return this.CSV_KEY_DIR;
    }

    public int CSV_DEFAULT_PERIOD() {
        return this.CSV_DEFAULT_PERIOD;
    }

    public String CSV_DEFAULT_UNIT() {
        return this.CSV_DEFAULT_UNIT;
    }

    public String CSV_DEFAULT_DIR() {
        return this.CSV_DEFAULT_DIR;
    }

    public int pollPeriod() {
        return this.pollPeriod;
    }

    public TimeUnit pollUnit() {
        return this.pollUnit;
    }

    public String pollDir() {
        return this.pollDir;
    }

    public CsvReporter reporter() {
        return this.reporter;
    }

    @Override
    public void start() {
        this.reporter().start((long)this.pollPeriod(), this.pollUnit());
    }

    @Override
    public void stop() {
        this.reporter().stop();
    }

    @Override
    public void report() {
        this.reporter().report();
    }

    public CsvSink(Properties property, MetricRegistry registry, SecurityManager securityMgr) {
        String string;
        TimeUnit timeUnit;
        int n;
        this.property = property;
        this.registry = registry;
        this.CSV_KEY_PERIOD = "period";
        this.CSV_KEY_UNIT = "unit";
        this.CSV_KEY_DIR = "directory";
        this.CSV_DEFAULT_PERIOD = 10;
        this.CSV_DEFAULT_UNIT = "SECONDS";
        this.CSV_DEFAULT_DIR = "/tmp/";
        Option option = Option$.MODULE$.apply((Object)property.getProperty(this.CSV_KEY_PERIOD()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            n = new StringOps(Predef$.MODULE$.augmentString(s)).toInt();
        } else if (None$.MODULE$.equals(option)) {
            n = this.CSV_DEFAULT_PERIOD();
        } else {
            throw new MatchError((Object)option);
        }
        this.pollPeriod = n;
        Option option2 = Option$.MODULE$.apply((Object)property.getProperty(this.CSV_KEY_UNIT()));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String s = (String)some.value();
            timeUnit = TimeUnit.valueOf(s.toUpperCase(Locale.ROOT));
        } else if (None$.MODULE$.equals(option2)) {
            timeUnit = TimeUnit.valueOf(this.CSV_DEFAULT_UNIT());
        } else {
            throw new MatchError((Object)option2);
        }
        this.pollUnit = timeUnit;
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(this.pollUnit(), this.pollPeriod());
        Option option3 = Option$.MODULE$.apply((Object)property.getProperty(this.CSV_KEY_DIR()));
        if (option3 instanceof Some) {
            String s;
            Some some = (Some)option3;
            string = s = (String)some.value();
        } else if (None$.MODULE$.equals(option3)) {
            string = this.CSV_DEFAULT_DIR();
        } else {
            throw new MatchError((Object)option3);
        }
        this.pollDir = string;
        this.reporter = CsvReporter.forRegistry((MetricRegistry)registry).formatFor(Locale.US).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build(new File(this.pollDir()));
    }
}

