/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.api.SingleSpillShuffleMapOutputWriter;
import org.apache.spark.util.Utils;

public class LocalDiskSingleSpillMapOutputWriter
implements SingleSpillShuffleMapOutputWriter {
    private final int shuffleId;
    private final long mapId;
    private final IndexShuffleBlockResolver blockResolver;

    public LocalDiskSingleSpillMapOutputWriter(int shuffleId, long mapId, IndexShuffleBlockResolver blockResolver) {
        this.shuffleId = shuffleId;
        this.mapId = mapId;
        this.blockResolver = blockResolver;
    }

    @Override
    public void transferMapSpillFile(File mapSpillFile, long[] partitionLengths) throws IOException {
        File outputFile = this.blockResolver.getDataFile(this.shuffleId, this.mapId);
        File tempFile = Utils.tempFileWith(outputFile);
        Files.move(mapSpillFile.toPath(), tempFile.toPath(), new CopyOption[0]);
        this.blockResolver.writeIndexFileAndCommit(this.shuffleId, this.mapId, partitionLengths, tempFile);
    }
}

