/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.buffer;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.spark-project.guava.base.Objects;

public final class NioManagedBuffer
extends ManagedBuffer {
    private final ByteBuffer buf;

    public NioManagedBuffer(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public long size() {
        return this.buf.remaining();
    }

    @Override
    public ByteBuffer nioByteBuffer() throws IOException {
        return this.buf.duplicate();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return new ByteBufInputStream(Unpooled.wrappedBuffer((ByteBuffer)this.buf));
    }

    @Override
    public ManagedBuffer retain() {
        return this;
    }

    @Override
    public ManagedBuffer release() {
        return this;
    }

    @Override
    public Object convertToNetty() throws IOException {
        return Unpooled.wrappedBuffer((ByteBuffer)this.buf);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("buf", this.buf).toString();
    }
}

