/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.crypto.AuthEngine;
import org.apache.spark.network.crypto.ClientChallenge;
import org.apache.spark.network.crypto.ServerResponse;
import org.apache.spark.network.sasl.SaslRpcHandler;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.base.Throwables;

class AuthRpcHandler
extends RpcHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthRpcHandler.class);
    private final TransportConf conf;
    private final Channel channel;
    @VisibleForTesting
    RpcHandler delegate;
    private final SecretKeyHolder secretKeyHolder;
    @VisibleForTesting
    boolean doDelegate;

    AuthRpcHandler(TransportConf conf, Channel channel, RpcHandler delegate, SecretKeyHolder secretKeyHolder) {
        this.conf = conf;
        this.channel = channel;
        this.delegate = delegate;
        this.secretKeyHolder = secretKeyHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(TransportClient client, ByteBuffer message, RpcResponseCallback callback) {
        ClientChallenge challenge;
        if (this.doDelegate) {
            this.delegate.receive(client, message, callback);
            return;
        }
        int position = message.position();
        int limit = message.limit();
        try {
            challenge = ClientChallenge.decodeMessage(message);
            LOG.debug("Received new auth challenge for client {}.", (Object)this.channel.remoteAddress());
        }
        catch (RuntimeException e) {
            if (this.conf.saslFallback()) {
                LOG.warn("Failed to parse new auth challenge, reverting to SASL for client {}.", (Object)this.channel.remoteAddress());
                this.delegate = new SaslRpcHandler(this.conf, this.channel, this.delegate, this.secretKeyHolder);
                message.position(position);
                message.limit(limit);
                this.delegate.receive(client, message, callback);
                this.doDelegate = true;
            } else {
                LOG.debug("Unexpected challenge message from client {}, closing channel.", (Object)this.channel.remoteAddress());
                callback.onFailure(new IllegalArgumentException("Unknown challenge message."));
                this.channel.close();
            }
            return;
        }
        AuthEngine engine = null;
        try {
            engine = new AuthEngine(challenge.appId, this.secretKeyHolder.getSecretKey(challenge.appId), this.conf);
            ServerResponse response = engine.respond(challenge);
            ByteBuf responseData = Unpooled.buffer((int)response.encodedLength());
            response.encode(responseData);
            callback.onSuccess(responseData.nioBuffer());
            engine.sessionCipher().addToChannel(this.channel);
        }
        catch (Exception e) {
            LOG.debug("Authentication failed for client {}, closing channel.", (Object)this.channel.remoteAddress());
            callback.onFailure(new IllegalArgumentException("Authentication failed."));
            this.channel.close();
            return;
        }
        finally {
            if (engine != null) {
                try {
                    engine.close();
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            }
        }
        LOG.debug("Authorization successful for client {}.", (Object)this.channel.remoteAddress());
        this.doDelegate = true;
    }

    @Override
    public void receive(TransportClient client, ByteBuffer message) {
        this.delegate.receive(client, message);
    }

    @Override
    public StreamManager getStreamManager() {
        return this.delegate.getStreamManager();
    }

    @Override
    public void channelActive(TransportClient client) {
        this.delegate.channelActive(client);
    }

    @Override
    public void channelInactive(TransportClient client) {
        this.delegate.channelInactive(client);
    }

    @Override
    public void exceptionCaught(Throwable cause, TransportClient client) {
        this.delegate.exceptionCaught(cause, client);
    }
}

