/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.spark.network.shuffle.ShuffleIndexRecord;

public class ShuffleIndexInformation {
    private final LongBuffer offsets;
    private int size;

    public ShuffleIndexInformation(File indexFile) throws IOException {
        this.size = (int)indexFile.length();
        ByteBuffer buffer = ByteBuffer.allocate(this.size);
        this.offsets = buffer.asLongBuffer();
        try (DataInputStream dis = new DataInputStream(Files.newInputStream(indexFile.toPath(), new OpenOption[0]));){
            dis.readFully(buffer.array());
        }
    }

    public int getSize() {
        return this.size;
    }

    public ShuffleIndexRecord getIndex(int reduceId) {
        return this.getIndex(reduceId, reduceId + 1);
    }

    public ShuffleIndexRecord getIndex(int startReduceId, int endReduceId) {
        long offset = this.offsets.get(startReduceId);
        long nextOffset = this.offsets.get(endReduceId);
        return new ShuffleIndexRecord(offset, nextOffset - offset);
    }
}

