/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrameReader$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.execution.LogicalRDD$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.FailureSafeParser;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u0001\u0003\u0001-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0018)\t9Aj\\4hS:<\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!\u0001D*qCJ\\7+Z:tS>t\u0007BB\u0010\u0001\t\u0003\u0011\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0003C\t\u0002\"a\u0007\u0001\t\u000beq\u0002\u0019\u0001\u000e\t\u000b\u0011\u0002A\u0011A\u0013\u0002\r\u0019|'/\\1u)\t\tc\u0005C\u0003(G\u0001\u0007\u0001&\u0001\u0004t_V\u00148-\u001a\t\u0003S1r!!\u0004\u0016\n\u0005-r\u0011A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\b\t\u000bA\u0002A\u0011A\u0019\u0002\rM\u001c\u0007.Z7b)\t\t#\u0007C\u00031_\u0001\u00071\u0007\u0005\u00025o5\tQG\u0003\u00027\u0005\u0005)A/\u001f9fg&\u0011\u0001(\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002\u001e\u0001\t\u0003Y\u0014AB8qi&|g\u000eF\u0002\"yyBQ!P\u001dA\u0002!\n1a[3z\u0011\u0015y\u0014\b1\u0001)\u0003\u00151\u0018\r\\;f\u0011\u0015Q\u0004\u0001\"\u0001B)\r\t#i\u0011\u0005\u0006{\u0001\u0003\r\u0001\u000b\u0005\u0006\u007f\u0001\u0003\r\u0001\u0012\t\u0003\u001b\u0015K!A\u0012\b\u0003\u000f\t{w\u000e\\3b]\")!\b\u0001C\u0001\u0011R\u0019\u0011%\u0013&\t\u000bu:\u0005\u0019\u0001\u0015\t\u000b}:\u0005\u0019A&\u0011\u00055a\u0015BA'\u000f\u0005\u0011auN\\4\t\u000bi\u0002A\u0011A(\u0015\u0007\u0005\u0002\u0016\u000bC\u0003>\u001d\u0002\u0007\u0001\u0006C\u0003@\u001d\u0002\u0007!\u000b\u0005\u0002\u000e'&\u0011AK\u0004\u0002\u0007\t>,(\r\\3\t\u000bY\u0003A\u0011A,\u0002\u000f=\u0004H/[8ogR\u0011\u0011\u0005\u0017\u0005\u0006-V\u0003\r!\u0017\t\u00055vC\u0003&D\u0001\\\u0015\taf\"\u0001\u0006d_2dWm\u0019;j_:L!AX.\u0003\u00075\u000b\u0007\u000fC\u0003W\u0001\u0011\u0005\u0001\r\u0006\u0002\"C\")ak\u0018a\u0001EB!1\r\u001b\u0015)\u001b\u0005!'BA3g\u0003\u0011)H/\u001b7\u000b\u0003\u001d\fAA[1wC&\u0011a\f\u001a\u0005\u0006U\u0002!\ta[\u0001\u0005Y>\fG\rF\u0001m!\ti\u0007O\u0004\u0002\u001c]&\u0011qNA\u0001\ba\u0006\u001c7.Y4f\u0013\t\t(OA\u0005ECR\fgI]1nK*\u0011qN\u0001\u0005\u0006U\u0002!\t\u0001\u001e\u000b\u0003YVDQA^:A\u0002!\nA\u0001]1uQ\")!\u000e\u0001C\u0001qR\u0011A.\u001f\u0005\u0006u^\u0004\ra_\u0001\u0006a\u0006$\bn\u001d\t\u0004\u001bqD\u0013BA?\u000f\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0003o~\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bq\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011BA\u0002\u0005\u001d1\u0018M]1sONDq!!\u0004\u0001\t\u0003\ty!\u0001\u0003kI\n\u001cGc\u00027\u0002\u0012\u0005U\u0011\u0011\u0004\u0005\b\u0003'\tY\u00011\u0001)\u0003\r)(\u000f\u001c\u0005\b\u0003/\tY\u00011\u0001)\u0003\u0015!\u0018M\u00197f\u0011!\tY\"a\u0003A\u0002\u0005u\u0011A\u00039s_B,'\u000f^5fgB\u00191-a\b\n\u0007\u0005\u0005BM\u0001\u0006Qe>\u0004XM\u001d;jKNDq!!\u0004\u0001\t\u0003\t)\u0003F\bm\u0003O\tI#a\u000b\u00020\u0005M\u0012qGA!\u0011\u001d\t\u0019\"a\tA\u0002!Bq!a\u0006\u0002$\u0001\u0007\u0001\u0006C\u0004\u0002.\u0005\r\u0002\u0019\u0001\u0015\u0002\u0015\r|G.^7o\u001d\u0006lW\rC\u0004\u00022\u0005\r\u0002\u0019A&\u0002\u00151|w/\u001a:C_VtG\rC\u0004\u00026\u0005\r\u0002\u0019A&\u0002\u0015U\u0004\b/\u001a:C_VtG\r\u0003\u0005\u0002:\u0005\r\u0002\u0019AA\u001e\u00035qW/\u001c)beRLG/[8ogB\u0019Q\"!\u0010\n\u0007\u0005}bBA\u0002J]RD\u0001\"a\u0011\u0002$\u0001\u0007\u0011QD\u0001\u0015G>tg.Z2uS>t\u0007K]8qKJ$\u0018.Z:\t\u000f\u00055\u0001\u0001\"\u0001\u0002HQIA.!\u0013\u0002L\u00055\u0013q\u000b\u0005\b\u0003'\t)\u00051\u0001)\u0011\u001d\t9\"!\u0012A\u0002!B\u0001\"a\u0014\u0002F\u0001\u0007\u0011\u0011K\u0001\u000baJ,G-[2bi\u0016\u001c\b\u0003B\u0007\u0002T!J1!!\u0016\u000f\u0005\u0015\t%O]1z\u0011!\t\u0019%!\u0012A\u0002\u0005u\u0001bBA.\u0001\u0011\u0005\u0011QL\u0001\u0005UN|g\u000eF\u0002m\u0003?BaA^A-\u0001\u0004A\u0003bBA.\u0001\u0011\u0005\u00111\r\u000b\u0004Y\u0006\u0015\u0004B\u0002>\u0002b\u0001\u00071\u0010K\u0002\u0002b}Dq!a\u0017\u0001\t\u0003\tY\u0007F\u0002m\u0003[B\u0001\"a\u001c\u0002j\u0001\u0007\u0011\u0011O\u0001\bUN|gN\u0015#E!\u0015\t\u0019(a\u001f)\u001b\t\t)HC\u0002h\u0003oR1!!\u001f\u0005\u0003\r\t\u0007/[\u0005\u0005\u0003{\n)HA\u0004KCZ\f'\u000b\u0012#)\u0011\u0005%\u0014\u0011QAD\u0003\u0017\u00032!DAB\u0013\r\t)I\u0004\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAAE\u0003\t*6/\u001a\u0011kg>t\u0007\u0006R1uCN,GoW*ue&tw-X\u0015!S:\u001cH/Z1e]\u0005\u0012\u0011QR\u0001\u0006e9\u0012d\u0006\r\u0005\b\u00037\u0002A\u0011AAI)\ra\u00171\u0013\u0005\t\u0003_\ny\t1\u0001\u0002\u0016B)\u0011qSAOQ5\u0011\u0011\u0011\u0014\u0006\u0004\u00037#\u0011a\u0001:eI&!\u0011qTAM\u0005\r\u0011F\t\u0012\u0015\t\u0003\u001f\u000b\t)a\"\u0002\f\"9\u00111\f\u0001\u0005\u0002\u0005\u0015Fc\u00017\u0002(\"A\u0011\u0011VAR\u0001\u0004\tY+A\u0006kg>tG)\u0019;bg\u0016$\b\u0003B\u000e\u0002.\"J1!a,\u0003\u0005\u001d!\u0015\r^1tKRDq!a-\u0001\t\u0003\t),A\u0002dgZ$2\u0001\\A\\\u0011\u00191\u0018\u0011\u0017a\u0001Q!9\u00111\u0017\u0001\u0005\u0002\u0005mFc\u00017\u0002>\"A\u0011qXA]\u0001\u0004\tY+\u0001\u0006dgZ$\u0015\r^1tKRDq!a-\u0001\t\u0003\t\u0019\rF\u0002m\u0003\u000bDaA_Aa\u0001\u0004Y\bfAAa\u007f\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0017a\u00029beF,X\r\u001e\u000b\u0004Y\u0006=\u0007B\u0002<\u0002J\u0002\u0007\u0001\u0006C\u0004\u0002L\u0002!\t!a5\u0015\u00071\f)\u000e\u0003\u0004{\u0003#\u0004\ra\u001f\u0015\u0004\u0003#|\bbBAn\u0001\u0011\u0005\u0011Q\\\u0001\u0004_J\u001cGc\u00017\u0002`\"1a/!7A\u0002!Bq!a7\u0001\t\u0003\t\u0019\u000fF\u0002m\u0003KDaA_Aq\u0001\u0004Y\bfAAq\u007f\"9\u0011q\u0003\u0001\u0005\u0002\u0005-Hc\u00017\u0002n\"9\u0011q^Au\u0001\u0004A\u0013!\u0003;bE2,g*Y7f\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003k\fA\u0001^3yiR\u0019A.a>\t\rY\f\t\u00101\u0001)\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003w$2\u0001\\A\u007f\u0011\u0019Q\u0018\u0011 a\u0001w\"\u001a\u0011\u0011`@\t\u000f\t\r\u0001\u0001\"\u0001\u0003\u0006\u0005AA/\u001a=u\r&dW\r\u0006\u0003\u0002,\n\u001d\u0001B\u0002<\u0003\u0002\u0001\u0007\u0001\u0006C\u0004\u0003\u0004\u0001!\tAa\u0003\u0015\t\u0005-&Q\u0002\u0005\u0007u\n%\u0001\u0019A>)\u0007\t%q\u0010C\u0004\u0003\u0014\u0001!IA!\u0006\u0002/\u0005\u001c8/\u001a:u\u001d>\u001c\u0006/Z2jM&,GmU2iK6\fG\u0003\u0002B\f\u0005;\u00012!\u0004B\r\u0013\r\u0011YB\u0004\u0002\u0005+:LG\u000fC\u0004\u0003 \tE\u0001\u0019\u0001\u0015\u0002\u0013=\u0004XM]1uS>t\u0007b\u0002B\u0012\u0001\u0011%!QE\u0001 m\u0016\u0014\u0018NZ=D_2,XN\u001c(b[\u0016|emQ8seV\u0004HOU3d_J$GC\u0002B\f\u0005O\u0011I\u0003\u0003\u00041\u0005C\u0001\ra\r\u0005\b\u0005W\u0011\t\u00031\u0001)\u0003e\u0019w\u000e\\;n]:\u000bW.Z(g\u0007>\u0014(/\u001e9u%\u0016\u001cwN\u001d3\t\u0011\u001d\u0002\u0001\u0019!C\u0005\u0005_)\u0012\u0001\u000b\u0005\n\u0005g\u0001\u0001\u0019!C\u0005\u0005k\t!b]8ve\u000e,w\fJ3r)\u0011\u00119Ba\u000e\t\u0013\te\"\u0011GA\u0001\u0002\u0004A\u0013a\u0001=%c!9!Q\b\u0001!B\u0013A\u0013aB:pkJ\u001cW\r\t\u0005\n\u0005\u0003\u0002\u0001\u0019!C\u0005\u0005\u0007\n1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006,\"A!\u0012\u0011\t5\u00119eM\u0005\u0004\u0005\u0013r!AB(qi&|g\u000eC\u0005\u0003N\u0001\u0001\r\u0011\"\u0003\u0003P\u00059Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nC~#S-\u001d\u000b\u0005\u0005/\u0011\t\u0006\u0003\u0006\u0003:\t-\u0013\u0011!a\u0001\u0005\u000bB\u0001B!\u0016\u0001A\u0003&!QI\u0001\u0015kN,'o\u00159fG&4\u0017.\u001a3TG\",W.\u0019\u0011\t\u0013\te\u0003A1A\u0005\n\tm\u0013\u0001D3yiJ\fw\n\u001d;j_:\u001cXC\u0001B/!\u0019\u0011yF!\u001a)Q5\u0011!\u0011\r\u0006\u0004\u0005GZ\u0016aB7vi\u0006\u0014G.Z\u0005\u0005\u0005O\u0012\tGA\u0004ICNDW*\u00199\t\u0011\t-\u0004\u0001)A\u0005\u0005;\nQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0003f\u0001\u0001\u0003pA!!\u0011\u000fB>\u001d\u0011\u0011\u0019Ha\u001e\u000e\u0005\tU$bAA\u0003\t%!!\u0011\u0010B;\u0003IIe\u000e^3sM\u0006\u001cWm\u0015;bE&d\u0017\u000e^=\n\t\tu$q\u0010\u0002\u0007'R\f'\r\\3\u000b\t\te$Q\u000f")
public class DataFrameReader
implements Logging {
    public final SparkSession org$apache$spark$sql$DataFrameReader$$sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private final HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(Seq<String> paths) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SparkSession x$4 = this.org$apache$spark$sql$DataFrameReader$$sparkSession;
        Seq<String> x$5 = paths;
        Option<StructType> x$6 = this.userSpecifiedSchema();
        String x$7 = this.source();
        scala.collection.immutable.Map x$8 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$9 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$10 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$11 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$4, x$7, x$5, x$6, x$9, x$10, (scala.collection.immutable.Map<String, String>)x$8, x$11);
        boolean x$12 = qual$1.resolveRelation$default$1();
        return this.org$apache$spark$sql$DataFrameReader$$sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$12));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)lowerBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)upperBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString())})));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        scala.collection.immutable.Map params = this.extraOptions().toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()).toMap(Predef$.MODULE$.$conforms()));
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])predicates).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Partition apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String part = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    JDBCPartition jDBCPartition = new JDBCPartition(part, i);
                    return jDBCPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        JDBCRelation relation = new JDBCRelation(parts, options, this.org$apache$spark$sql$DataFrameReader$$sparkSession);
        return this.org$apache$spark$sql$DataFrameReader$$sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.org$apache$spark$sql$DataFrameReader$$sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().conf().sessionLocalTimeZone(), this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0)new Serializable(this, jsonDataset, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final Dataset jsonDataset$1;
            private final JSONOptions parsedOptions$1;

            public final StructType apply() {
                return TextInputJsonDataSource$.MODULE$.inferFromDataset(this.jsonDataset$1, this.parsedOptions$1);
            }
            {
                this.jsonDataset$1 = jsonDataset$1;
                this.parsedOptions$1 = parsedOptions$1;
            }
        });
        this.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1)new Serializable(this, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final JSONOptions parsedOptions$1;

            public final boolean apply(StructField x$1) {
                String string = x$1.name();
                String string2 = this.parsedOptions$1.columnNameOfCorruptRecord();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
            }
        }));
        Serializable createParser = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonParser apply(JsonFactory jsonFactory, String record) {
                return CreateJacksonParser$.MODULE$.string(jsonFactory, record);
            }
        };
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1)new Serializable(this, parsedOptions, schema, actualSchema, (Function2)createParser){
            public static final long serialVersionUID = 0L;
            private final JSONOptions parsedOptions$1;
            private final StructType schema$1;
            private final StructType actualSchema$1;
            public final Function2 createParser$1;

            public final Iterator<InternalRow> apply(Iterator<String> iter) {
                JacksonParser rawParser = new JacksonParser(this.actualSchema$1, this.parsedOptions$1);
                FailureSafeParser<IN> parser = new FailureSafeParser<IN>(new Serializable(this, rawParser){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final JacksonParser rawParser$1;

                    public final Seq<InternalRow> apply(String input) {
                        return this.rawParser$1.parse((Object)input, this.$outer.createParser$1, (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final UTF8String apply(String x$1) {
                                return UTF8String.fromString((String)x$1);
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.rawParser$1 = rawParser$1;
                    }
                }, this.parsedOptions$1.parseMode(), this.schema$1, this.parsedOptions$1.columnNameOfCorruptRecord());
                return iter.flatMap((Function1)new Serializable(this, parser){
                    public static final long serialVersionUID = 0L;
                    private final FailureSafeParser parser$1;

                    public final Iterator<InternalRow> apply(String input) {
                        return this.parser$1.parse(input);
                    }
                    {
                        this.parser$1 = parser$1;
                    }
                });
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
                this.schema$1 = schema$1;
                this.actualSchema$1 = actualSchema$1;
                this.createParser$1 = createParser$1;
            }
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$DataFrameReader$$sparkSession, (LogicalPlan)new LogicalRDD((Seq<Attribute>)schema.toAttributes(), (RDD<InternalRow>)parsed, LogicalRDD$.MODULE$.apply$default$3(), LogicalRDD$.MODULE$.apply$default$4(), this.org$apache$spark$sql$DataFrameReader$$sparkSession));
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        CSVOptions parsedOptions = new CSVOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$3());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        Option maybeFirstLine = Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1)).headOption();
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0)new Serializable(this, csvDataset, parsedOptions, maybeFirstLine){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameReader $outer;
            private final Dataset csvDataset$1;
            private final CSVOptions parsedOptions$2;
            private final Option maybeFirstLine$1;

            public final StructType apply() {
                return TextInputCSVDataSource$.MODULE$.inferFromDataset(this.$outer.org$apache$spark$sql$DataFrameReader$$sparkSession, this.csvDataset$1, (Option<String>)this.maybeFirstLine$1, this.parsedOptions$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.csvDataset$1 = csvDataset$1;
                this.parsedOptions$2 = parsedOptions$2;
                this.maybeFirstLine$1 = maybeFirstLine$1;
            }
        });
        this.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1)new Serializable(this, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final CSVOptions parsedOptions$2;

            public final boolean apply(StructField x$2) {
                String string = x$2.name();
                String string2 = this.parsedOptions$2.columnNameOfCorruptRecord();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.parsedOptions$2 = parsedOptions$2;
            }
        }));
        RDD linesWithoutHeader = (RDD)maybeFirstLine.map((Function1)new Serializable(this, parsedOptions, filteredLines){
            public static final long serialVersionUID = 0L;
            public final CSVOptions parsedOptions$2;
            private final Dataset filteredLines$1;

            public final RDD<String> apply(String firstLine) {
                return this.filteredLines$1.rdd().mapPartitions((Function1)new Serializable(this, firstLine){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final String firstLine$1;

                    public final Iterator<String> apply(Iterator<String> x$3) {
                        return CSVUtils$.MODULE$.filterHeaderLine(x$3, this.firstLine$1, this.$outer.parsedOptions$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.firstLine$1 = firstLine$1;
                    }
                }, this.filteredLines$1.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
            }
            {
                this.parsedOptions$2 = parsedOptions$2;
                this.filteredLines$1 = filteredLines$1;
            }
        }).getOrElse((Function0)new Serializable(this, filteredLines){
            public static final long serialVersionUID = 0L;
            private final Dataset filteredLines$1;

            public final RDD<String> apply() {
                return this.filteredLines$1.rdd();
            }
            {
                this.filteredLines$1 = filteredLines$1;
            }
        });
        RDD parsed = linesWithoutHeader.mapPartitions((Function1)new Serializable(this, parsedOptions, schema, actualSchema){
            public static final long serialVersionUID = 0L;
            private final CSVOptions parsedOptions$2;
            private final StructType schema$3;
            private final StructType actualSchema$2;

            public final Iterator<InternalRow> apply(Iterator<String> iter) {
                UnivocityParser rawParser = new UnivocityParser(this.actualSchema$2, this.parsedOptions$2);
                FailureSafeParser<IN> parser = new FailureSafeParser<IN>(new Serializable(this, rawParser){
                    public static final long serialVersionUID = 0L;
                    private final UnivocityParser rawParser$2;

                    public final Seq<InternalRow> apply(String input) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{this.rawParser$2.parse(input)}));
                    }
                    {
                        this.rawParser$2 = rawParser$2;
                    }
                }, this.parsedOptions$2.parseMode(), this.schema$3, this.parsedOptions$2.columnNameOfCorruptRecord());
                return iter.flatMap((Function1)new Serializable(this, parser){
                    public static final long serialVersionUID = 0L;
                    private final FailureSafeParser parser$2;

                    public final Iterator<InternalRow> apply(String input) {
                        return this.parser$2.parse(input);
                    }
                    {
                        this.parser$2 = parser$2;
                    }
                });
            }
            {
                this.parsedOptions$2 = parsedOptions$2;
                this.schema$3 = schema$3;
                this.actualSchema$2 = actualSchema$2;
            }
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$DataFrameReader$$sparkSession, (LogicalPlan)new LogicalRDD((Seq<Attribute>)schema.toAttributes(), (RDD<InternalRow>)parsed, LogicalRDD$.MODULE$.apply$default$3(), LogicalRDD$.MODULE$.apply$default$4(), this.org$apache$spark$sql$DataFrameReader$$sparkSession));
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        return this.org$apache$spark$sql$DataFrameReader$$sparkSession.table(tableName);
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.org$apache$spark$sql$DataFrameReader$$sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User specified schema not supported with `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void verifyColumnNameOfCorruptRecord(StructType schema, String columnNameOfCorruptRecord) {
        schema.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)new Serializable(this, schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;

            public final void apply(int corruptFieldIndex) {
                this.apply$mcVI$sp(corruptFieldIndex);
            }

            public void apply$mcVI$sp(int corruptFieldIndex) {
                StructField f = this.schema$2.apply(corruptFieldIndex);
                DataType dataType = f.dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null) && f.nullable()) {
                    return;
                }
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.schema$2 = schema$2;
            }
        });
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.org$apache$spark$sql$DataFrameReader$$sparkSession = sparkSession;
        Logging.class.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

