/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.RateSourceProvider$;
import org.apache.spark.sql.execution.streaming.RateStreamSource$;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.Source$class;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001=\u0011\u0001CU1uKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0007'>,(oY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005Q1/\u001d7D_:$X\r\u001f;\u0011\u0005\r\"S\"\u0001\u0004\n\u0005\u00152!AC*R\u0019\u000e{g\u000e^3yi\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0007nKR\fG-\u0019;b!\u0006$\b\u000e\u0005\u0002*Y9\u0011\u0011CK\u0005\u0003WI\ta\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111F\u0005\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005i!o\\<t!\u0016\u00148+Z2p]\u0012\u0004\"!\u0005\u001a\n\u0005M\u0012\"\u0001\u0002'p]\u001eD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0012e\u0006l\u0007/\u00169US6,7+Z2p]\u0012\u001c\b\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\t\t\u0012(\u0003\u0002;%\t\u0019\u0011J\u001c;\t\u0011q\u0002!\u0011!Q\u0001\nu\na\"^:f\u001b\u0006tW/\u00197DY>\u001c7\u000e\u0005\u0002\u0012}%\u0011qH\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015\t\u0005\u0001\"\u0001C\u0003\u0019a\u0014N\\5u}Q91\tR#G\u000f\"K\u0005CA\f\u0001\u0011\u0015\t\u0003\t1\u0001#\u0011\u00159\u0003\t1\u0001)\u0011\u0015\u0001\u0004\t1\u00012\u0011\u0015)\u0004\t1\u00012\u0011\u00159\u0004\t1\u00019\u0011\u0015a\u0004\t1\u0001>\u0011\u001dY\u0005A1A\u0005\u00021\u000bQa\u00197pG.,\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\"\tA!\u001e;jY&\u0011!k\u0014\u0002\u0006\u00072|7m\u001b\u0005\u0007)\u0002\u0001\u000b\u0011B'\u0002\r\rdwnY6!\u0011\u001d1\u0006A1A\u0005\n]\u000b!\"\\1y'\u0016\u001cwN\u001c3t+\u0005\t\u0004BB-\u0001A\u0003%\u0011'A\u0006nCb\u001cVmY8oIN\u0004\u0003bB.\u0001\u0005\u0004%IaV\u0001\fgR\f'\u000f\u001e+j[\u0016l5\u000f\u0003\u0004^\u0001\u0001\u0006I!M\u0001\rgR\f'\u000f\u001e+j[\u0016l5\u000f\t\u0005\b?\u0002\u0001\r\u0011\"\u0003X\u0003)a\u0017m\u001d;US6,Wj\u001d\u0005\bC\u0002\u0001\r\u0011\"\u0003c\u00039a\u0017m\u001d;US6,Wj]0%KF$\"a\u00194\u0011\u0005E!\u0017BA3\u0013\u0005\u0011)f.\u001b;\t\u000f\u001d\u0004\u0017\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\t\r%\u0004\u0001\u0015)\u00032\u0003-a\u0017m\u001d;US6,Wj\u001d\u0011)\u0005!\\\u0007CA\tm\u0013\ti'C\u0001\u0005w_2\fG/\u001b7f\u0011\u0015y\u0007\u0001\"\u0011q\u0003\u0019\u00198\r[3nCV\t\u0011\u000f\u0005\u0002sk6\t1O\u0003\u0002u\r\u0005)A/\u001f9fg&\u0011ao\u001d\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002=\u0001\t\u0003J\u0018!C4fi>3gm]3u+\u0005Q\bcA\t|{&\u0011AP\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005]q\u0018BA@\u0003\u0005\u0019yeMZ:fi\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0011\u0001C4fi\n\u000bGo\u00195\u0015\r\u0005\u001d\u00111FA\u0018!\u0011\tI!!\n\u000f\t\u0005-\u0011\u0011\u0005\b\u0005\u0003\u001b\tyB\u0004\u0003\u0002\u0010\u0005ua\u0002BA\t\u00037qA!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/q\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0004\u0003G1\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003O\tICA\u0005ECR\fgI]1nK*\u0019\u00111\u0005\u0004\t\u000f\u00055\u0012\u0011\u0001a\u0001u\u0006)1\u000f^1si\"9\u0011\u0011GA\u0001\u0001\u0004i\u0018aA3oI\"9\u0011Q\u0007\u0001\u0005B\u0005]\u0012\u0001B:u_B$\u0012a\u0019\u0005\b\u0003w\u0001A\u0011IA\u001f\u0003!!xn\u0015;sS:<G#\u0001\u0015\b\u000f\u0005\u0005#\u0001#\u0001\u0002D\u0005\u0001\"+\u0019;f'R\u0014X-Y7T_V\u00148-\u001a\t\u0004/\u0005\u0015cAB\u0001\u0003\u0011\u0003\t9eE\u0002\u0002FAAq!QA#\t\u0003\tY\u0005\u0006\u0002\u0002D!A\u0011qJA#\t\u0003\t\t&A\u0007wC2,X-\u0011;TK\u000e|g\u000e\u001a\u000b\bc\u0005M\u0013qKA-\u0011\u001d\t)&!\u0014A\u0002E\nqa]3d_:$7\u000f\u0003\u00041\u0003\u001b\u0002\r!\r\u0005\u0007k\u00055\u0003\u0019A\u0019")
public class RateStreamSource
implements Source,
Logging {
    public final SQLContext org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext;
    public final String org$apache$spark$sql$execution$streaming$RateStreamSource$$metadataPath;
    private final long rowsPerSecond;
    private final long rampUpTimeSeconds;
    private final int numPartitions;
    private final Clock clock;
    private final long maxSeconds;
    private final long startTimeMs;
    private volatile long lastTimeMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long valueAtSecond(long l, long l2, long l3) {
        return RateStreamSource$.MODULE$.valueAtSecond(l, l2, l3);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public void commit(Offset end) {
        Source$class.commit(this, end);
    }

    public Clock clock() {
        return this.clock;
    }

    private long maxSeconds() {
        return this.maxSeconds;
    }

    private long startTimeMs() {
        return this.startTimeMs;
    }

    private long lastTimeMs() {
        return this.lastTimeMs;
    }

    private void lastTimeMs_$eq(long x$1) {
        this.lastTimeMs = x$1;
    }

    @Override
    public StructType schema() {
        return RateSourceProvider$.MODULE$.SCHEMA();
    }

    @Override
    public Option<Offset> getOffset() {
        long now = this.clock().getTimeMillis();
        if (this.lastTimeMs() < now) {
            this.lastTimeMs_$eq(now);
        }
        return new Some((Object)new LongOffset(TimeUnit.MILLISECONDS.toSeconds(this.lastTimeMs() - this.startTimeMs())));
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start2, Offset end) {
        long endSeconds;
        long startSeconds = BoxesRunTime.unboxToLong((Object)start2.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(Offset x$7) {
                return LongOffset$.MODULE$.convert(x$7).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LongOffset x$8) {
                        return x$8.offset();
                    }
                });
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Predef$.MODULE$.assert(startSeconds <= (endSeconds = BoxesRunTime.unboxToLong((Object)LongOffset$.MODULE$.convert(end).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LongOffset x$9) {
                return x$9.offset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }))), (Function0)new Serializable(this, startSeconds, endSeconds){
            public static final long serialVersionUID = 0L;
            private final long startSeconds$1;
            private final long endSeconds$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startSeconds(", ") > endSeconds(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startSeconds$1), BoxesRunTime.boxToLong((long)this.endSeconds$1)}));
            }
            {
                this.startSeconds$1 = startSeconds$1;
                this.endSeconds$1 = endSeconds$1;
            }
        });
        if (endSeconds > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder().append((Object)"Integer overflow. Max offset with ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " rowsPerSecond is ", ", but it's ", " now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rowsPerSecond), BoxesRunTime.boxToLong((long)this.maxSeconds()), BoxesRunTime.boxToLong((long)endSeconds)}))).toString());
        }
        if (this.lastTimeMs() < TimeUnit.SECONDS.toMillis(endSeconds) + this.startTimeMs()) {
            this.lastTimeMs_$eq(TimeUnit.SECONDS.toMillis(endSeconds) + this.startTimeMs());
        }
        long rangeStart = RateStreamSource$.MODULE$.valueAtSecond(startSeconds, this.rowsPerSecond, this.rampUpTimeSeconds);
        long rangeEnd = RateStreamSource$.MODULE$.valueAtSecond(endSeconds, this.rowsPerSecond, this.rampUpTimeSeconds);
        this.logDebug((Function0<String>)new Serializable(this, startSeconds, endSeconds, rangeStart, rangeEnd){
            public static final long serialVersionUID = 0L;
            private final long startSeconds$1;
            private final long endSeconds$1;
            private final long rangeStart$1;
            private final long rangeEnd$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startSeconds: ", ", endSeconds: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startSeconds$1), BoxesRunTime.boxToLong((long)this.endSeconds$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rangeStart: ", ", rangeEnd: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rangeStart$1), BoxesRunTime.boxToLong((long)this.rangeEnd$1)}))).toString();
            }
            {
                this.startSeconds$1 = startSeconds$1;
                this.endSeconds$1 = endSeconds$1;
                this.rangeStart$1 = rangeStart$1;
                this.rangeEnd$1 = rangeEnd$1;
            }
        });
        if (rangeStart == rangeEnd) {
            return this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext.internalCreateDataFrame((RDD<InternalRow>)this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)), this.schema());
        }
        long localStartTimeMs = this.startTimeMs() + TimeUnit.SECONDS.toMillis(startSeconds);
        double relativeMsPerValue = (double)TimeUnit.SECONDS.toMillis(endSeconds - startSeconds) / (double)(rangeEnd - rangeStart);
        RDD rdd = this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext.sparkContext().range(rangeStart, rangeEnd, 1L, this.numPartitions).map((Function1)new Serializable(this, rangeStart, localStartTimeMs, relativeMsPerValue){
            public static final long serialVersionUID = 0L;
            private final long rangeStart$1;
            private final long localStartTimeMs$1;
            private final double relativeMsPerValue$1;

            public final InternalRow apply(long v) {
                long relative = package$.MODULE$.round((double)(v - this.rangeStart$1) * this.relativeMsPerValue$1);
                return InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromMillis(relative + this.localStartTimeMs$1)), BoxesRunTime.boxToLong((long)v)}));
            }
            {
                this.rangeStart$1 = rangeStart$1;
                this.localStartTimeMs$1 = localStartTimeMs$1;
                this.relativeMsPerValue$1 = relativeMsPerValue$1;
            }
        }, ClassTag$.MODULE$.apply(InternalRow.class));
        return this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext.internalCreateDataFrame((RDD<InternalRow>)rdd, this.schema());
    }

    @Override
    public void stop() {
    }

    public String toString() {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RateSource[rowsPerSecond=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rowsPerSecond)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rampUpTimeSeconds=", ", numPartitions=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rampUpTimeSeconds), BoxesRunTime.boxToInteger((int)this.numPartitions)}))).toString();
    }

    public RateStreamSource(SQLContext sqlContext, String metadataPath, long rowsPerSecond, long rampUpTimeSeconds, int numPartitions, boolean useManualClock) {
        this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext = sqlContext;
        this.org$apache$spark$sql$execution$streaming$RateStreamSource$$metadataPath = metadataPath;
        this.rowsPerSecond = rowsPerSecond;
        this.rampUpTimeSeconds = rampUpTimeSeconds;
        this.numPartitions = numPartitions;
        Source$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.clock = useManualClock ? new ManualClock() : new SystemClock();
        this.maxSeconds = Long.MAX_VALUE / rowsPerSecond;
        if (rampUpTimeSeconds > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Integer overflow. Max offset with ", " rowsPerSecond"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)rowsPerSecond)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" is ", ", but 'rampUpTimeSeconds' is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxSeconds()), BoxesRunTime.boxToLong((long)rampUpTimeSeconds)}))).toString());
        }
        HDFSMetadataLog<LongOffset> metadataLog = new HDFSMetadataLog<LongOffset>(this){

            public void serialize(LongOffset metadata, OutputStream out) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                writer.write(new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)RateSourceProvider$.MODULE$.VERSION())).append((Object)"\n").toString());
                writer.write(metadata.json());
                writer.flush();
            }

            public LongOffset deserialize(InputStream in) {
                String content = IOUtils.toString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                Predef$.MODULE$.assert(content.length() != 0);
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
                    int indexOfNewLine = content.indexOf("\n");
                    if (indexOfNewLine > 0) {
                        int version = this.parseVersion(content.substring(0, indexOfNewLine), RateSourceProvider$.MODULE$.VERSION());
                        return LongOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to detect the log file version line."})).s((Seq)Nil$.MODULE$));
                }
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to detect the log file version line."})).s((Seq)Nil$.MODULE$));
            }
        };
        this.startTimeMs = ((LongOffset)metadataLog.get(0L).getOrElse((Function0)new Serializable(this, metadataLog){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RateStreamSource $outer;
            private final HDFSMetadataLog metadataLog$1;

            /*
             * WARNING - void declaration
             */
            public final LongOffset apply() {
                void var1_1;
                LongOffset offset = new LongOffset(this.$outer.clock().getTimeMillis());
                this.metadataLog$1.add(0L, offset);
                this.$outer.logInfo((Function0<String>)new Serializable(this, offset){
                    public static final long serialVersionUID = 0L;
                    private final LongOffset offset$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start time: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offset$1}));
                    }
                    {
                        this.offset$1 = offset$1;
                    }
                });
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metadataLog$1 = metadataLog$1;
            }
        })).offset();
        this.lastTimeMs = this.startTimeMs();
    }
}

