/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.FailureSafeParser;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonInferSchema$;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;

public final class TextInputJsonDataSource$
extends JsonDataSource {
    public static final TextInputJsonDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new TextInputJsonDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        Dataset<String> json = this.createBaseDataset(sparkSession, inputPaths);
        return this.inferFromDataset(json, parsedOptions);
    }

    public StructType inferFromDataset(Dataset<String> json, JSONOptions parsedOptions) {
        Dataset<String> sampled = JsonUtils$.MODULE$.sample(json, parsedOptions);
        RDD rdd2 = sampled.queryExecution().toRdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UTF8String apply(InternalRow x$1) {
                return x$1.getUTF8String(0);
            }
        }, ClassTag$.MODULE$.apply(UTF8String.class));
        return JsonInferSchema$.MODULE$.infer(rdd2, parsedOptions, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonParser apply(JsonFactory jsonFactory, UTF8String record) {
                return CreateJacksonParser$.MODULE$.utf8String(jsonFactory, record);
            }
        });
    }

    private Dataset<String> createBaseDataset(SparkSession sparkSession, Seq<FileStatus> inputPaths) {
        Seq paths = (Seq)inputPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$2) {
                return x$2.getPath().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        SparkSession x$6 = sparkSession;
        Seq x$7 = paths;
        String x$8 = TextFileFormat.class.getName();
        Option<StructType> x$9 = DataSource$.MODULE$.apply$default$4();
        Seq<String> x$10 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$11 = DataSource$.MODULE$.apply$default$6();
        Map<String, String> x$12 = DataSource$.MODULE$.apply$default$7();
        Option<CatalogTable> x$13 = DataSource$.MODULE$.apply$default$8();
        return sparkSession.baseRelationToDataFrame(new DataSource(x$6, x$8, (Seq<String>)x$7, x$9, x$10, x$11, x$12, x$13).resolveRelation(false)).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(Encoders$.MODULE$.STRING());
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, JacksonParser parser, StructType schema2) {
        HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, conf);
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(linesReader){
            public static final long serialVersionUID = 0L;
            public final HadoopFileLinesReader linesReader$1;

            public final TaskContext apply(TaskContext x$3) {
                return x$3.addTaskCompletionListener((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.readFile.1 $outer;

                    public final void apply(TaskContext x$4) {
                        this.$outer.linesReader$1.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.linesReader$1 = linesReader$1;
            }
        });
        FailureSafeParser safeParser = new FailureSafeParser(new Serializable(parser){
            public static final long serialVersionUID = 0L;
            private final JacksonParser parser$1;

            public final Seq<InternalRow> apply(Text input) {
                return this.parser$1.parse((Object)input, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonParser apply(JsonFactory jsonFactory, Text record) {
                        return CreateJacksonParser$.MODULE$.text(jsonFactory, record);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final UTF8String apply(Text value) {
                        return TextInputJsonDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$json$TextInputJsonDataSource$$textToUTF8String(value);
                    }
                });
            }
            {
                this.parser$1 = parser$1;
            }
        }, parser.options().parseMode(), schema2, parser.options().columnNameOfCorruptRecord());
        return linesReader.flatMap(new Serializable(safeParser){
            public static final long serialVersionUID = 0L;
            private final FailureSafeParser safeParser$1;

            public final Iterator<InternalRow> apply(Text input) {
                return this.safeParser$1.parse(input);
            }
            {
                this.safeParser$1 = safeParser$1;
            }
        });
    }

    public UTF8String org$apache$spark$sql$execution$datasources$json$TextInputJsonDataSource$$textToUTF8String(Text value) {
        return UTF8String.fromBytes((byte[])value.getBytes(), (int)0, (int)value.getLength());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TextInputJsonDataSource$() {
        MODULE$ = this;
        this.isSplitable = true;
    }
}

