/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.AlterTableAddPartitionCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0005\"Aq\t\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005y\u0001\tE\t\u0015!\u0003J\u0011!I\bA!f\u0001\n\u0003Q\b\u0002\u0003@\u0001\u0005#\u0005\u000b\u0011B>\t\r}\u0004A\u0011AA\u0001\u0011\u001d\tY\u0001\u0001C!\u0003\u001bA\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u00055\u0002!%A\u0005\u0002\u0005=\u0002\"CA#\u0001E\u0005I\u0011AA$\u0011%\tY\u0005AI\u0001\n\u0003\ti\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0011\u0002T!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003[\u0002\u0011\u0011!C\u0001\u0003_B\u0011\"a\u001f\u0001\u0003\u0003%\t%! \t\u0013\u0005-\u0005!!A\u0005\u0002\u00055\u0005\"CAI\u0001\u0005\u0005I\u0011IAJ\u000f%\t9jGA\u0001\u0012\u0003\tIJ\u0002\u0005\u001b7\u0005\u0005\t\u0012AAN\u0011\u0019yH\u0003\"\u0001\u0002*\"I\u00111\u0016\u000b\u0002\u0002\u0013\u0015\u0013Q\u0016\u0005\n\u0003_#\u0012\u0011!CA\u0003cC\u0011\"!/\u0015\u0003\u0003%\t)a/\t\u0013\u0005%G#!A\u0005\n\u0005-'!H!mi\u0016\u0014H+\u00192mK\u0006#G\rU1si&$\u0018n\u001c8D_6l\u0017M\u001c3\u000b\u0005qi\u0012aB2p[6\fg\u000e\u001a\u0006\u0003=}\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001I3gN\u001f\u0011\u0005)\nT\"A\u0016\u000b\u00051j\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003]=\nQ\u0001\u001d7b]NT!\u0001M\u0010\u0002\u0011\r\fG/\u00197zgRL!AM\u0016\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003iUj\u0011aG\u0005\u0003mm\u0011qBU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\b!J|G-^2u!\tAd(\u0003\u0002@s\ta1+\u001a:jC2L'0\u00192mK\u0006IA/\u00192mK:\u000bW.Z\u000b\u0002\u0005B\u00111\tR\u0007\u0002_%\u0011Qi\f\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006QA/\u00192mK:\u000bW.\u001a\u0011\u0002+A\f'\u000f^5uS>t7\u000b]3dg\u0006sG\rT8dgV\t\u0011\nE\u0002K%Vs!a\u0013)\u000f\u00051{U\"A'\u000b\u00059;\u0013A\u0002\u001fs_>$h(C\u0001;\u0013\t\t\u0016(A\u0004qC\u000e\\\u0017mZ3\n\u0005M#&aA*fc*\u0011\u0011+\u000f\t\u0005qYCV.\u0003\u0002Xs\t1A+\u001e9mKJ\u0002\"!\u00176\u000f\u0005i;gBA.f\u001d\taFM\u0004\u0002^G:\u0011aL\u0019\b\u0003?\u0006t!\u0001\u00141\n\u0003\u0019J!\u0001J\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\t\u0001t$\u0003\u0002g_\u000591-\u0019;bY><\u0017B\u00015j\u00031\u0019\u0015\r^1m_\u001e$\u0016\u0010]3t\u0015\t1w&\u0003\u0002lY\n\u0011B+\u00192mKB\u000b'\u000f^5uS>t7\u000b]3d\u0015\tA\u0017\u000eE\u00029]BL!a\\\u001d\u0003\r=\u0003H/[8o!\t\tXO\u0004\u0002sgB\u0011A*O\u0005\u0003if\na\u0001\u0015:fI\u00164\u0017B\u0001<x\u0005\u0019\u0019FO]5oO*\u0011A/O\u0001\u0017a\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2t\u0003:$Gj\\2tA\u0005Y\u0011N\u001a(pi\u0016C\u0018n\u001d;t+\u0005Y\bC\u0001\u001d}\u0013\ti\u0018HA\u0004C_>dW-\u00198\u0002\u0019%4gj\u001c;Fq&\u001cHo\u001d\u0011\u0002\rqJg.\u001b;?)!\t\u0019!!\u0002\u0002\b\u0005%\u0001C\u0001\u001b\u0001\u0011\u0015\u0001u\u00011\u0001C\u0011\u00159u\u00011\u0001J\u0011\u0015Ix\u00011\u0001|\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u001f\tI\u0002\u0005\u0003K%\u0006E\u0001\u0003BA\n\u0003+i\u0011aH\u0005\u0004\u0003/y\"a\u0001*po\"9\u00111\u0004\u0005A\u0002\u0005u\u0011\u0001D:qCJ\\7+Z:tS>t\u0007\u0003BA\n\u0003?I1!!\t \u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u0011\u0005\r\u0011qEA\u0015\u0003WAq\u0001Q\u0005\u0011\u0002\u0003\u0007!\tC\u0004H\u0013A\u0005\t\u0019A%\t\u000feL\u0001\u0013!a\u0001w\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0019U\r\u0011\u00151G\u0016\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$A\u0005v]\u000eDWmY6fI*\u0019\u0011qH\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002D\u0005e\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA%U\rI\u00151G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyEK\u0002|\u0003g\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA+!\u0011\t9&!\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\nA\u0001\\1oO*\u0011\u0011qL\u0001\u0005U\u00064\u0018-C\u0002w\u00033\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001a\u0011\u0007a\nI'C\u0002\u0002le\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u001d\u0002xA\u0019\u0001(a\u001d\n\u0007\u0005U\u0014HA\u0002B]fD\u0011\"!\u001f\u0010\u0003\u0003\u0005\r!a\u001a\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\b\u0005\u0004\u0002\u0002\u0006\u001d\u0015\u0011O\u0007\u0003\u0003\u0007S1!!\":\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0013\u000b\u0019I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA>\u0002\u0010\"I\u0011\u0011P\t\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u0007KF,\u0018\r\\:\u0015\u0007m\f)\nC\u0005\u0002zI\t\t\u00111\u0001\u0002r\u0005i\u0012\t\u001c;feR\u000b'\r\\3BI\u0012\u0004\u0016M\u001d;ji&|gnQ8n[\u0006tG\r\u0005\u00025)M!A#!(>!%\ty*!*C\u0013n\f\u0019!\u0004\u0002\u0002\"*\u0019\u00111U\u001d\u0002\u000fI,h\u000e^5nK&!\u0011qUAQ\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u00033\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003+\nQ!\u00199qYf$\u0002\"a\u0001\u00024\u0006U\u0016q\u0017\u0005\u0006\u0001^\u0001\rA\u0011\u0005\u0006\u000f^\u0001\r!\u0013\u0005\u0006s^\u0001\ra_\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti,!2\u0011\tar\u0017q\u0018\t\u0007q\u0005\u0005')S>\n\u0007\u0005\r\u0017H\u0001\u0004UkBdWm\r\u0005\n\u0003\u000fD\u0012\u0011!a\u0001\u0003\u0007\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0007\u0003BA,\u0003\u001fLA!!5\u0002Z\t1qJ\u00196fGR\u0004")
public class AlterTableAddPartitionCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs;
    private final boolean ifNotExists;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, Seq<Tuple2<Map<String, String>, Option<String>>>, Object>> unapply(AlterTableAddPartitionCommand alterTableAddPartitionCommand) {
        return AlterTableAddPartitionCommand$.MODULE$.unapply(alterTableAddPartitionCommand);
    }

    public static Function1<Tuple3<TableIdentifier, Seq<Tuple2<Map<String, String>, Option<String>>>, Object>, AlterTableAddPartitionCommand> tupled() {
        return AlterTableAddPartitionCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<Tuple2<Map<String, String>, Option<String>>>, Function1<Object, AlterTableAddPartitionCommand>>> curried() {
        return AlterTableAddPartitionCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableAddPartitionCommand alterTableAddPartitionCommand = this;
        synchronized (alterTableAddPartitionCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs() {
        return this.partitionSpecsAndLocs;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "ALTER TABLE ADD PARTITION");
        Seq parts = (Seq)this.partitionSpecsAndLocs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map spec = (Map)tuple2._1();
            Option location = (Option)tuple2._2();
            Map normalizedSpec = PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, table.partitionSchema(), table.identifier().quotedString(), sparkSession.sessionState().conf().resolver());
            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(normalizedSpec, table.storage().copy(location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str)), table.storage().copy$default$2(), table.storage().copy$default$3(), table.storage().copy$default$4(), table.storage().copy$default$5(), table.storage().copy$default$6()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            return catalogTablePartition;
        }, Seq$.MODULE$.canBuildFrom());
        int batchSize = BoxesRunTime.unboxToInt((Object)this.conf().getConf(SQLConf$.MODULE$.ADD_PARTITION_BATCH_SIZE()));
        parts.toIterator().grouped(batchSize).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            catalog.createPartitions(table.identifier(), batch, this.ifNotExists());
            return BoxedUnit.UNIT;
        });
        sparkSession.catalog().refreshTable(table.identifier().quotedString());
        if (table.stats().nonEmpty() && sparkSession.sessionState().conf().autoSizeUpdateEnabled()) {
            long addedSize = BoxesRunTime.unboxToLong((Object)CommandUtils$.MODULE$.calculateMultipleLocationSizes(sparkSession, table.identifier(), (Seq<Option<URI>>)((Seq)parts.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.storage().locationUri(), Seq$.MODULE$.canBuildFrom()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (addedSize > 0L) {
                CatalogStatistics newStats = new CatalogStatistics(((CatalogStatistics)table.stats().get()).sizeInBytes().$plus(BigInt$.MODULE$.long2bigInt(addedSize)), CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3());
                catalog.alterTableStats(table.identifier(), (Option)new Some((Object)newStats));
            }
        } else {
            CommandUtils$.MODULE$.updateTableStats(sparkSession, table);
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableAddPartitionCommand copy(TableIdentifier tableName, Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs, boolean ifNotExists) {
        return new AlterTableAddPartitionCommand(tableName, partitionSpecsAndLocs, ifNotExists);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Seq<Tuple2<Map<String, String>, Option<String>>> copy$default$2() {
        return this.partitionSpecsAndLocs();
    }

    public boolean copy$default$3() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "AlterTableAddPartitionCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.partitionSpecsAndLocs();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableAddPartitionCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableAddPartitionCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableAddPartitionCommand alterTableAddPartitionCommand = (AlterTableAddPartitionCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableAddPartitionCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<Tuple2<Map<String, String>, Option<String>>> seq = this.partitionSpecsAndLocs();
        Seq<Tuple2<Map<String, String>, Option<String>>> seq2 = alterTableAddPartitionCommand.partitionSpecsAndLocs();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.ifNotExists() != alterTableAddPartitionCommand.ifNotExists()) return false;
        if (!alterTableAddPartitionCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableAddPartitionCommand(TableIdentifier tableName, Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs, boolean ifNotExists) {
        this.tableName = tableName;
        this.partitionSpecsAndLocs = partitionSpecsAndLocs;
        this.ifNotExists = ifNotExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

