/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.RangePartitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.ShuffleDependency$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriteProcessor;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.shuffle.sort.SortShuffleManager$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.LazilyGeneratedOrdering;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.RangePartitioning;
import org.apache.spark.sql.catalyst.plans.physical.RoundRobinPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.SinglePartition$;
import org.apache.spark.sql.execution.PartitionIdPassthrough;
import org.apache.spark.sql.execution.RecordBinaryComparator;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnsafeExternalRowSorter;
import org.apache.spark.sql.execution.exchange.ENSURE_REQUIREMENTS$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleOrigin;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLShuffleWriteMetricsReporter;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.MutablePair;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparators;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class ShuffleExchangeExec$
implements scala.Serializable {
    public static ShuffleExchangeExec$ MODULE$;

    static {
        new ShuffleExchangeExec$();
    }

    public ShuffleOrigin $lessinit$greater$default$3() {
        return ENSURE_REQUIREMENTS$.MODULE$;
    }

    private boolean needToCopyObjectsBeforeShuffle(Partitioner partitioner) {
        SparkConf conf = SparkEnv$.MODULE$.get().conf();
        ShuffleManager shuffleManager = SparkEnv$.MODULE$.get().shuffleManager();
        boolean sortBasedShuffleOn = shuffleManager instanceof SortShuffleManager;
        int bypassMergeThreshold = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.SHUFFLE_SORT_BYPASS_MERGE_THRESHOLD()));
        int numParts = partitioner.numPartitions();
        return sortBasedShuffleOn ? (numParts <= bypassMergeThreshold ? false : numParts > SortShuffleManager$.MODULE$.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()) : true;
    }

    public ShuffleDependency<Object, InternalRow, InternalRow> prepareShuffleDependency(RDD<InternalRow> rdd, Seq<Attribute> outputAttributes, Partitioning newPartitioning, Serializer serializer, Map<String, SQLMetric> writeMetrics) {
        RDD rddWithPartitionIds;
        RDD rDD;
        boolean isOrderSensitive;
        Object object;
        Partitioning partitioning = newPartitioning;
        if (partitioning instanceof RoundRobinPartitioning) {
            RoundRobinPartitioning roundRobinPartitioning = (RoundRobinPartitioning)partitioning;
            int numPartitions = roundRobinPartitioning.numPartitions();
            object = new HashPartitioner(numPartitions);
        } else if (partitioning instanceof HashPartitioning) {
            HashPartitioning hashPartitioning = (HashPartitioning)partitioning;
            int n = hashPartitioning.numPartitions();
            object = new Partitioner(n){
                private final int n$1;

                public int numPartitions() {
                    return this.n$1;
                }

                public int getPartition(Object key) {
                    return BoxesRunTime.unboxToInt((Object)key);
                }
                {
                    this.n$1 = n$1;
                }
            };
        } else if (partitioning instanceof RangePartitioning) {
            RangePartitioning rangePartitioning = (RangePartitioning)partitioning;
            Seq sortingExpressions = rangePartitioning.ordering();
            int numPartitions = rangePartitioning.numPartitions();
            RDD rddForSampling = rdd.mapPartitionsInternal((Function1 & Serializable & scala.Serializable)iter -> {
                UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)sortingExpressions.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.child(), Seq$.MODULE$.canBuildFrom()), outputAttributes);
                MutablePair mutablePair = new MutablePair();
                return iter.map((Function1 & Serializable & scala.Serializable)row -> mutablePair.update((Object)projection.apply(row).copy(), null));
            }, rdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class));
            Seq orderingAttributes = (Seq)((TraversableLike)sortingExpressions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SortOrder ord = (SortOrder)tuple2._1();
                int i = tuple2._2$mcI$sp();
                SortOrder sortOrder = ord.copy((Expression)new BoundReference(i, ord.dataType(), ord.nullable()), ord.copy$default$2(), ord.copy$default$3(), ord.copy$default$4());
                return sortOrder;
            }, Seq$.MODULE$.canBuildFrom());
            LazilyGeneratedOrdering ordering = new LazilyGeneratedOrdering(orderingAttributes);
            object = new RangePartitioner(numPartitions, rddForSampling, true, SQLConf$.MODULE$.get().rangeExchangeSampleSizePerPartition(), (Ordering)ordering, ClassTag$.MODULE$.apply(InternalRow.class));
        } else if (SinglePartition$.MODULE$.equals(partitioning)) {
            object = new Partitioner(){

                public int numPartitions() {
                    return 1;
                }

                public int getPartition(Object key) {
                    return 0;
                }
            };
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(29).append("Exchange not implemented for ").append(newPartitioning).toString());
        }
        HashPartitioner part = object;
        boolean isRoundRobin = newPartitioning instanceof RoundRobinPartitioning && newPartitioning.numPartitions() > 1;
        RDD newRdd = isRoundRobin && SQLConf$.MODULE$.get().sortBeforeRepartition() ? rdd.mapPartitionsInternal((Function1 & Serializable & scala.Serializable)iter -> {
            Supplier<RecordComparator> recordComparatorSupplier = new Supplier<RecordComparator>(){

                public RecordComparator get() {
                    return new RecordBinaryComparator();
                }
            };
            PrefixComparator prefixComparator = PrefixComparators.LONG;
            UnsafeExternalRowSorter.PrefixComputer prefixComputer = new UnsafeExternalRowSorter.PrefixComputer(){
                private final UnsafeExternalRowSorter.PrefixComputer.Prefix result;

                private UnsafeExternalRowSorter.PrefixComputer.Prefix result() {
                    return this.result;
                }

                public UnsafeExternalRowSorter.PrefixComputer.Prefix computePrefix(InternalRow row) {
                    this.result().isNull = false;
                    this.result().value = row.hashCode();
                    return this.result();
                }
                {
                    this.result = new UnsafeExternalRowSorter.PrefixComputer.Prefix();
                }
            };
            long pageSize = SparkEnv$.MODULE$.get().memoryManager().pageSizeBytes();
            UnsafeExternalRowSorter sorter = UnsafeExternalRowSorter.createWithRecordComparator(StructType$.MODULE$.fromAttributes(outputAttributes), recordComparatorSupplier, prefixComparator, prefixComputer, pageSize, false);
            return sorter.sort((Iterator<UnsafeRow>)iter);
        }, rdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)) : rdd;
        boolean bl = isOrderSensitive = isRoundRobin && !SQLConf$.MODULE$.get().sortBeforeRepartition();
        if (this.needToCopyObjectsBeforeShuffle((Partitioner)part)) {
            Function2 & Serializable & scala.Serializable x$1 = (arg_0, arg_1) -> ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$11$adapted((Partitioner)part, newPartitioning, outputAttributes, arg_0, arg_1);
            boolean x$2 = isOrderSensitive;
            boolean x$3 = newRdd.mapPartitionsWithIndexInternal$default$2();
            rDD = newRdd.mapPartitionsWithIndexInternal((Function2)x$1, x$3, x$2, ClassTag$.MODULE$.apply(Product2.class));
        } else {
            Function2 & Serializable & scala.Serializable x$4 = (arg_0, arg_1) -> ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$13$adapted((Partitioner)part, newPartitioning, outputAttributes, arg_0, arg_1);
            boolean x$5 = isOrderSensitive;
            boolean x$6 = newRdd.mapPartitionsWithIndexInternal$default$2();
            rDD = newRdd.mapPartitionsWithIndexInternal((Function2)x$4, x$6, x$5, ClassTag$.MODULE$.apply(Product2.class));
        }
        RDD x$7 = rddWithPartitionIds = rDD;
        PartitionIdPassthrough x$8 = new PartitionIdPassthrough(part.numPartitions());
        Serializer x$9 = serializer;
        ShuffleWriteProcessor x$10 = this.createShuffleWriteProcessor(writeMetrics);
        None$ x$11 = ShuffleDependency$.MODULE$.$lessinit$greater$default$4();
        None$ x$12 = ShuffleDependency$.MODULE$.$lessinit$greater$default$5();
        boolean x$13 = ShuffleDependency$.MODULE$.$lessinit$greater$default$6();
        ShuffleDependency dependency = new ShuffleDependency(x$7, (Partitioner)x$8, x$9, (Option)x$11, (Option)x$12, x$13, x$10, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(InternalRow.class), ClassTag$.MODULE$.apply(InternalRow.class));
        return dependency;
    }

    public ShuffleWriteProcessor createShuffleWriteProcessor(Map<String, SQLMetric> metrics) {
        return new ShuffleWriteProcessor(metrics){
            private final Map metrics$1;

            public ShuffleWriteMetricsReporter createMetricsReporter(TaskContext context) {
                return new SQLShuffleWriteMetricsReporter((ShuffleWriteMetricsReporter)context.taskMetrics().shuffleWriteMetrics(), (Map<String, SQLMetric>)this.metrics$1);
            }
            {
                this.metrics$1 = metrics$1;
            }
        };
    }

    public ShuffleExchangeExec apply(Partitioning outputPartitioning, SparkPlan child, ShuffleOrigin shuffleOrigin) {
        return new ShuffleExchangeExec(outputPartitioning, child, shuffleOrigin);
    }

    public ShuffleOrigin apply$default$3() {
        return ENSURE_REQUIREMENTS$.MODULE$;
    }

    public Option<Tuple3<Partitioning, SparkPlan, ShuffleOrigin>> unapply(ShuffleExchangeExec x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.outputPartitioning(), (Object)x$0.child(), (Object)x$0.shuffleOrigin()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$prepareShuffleDependency$5(IntRef position$1, InternalRow row) {
        ++position$1.elem;
        return position$1.elem;
    }

    public static final /* synthetic */ int $anonfun$prepareShuffleDependency$6(UnsafeProjection projection$2, InternalRow row) {
        return projection$2.apply(row).getInt(0);
    }

    private static final Function1 getPartitionKeyExtractor$1(Partitioning newPartitioning$1, Seq outputAttributes$1) {
        Function1 & Serializable & scala.Serializable intersect;
        Partitioning partitioning = newPartitioning$1;
        if (partitioning instanceof RoundRobinPartitioning) {
            RoundRobinPartitioning roundRobinPartitioning = (RoundRobinPartitioning)partitioning;
            int numPartitions = roundRobinPartitioning.numPartitions();
            IntRef position = IntRef.create((int)new Random(TaskContext$.MODULE$.get().partitionId()).nextInt(numPartitions));
            intersect = (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$5(position, row));
        } else if (partitioning instanceof HashPartitioning) {
            HashPartitioning hashPartitioning = (HashPartitioning)partitioning;
            Expression expression = hashPartitioning.partitionIdExpression();
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)expression), outputAttributes$1);
            intersect = (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$6(projection, row));
        } else if (partitioning instanceof RangePartitioning) {
            RangePartitioning rangePartitioning = (RangePartitioning)partitioning;
            Seq sortingExpressions = rangePartitioning.ordering();
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)sortingExpressions.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.child(), Seq$.MODULE$.canBuildFrom()), outputAttributes$1);
            intersect = (Function1 & Serializable & scala.Serializable)row -> projection.apply(row);
        } else if (SinglePartition$.MODULE$.equals(partitioning)) {
            intersect = (Function1 & Serializable & scala.Serializable)x -> (InternalRow)Predef$.MODULE$.identity(x);
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(29).append("Exchange not implemented for ").append(newPartitioning$1).toString());
        }
        return intersect;
    }

    public static final /* synthetic */ Iterator $anonfun$prepareShuffleDependency$11(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, int x$4, Iterator iter) {
        Function1 getPartitionKey = ShuffleExchangeExec$.getPartitionKeyExtractor$1(newPartitioning$1, outputAttributes$1);
        return iter.map((Function1 & Serializable & scala.Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)part$1.getPartition(getPartitionKey.apply(row))), (Object)row.copy()));
    }

    public static final /* synthetic */ Iterator $anonfun$prepareShuffleDependency$13(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, int x$5, Iterator iter) {
        Function1 getPartitionKey = ShuffleExchangeExec$.getPartitionKeyExtractor$1(newPartitioning$1, outputAttributes$1);
        MutablePair mutablePair = new MutablePair();
        return iter.map((Function1 & Serializable & scala.Serializable)row -> mutablePair.update((Object)BoxesRunTime.boxToInteger((int)part$1.getPartition(getPartitionKey.apply(row))), row));
    }

    private ShuffleExchangeExec$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Iterator $anonfun$prepareShuffleDependency$11$adapted(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, Object x$4, Iterator iter) {
        return ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$11(part$1, newPartitioning$1, outputAttributes$1, BoxesRunTime.unboxToInt((Object)x$4), iter);
    }

    public static final /* synthetic */ Iterator $anonfun$prepareShuffleDependency$13$adapted(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, Object x$5, Iterator iter) {
        return ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$13(part$1, newPartitioning$1, outputAttributes$1, BoxesRunTime.unboxToInt((Object)x$5), iter);
    }
}

