/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.spark.SparkException;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.SparkOutOfMemoryError;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.python.DiskRowQueue;
import org.apache.spark.sql.execution.python.HybridRowQueue$;
import org.apache.spark.sql.execution.python.InMemoryRowQueue;
import org.apache.spark.sql.execution.python.RowQueue;
import org.apache.spark.unsafe.memory.MemoryBlock;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\rc!B\u00181\u0001Bb\u0004\u0002\u0003)\u0001\u0005+\u0007I\u0011\u0001*\t\u0011Y\u0003!\u0011#Q\u0001\nMC\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\tC\u0002\u0011\t\u0012)A\u00053\"A!\r\u0001BK\u0002\u0013\u00051\r\u0003\u0005h\u0001\tE\t\u0015!\u0003e\u0011!A\u0007A!f\u0001\n\u0003I\u0007\u0002\u00039\u0001\u0005#\u0005\u000b\u0011\u00026\t\u000bE\u0004A\u0011\u0001:\t\u000fa\u0004\u0001\u0019!C\u0005s\"I\u0011\u0011\u0001\u0001A\u0002\u0013%\u00111\u0001\u0005\b\u0003\u001f\u0001\u0001\u0015)\u0003{\u0011-\t\t\u0002\u0001a\u0001\u0002\u0004%I!a\u0005\t\u0017\u0005U\u0001\u00011AA\u0002\u0013%\u0011q\u0003\u0005\u000b\u00037\u0001\u0001\u0019!A!B\u0013\u0019\u0005bCA\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0003'A1\"a\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"!Q\u0011Q\u0005\u0001A\u0002\u0003\u0005\u000b\u0015B\"\t\u0011\u0005\u001d\u0002\u0001\"\u00011\u0003SAq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002>\u0001!I!a\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003W\u0002A\u0011AA7\u0011%\ty\u0007AA\u0001\n\u0003\t\t\bC\u0005\u0002|\u0001\t\n\u0011\"\u0001\u0002~!I\u00111\u0013\u0001\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u00033\u0003\u0011\u0013!C\u0001\u00037C\u0011\"a(\u0001#\u0003%\t!!)\t\u0013\u0005\u0015\u0006!!A\u0005B\u0005\u001d\u0006\u0002CA[\u0001\u0005\u0005I\u0011A2\t\u0013\u0005]\u0006!!A\u0005\u0002\u0005e\u0006\"CAb\u0001\u0005\u0005I\u0011IAc\u0011%\t\u0019\u000eAA\u0001\n\u0003\t)\u000eC\u0005\u0002Z\u0002\t\t\u0011\"\u0011\u0002*!I\u00111\u001c\u0001\u0002\u0002\u0013\u0005\u0013Q\u001c\u0005\n\u0003?\u0004\u0011\u0011!C!\u0003CDA\"!:\u0001!\u0003\u0005\t\u0011!C\u0001\u0003O<\u0001\"!@1\u0011\u0003\u0001\u0014q \u0004\b_AB\t\u0001\rB\u0001\u0011\u0019\t\u0018\u0006\"\u0001\u0003\n!9!1B\u0015\u0005\u0002\t5\u0001\"\u0003B\u0006S\u0005\u0005I\u0011\u0011B\u000e\u0011%\u0011)#KA\u0001\n\u0003\u00139\u0003C\u0005\u0003:%\n\t\u0011\"\u0003\u0003<\tq\u0001*\u001f2sS\u0012\u0014vn^)vKV,'BA\u00193\u0003\u0019\u0001\u0018\u0010\u001e5p]*\u00111\u0007N\u0001\nKb,7-\u001e;j_:T!!\u000e\u001c\u0002\u0007M\fHN\u0003\u00028q\u0005)1\u000f]1sW*\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h'\u0015\u0001QhQ$N!\tq\u0014)D\u0001@\u0015\t\u0001e'\u0001\u0004nK6|'/_\u0005\u0003\u0005~\u0012a\"T3n_JL8i\u001c8tk6,'\u000f\u0005\u0002E\u000b6\t\u0001'\u0003\u0002Ga\tA!k\\<Rk\u0016,X\r\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0004Qe>$Wo\u0019;\u0011\u0005!s\u0015BA(J\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003)iW-\\'b]\u0006<WM]\u0002\u0001+\u0005\u0019\u0006C\u0001 U\u0013\t)vHA\tUCN\\W*Z7pefl\u0015M\\1hKJ\f1\"\\3n\u001b\u0006t\u0017mZ3sA\u00059A/Z7q\t&\u0014X#A-\u0011\u0005i{V\"A.\u000b\u0005qk\u0016AA5p\u0015\u0005q\u0016\u0001\u00026bm\u0006L!\u0001Y.\u0003\t\u0019KG.Z\u0001\ti\u0016l\u0007\u000fR5sA\u0005Ia.^7GS\u0016dGm]\u000b\u0002IB\u0011\u0001*Z\u0005\u0003M&\u00131!\u00138u\u0003)qW/\u001c$jK2$7\u000fI\u0001\u0007g\u0016\u0014Xj\u001a:\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u001c\u0002\u0015M,'/[1mSj,'/\u0003\u0002pY\n\t2+\u001a:jC2L'0\u001a:NC:\fw-\u001a:\u0002\u000fM,'/T4sA\u00051A(\u001b8jiz\"Ra\u001d;vm^\u0004\"\u0001\u0012\u0001\t\u000bAK\u0001\u0019A*\t\u000b]K\u0001\u0019A-\t\u000b\tL\u0001\u0019\u00013\t\u000b!L\u0001\u0019\u00016\u0002\rE,X-^3t+\u0005Q\bcA>\u007f\u00076\tAP\u0003\u0002~;\u0006!Q\u000f^5m\u0013\tyHP\u0001\u0006MS:\\W\r\u001a'jgR\f!\"];fk\u0016\u001cx\fJ3r)\u0011\t)!a\u0003\u0011\u0007!\u000b9!C\u0002\u0002\n%\u0013A!\u00168ji\"A\u0011QB\u0006\u0002\u0002\u0003\u0007!0A\u0002yIE\nq!];fk\u0016\u001c\b%A\u0004xe&$\u0018N\\4\u0016\u0003\r\u000b1b\u001e:ji&twm\u0018\u0013fcR!\u0011QAA\r\u0011!\tiADA\u0001\u0002\u0004\u0019\u0015\u0001C<sSRLgn\u001a\u0011\u0002\u000fI,\u0017\rZ5oO\u0006Y!/Z1eS:<w\fJ3r)\u0011\t)!a\t\t\u0011\u00055\u0011#!AA\u0002\r\u000b\u0001B]3bI&tw\rI\u0001\n]Vl\u0017+^3vKN$\u0012\u0001Z\u0001\u0006gBLG\u000e\u001c\u000b\u0007\u0003_\t)$!\u000f\u0011\u0007!\u000b\t$C\u0002\u00024%\u0013A\u0001T8oO\"9\u0011q\u0007\u000bA\u0002\u0005=\u0012\u0001B:ju\u0016Da!a\u000f\u0015\u0001\u0004i\u0014a\u0002;sS\u001e<WM]\u0001\u0010GJ,\u0017\r^3ESN\\\u0017+^3vKR\t1)\u0001\bde\u0016\fG/\u001a(foF+X-^3\u0015\u0007\r\u000b)\u0005C\u0004\u0002HY\u0001\r!a\f\u0002\u0011I,\u0017/^5sK\u0012\f1!\u00193e)\u0011\ti%a\u0015\u0011\u0007!\u000by%C\u0002\u0002R%\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002V]\u0001\r!a\u0016\u0002\u0007I|w\u000f\u0005\u0003\u0002Z\u0005\rTBAA.\u0015\u0011\ti&a\u0018\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0004\u0003C\"\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005\u0015\u00141\f\u0002\n+:\u001c\u0018MZ3S_^\faA]3n_Z,GCAA,\u0003\u0015\u0019Gn\\:f)\t\t)!\u0001\u0003d_BLH#C:\u0002t\u0005U\u0014qOA=\u0011\u001d\u0001&\u0004%AA\u0002MCqa\u0016\u000e\u0011\u0002\u0003\u0007\u0011\fC\u0004c5A\u0005\t\u0019\u00013\t\u000f!T\u0002\u0013!a\u0001U\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA@U\r\u0019\u0016\u0011Q\u0016\u0003\u0003\u0007\u0003B!!\"\u0002\u00106\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)A\u0005v]\u000eDWmY6fI*\u0019\u0011QR%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0012\u0006\u001d%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAALU\rI\u0016\u0011Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tiJK\u0002e\u0003\u0003\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002$*\u001a!.!!\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u000b\u0005\u0003\u0002,\u0006EVBAAW\u0015\r\ty+X\u0001\u0005Y\u0006tw-\u0003\u0003\u00024\u00065&AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0016\u0011\u0019\t\u0004\u0011\u0006u\u0016bAA`\u0013\n\u0019\u0011I\\=\t\u0011\u00055\u0011%!AA\u0002\u0011\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000f\u0004b!!3\u0002P\u0006mVBAAf\u0015\r\ti-S\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAi\u0003\u0017\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QJAl\u0011%\tiaIA\u0001\u0002\u0004\tY,\u0001\u0005iCND7i\u001c3f\u0003!!xn\u0015;sS:<GCAAU\u0003\u0019)\u0017/^1mgR!\u0011QJAr\u0011%\tiAJA\u0001\u0002\u0004\tY,\u0001\nqe>$Xm\u0019;fI\u00122'/Z3QC\u001e,G\u0003BAu\u0003w$B!!\u0002\u0002l\"I\u0011QB\u0014\u0002\u0002\u0003\u0007\u0011Q\u001e\t\u0005\u0003_\f90\u0004\u0002\u0002r*\u0019\u0001)a=\u000b\u0007\u0005Uh'\u0001\u0004v]N\fg-Z\u0005\u0005\u0003s\f\tPA\u0006NK6|'/\u001f\"m_\u000e\\\u0007\u0002CA\u0007O\u0005\u0005\t\u0019A:\u0002\u001d!K(M]5e%><\u0018+^3vKB\u0011A)K\n\u0005S\t\rQ\nE\u0002I\u0005\u000bI1Aa\u0002J\u0005\u0019\te.\u001f*fMR\u0011\u0011q`\u0001\u0006CB\u0004H.\u001f\u000b\bg\n=!1\u0003B\f\u0011\u0019\u0011\tb\u000ba\u0001'\u0006iA/Y:l\u001b\u0016lwN]=NOJDaA!\u0006,\u0001\u0004I\u0016\u0001\u00024jY\u0016DaA!\u0007,\u0001\u0004!\u0017A\u00024jK2$7\u000fF\u0005t\u0005;\u0011yB!\t\u0003$!)\u0001\u000b\fa\u0001'\")q\u000b\fa\u00013\")!\r\fa\u0001I\")\u0001\u000e\fa\u0001U\u00069QO\\1qa2LH\u0003\u0002B\u0015\u0005k\u0001R\u0001\u0013B\u0016\u0005_I1A!\fJ\u0005\u0019y\u0005\u000f^5p]B9\u0001J!\rT3\u0012T\u0017b\u0001B\u001a\u0013\n1A+\u001e9mKRB\u0001Ba\u000e.\u0003\u0003\u0005\ra]\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0010\u0011\t\u0005-&qH\u0005\u0005\u0005\u0003\niK\u0001\u0004PE*,7\r\u001e")
public class HybridRowQueue
extends MemoryConsumer
implements RowQueue,
Product,
scala.Serializable {
    private final TaskMemoryManager memManager;
    private final File tempDir;
    private final int numFields;
    private final SerializerManager serMgr;
    private LinkedList<RowQueue> queues;
    private RowQueue writing;
    private RowQueue reading;

    public static Option<Tuple4<TaskMemoryManager, File, Object, SerializerManager>> unapply(HybridRowQueue hybridRowQueue) {
        return HybridRowQueue$.MODULE$.unapply(hybridRowQueue);
    }

    public static HybridRowQueue apply(TaskMemoryManager taskMemoryManager, File file, int n, SerializerManager serializerManager) {
        return HybridRowQueue$.MODULE$.apply(taskMemoryManager, file, n, serializerManager);
    }

    public static HybridRowQueue apply(TaskMemoryManager taskMemoryManager, File file, int n) {
        return HybridRowQueue$.MODULE$.apply(taskMemoryManager, file, n);
    }

    public /* synthetic */ void protected$freePage(HybridRowQueue x$1, MemoryBlock x$12) {
        x$1.freePage(x$12);
    }

    public TaskMemoryManager memManager() {
        return this.memManager;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public int numFields() {
        return this.numFields;
    }

    public SerializerManager serMgr() {
        return this.serMgr;
    }

    private LinkedList<RowQueue> queues() {
        return this.queues;
    }

    private void queues_$eq(LinkedList<RowQueue> x$1) {
        this.queues = x$1;
    }

    private RowQueue writing() {
        return this.writing;
    }

    private void writing_$eq(RowQueue x$1) {
        this.writing = x$1;
    }

    private RowQueue reading() {
        return this.reading;
    }

    private void reading_$eq(RowQueue x$1) {
        this.reading = x$1;
    }

    public int numQueues() {
        return this.queues().size();
    }

    public long spill(long size, MemoryConsumer trigger) {
        MemoryConsumer memoryConsumer = trigger;
        HybridRowQueue hybridRowQueue = this;
        if (!(memoryConsumer != null ? !memoryConsumer.equals(hybridRowQueue) : hybridRowQueue != null)) {
            return 0L;
        }
        long released = 0L;
        HybridRowQueue hybridRowQueue2 = this;
        synchronized (hybridRowQueue2) {
            LinkedList<RowQueue> newQueues = new LinkedList<RowQueue>();
            while (!this.queues().isEmpty()) {
                RowQueue rowQueue;
                RowQueue queue = this.queues().remove();
                if (!this.queues().isEmpty() && queue instanceof InMemoryRowQueue) {
                    RowQueue diskQueue = this.createDiskQueue();
                    UnsafeRow row = queue.remove();
                    while (row != null) {
                        diskQueue.add(row);
                        row = queue.remove();
                    }
                    released += ((InMemoryRowQueue)queue).page().size();
                    queue.close();
                    rowQueue = diskQueue;
                } else {
                    rowQueue = queue;
                }
                RowQueue newQueue = rowQueue;
                newQueues.add(newQueue);
            }
            this.queues_$eq(newQueues);
        }
        return released;
    }

    private RowQueue createDiskQueue() {
        return new DiskRowQueue(File.createTempFile("buffer", "", this.tempDir()), this.numFields(), this.serMgr());
    }

    private RowQueue createNewQueue(long required) {
        MemoryBlock memoryBlock;
        try {
            memoryBlock = this.allocatePage(required);
        }
        catch (SparkOutOfMemoryError sparkOutOfMemoryError) {
            memoryBlock = null;
        }
        MemoryBlock page = memoryBlock;
        RowQueue buffer = page != null ? new InMemoryRowQueue(this, page){
            private final /* synthetic */ HybridRowQueue $outer;

            public void close() {
                this.$outer.protected$freePage(this.$outer, this.page());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(page$1, $outer.numFields());
            }
        } : this.createDiskQueue();
        HybridRowQueue hybridRowQueue = this;
        synchronized (hybridRowQueue) {
            this.queues().add(buffer);
        }
        return buffer;
    }

    @Override
    public boolean add(UnsafeRow row) {
        if (this.writing() == null || !this.writing().add(row)) {
            this.writing_$eq(this.createNewQueue(4 + row.getSizeInBytes()));
            if (!this.writing().add(row)) {
                throw new SparkException(new StringBuilder(26).append("failed to push a row into ").append(this.writing()).toString());
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnsafeRow remove() {
        void var1_1;
        block5: {
            UnsafeRow row = null;
            if (this.reading() != null) {
                row = this.reading().remove();
            }
            if (row != null) break block5;
            if (this.reading() != null) {
                this.reading().close();
            }
            HybridRowQueue hybridRowQueue = this;
            synchronized (hybridRowQueue) {
                this.reading_$eq(this.queues().remove());
            }
            Predef$.MODULE$.assert(this.reading() != null, (Function0 & Serializable & scala.Serializable)() -> "queue should not be empty");
            row = this.reading().remove();
            Predef$.MODULE$.assert(row != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append(this.reading()).append(" should have at least one row").toString());
        }
        return var1_1;
    }

    @Override
    public void close() {
        if (this.reading() != null) {
            this.reading().close();
            this.reading_$eq(null);
        }
        HybridRowQueue hybridRowQueue = this;
        synchronized (hybridRowQueue) {
            while (!this.queues().isEmpty()) {
                this.queues().remove().close();
            }
        }
    }

    public HybridRowQueue copy(TaskMemoryManager memManager, File tempDir, int numFields, SerializerManager serMgr) {
        return new HybridRowQueue(memManager, tempDir, numFields, serMgr);
    }

    public TaskMemoryManager copy$default$1() {
        return this.memManager();
    }

    public File copy$default$2() {
        return this.tempDir();
    }

    public int copy$default$3() {
        return this.numFields();
    }

    public SerializerManager copy$default$4() {
        return this.serMgr();
    }

    public String productPrefix() {
        return "HybridRowQueue";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.memManager();
                break;
            }
            case 1: {
                object = this.tempDir();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.numFields());
                break;
            }
            case 3: {
                object = this.serMgr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HybridRowQueue;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.memManager()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tempDir()));
        n = Statics.mix((int)n, (int)this.numFields());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serMgr()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HybridRowQueue)) return false;
        boolean bl = true;
        if (!bl) return false;
        HybridRowQueue hybridRowQueue = (HybridRowQueue)x$1;
        TaskMemoryManager taskMemoryManager = this.memManager();
        TaskMemoryManager taskMemoryManager2 = hybridRowQueue.memManager();
        if (taskMemoryManager == null) {
            if (taskMemoryManager2 != null) {
                return false;
            }
        } else if (!taskMemoryManager.equals(taskMemoryManager2)) return false;
        File file = this.tempDir();
        File file2 = hybridRowQueue.tempDir();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        if (this.numFields() != hybridRowQueue.numFields()) return false;
        SerializerManager serializerManager = this.serMgr();
        SerializerManager serializerManager2 = hybridRowQueue.serMgr();
        if (serializerManager == null) {
            if (serializerManager2 != null) {
                return false;
            }
        } else if (!serializerManager.equals(serializerManager2)) return false;
        if (!hybridRowQueue.canEqual(this)) return false;
        return true;
    }

    public HybridRowQueue(TaskMemoryManager memManager, File tempDir, int numFields, SerializerManager serMgr) {
        this.memManager = memManager;
        this.tempDir = tempDir;
        this.numFields = numFields;
        this.serMgr = serMgr;
        super(memManager);
        Product.$init$((Product)this);
        this.queues = new LinkedList();
    }
}

