/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReader;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReaderFactory;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousDataSourceRDDPartition;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousQueuedDataReader;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTaskRetryException;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.NextIterator;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0007\u000f\u0001uA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0015\r\u0011\"\u0003<\u0011!\u0001\u0006A!A!\u0002\u0013a\u0004\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011a\u0003!\u0011!Q\u0001\neCQA\u0018\u0001\u0005\u0002}CQ\u0001\u001b\u0001\u0005R%DQ\u0001\u001d\u0001\u0005\nEDQa\u001e\u0001\u0005BaDq!!\u0002\u0001\t\u0003\n9AA\fD_:$\u0018N\\;pkN$\u0015\r^1T_V\u00148-\u001a*E\t*\u0011q\u0002E\u0001\u000bG>tG/\u001b8v_V\u001c(BA\t\u0013\u0003%\u0019HO]3b[&twM\u0003\u0002\u0014)\u0005IQ\r_3dkRLwN\u001c\u0006\u0003+Y\t1a]9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0003\u0001y\u00012a\b\u0012%\u001b\u0005\u0001#BA\u0011\u0017\u0003\r\u0011H\rZ\u0005\u0003G\u0001\u00121A\u0015#E!\t)\u0003&D\u0001'\u0015\t9C#\u0001\u0005dCR\fG._:u\u0013\tIcEA\u0006J]R,'O\\1m%><\u0018AA:d!\taS&D\u0001\u0017\u0013\tqcC\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0007eCR\f\u0017+^3vKNK'0\u001a\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0004\u0013:$\u0018aE3q_\u000eD\u0007k\u001c7m\u0013:$XM\u001d<bY6\u001b\bCA\u00199\u0013\tI$G\u0001\u0003M_:<\u0017aD5oaV$\b+\u0019:uSRLwN\\:\u0016\u0003q\u00022!P#I\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002B9\u00051AH]8pizJ\u0011aM\u0005\u0003\tJ\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\n\u00191+Z9\u000b\u0005\u0011\u0013\u0004CA%O\u001b\u0005Q%BA&M\u0003\u0011\u0011X-\u00193\u000b\u00055#\u0012!C2p]:,7\r^8s\u0013\ty%J\u0001\bJ]B,H\u000fU1si&$\u0018n\u001c8\u0002!%t\u0007/\u001e;QCJ$\u0018\u000e^5p]N\u0004\u0013AB:dQ\u0016l\u0017\r\u0005\u0002T-6\tAK\u0003\u0002V)\u0005)A/\u001f9fg&\u0011q\u000b\u0016\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017A\u00069beRLG/[8o%\u0016\fG-\u001a:GC\u000e$xN]=\u0011\u0005icV\"A.\u000b\u0005EQ\u0015BA/\\\u0005\u0001\u001auN\u001c;j]V|Wo\u001d)beRLG/[8o%\u0016\fG-\u001a:GC\u000e$xN]=\u0002\rqJg.\u001b;?)\u001d\u0001'm\u00193fM\u001e\u0004\"!\u0019\u0001\u000e\u00039AQA\u000b\u0005A\u0002-BQa\f\u0005A\u0002ABQA\u000e\u0005A\u0002]BQA\u000f\u0005A\u0002qBQ!\u0015\u0005A\u0002ICQ\u0001\u0017\u0005A\u0002e\u000bQbZ3u!\u0006\u0014H/\u001b;j_:\u001cX#\u00016\u0011\u0007EZW.\u0003\u0002me\t)\u0011I\u001d:bsB\u0011AF\\\u0005\u0003_Z\u0011\u0011\u0002U1si&$\u0018n\u001c8\u0002\u001b\r\f7\u000f\u001e)beRLG/[8o)\t\u0011X\u000f\u0005\u0002bg&\u0011AO\u0004\u0002!\u0007>tG/\u001b8v_V\u001cH)\u0019;b'>,(oY3S\t\u0012\u0003\u0016M\u001d;ji&|g\u000eC\u0003w\u0015\u0001\u0007Q.A\u0003ta2LG/A\u0004d_6\u0004X\u000f^3\u0015\u0007edX\u0010E\u0002>u\u0012J!a_$\u0003\u0011%#XM]1u_JDQA^\u0006A\u00025DQA`\u0006A\u0002}\fqaY8oi\u0016DH\u000fE\u0002-\u0003\u0003I1!a\u0001\u0017\u0005-!\u0016m]6D_:$X\r\u001f;\u0002+\u001d,G\u000f\u0015:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8ogR!\u0011\u0011BA\u000e!\u0011iT)a\u0003\u0011\t\u00055\u0011Q\u0003\b\u0005\u0003\u001f\t\t\u0002\u0005\u0002@e%\u0019\u00111\u0003\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\t9\"!\u0007\u0003\rM#(/\u001b8h\u0015\r\t\u0019B\r\u0005\u0006m2\u0001\r!\u001c")
public class ContinuousDataSourceRDD
extends RDD<InternalRow> {
    private final int dataQueueSize;
    private final long epochPollIntervalMs;
    private final Seq<InputPartition> inputPartitions;
    private final StructType schema;
    private final ContinuousPartitionReaderFactory partitionReaderFactory;

    private Seq<InputPartition> inputPartitions() {
        return this.inputPartitions;
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.inputPartitions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputPartition inputPartition = (InputPartition)tuple2._1();
            int index = tuple2._2$mcI$sp();
            ContinuousDataSourceRDDPartition continuousDataSourceRDDPartition = new ContinuousDataSourceRDDPartition(index, inputPartition);
            return continuousDataSourceRDDPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    private ContinuousDataSourceRDDPartition castPartition(Partition split) {
        ContinuousDataSourceRDDPartition continuousDataSourceRDDPartition;
        Partition partition = split;
        if (!(partition instanceof ContinuousDataSourceRDDPartition)) {
            throw new SparkException(new StringBuilder(46).append("[BUG] Not a ContinuousDataSourceRDDPartition: ").append(split).toString());
        }
        ContinuousDataSourceRDDPartition continuousDataSourceRDDPartition2 = continuousDataSourceRDDPartition = (ContinuousDataSourceRDDPartition)partition;
        return continuousDataSourceRDDPartition2;
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        if (context.attemptNumber() != 0) {
            throw new ContinuousTaskRetryException();
        }
        ContinuousDataSourceRDDPartition partition = this.castPartition(split);
        if (partition.queueReader() == null) {
            ContinuousPartitionReader partitionReader = this.partitionReaderFactory.createReader(partition.inputPartition());
            partition.queueReader_$eq(new ContinuousQueuedDataReader(partition.index(), (ContinuousPartitionReader<InternalRow>)partitionReader, this.schema, context, this.dataQueueSize, this.epochPollIntervalMs));
        }
        ContinuousQueuedDataReader readerForPartition = partition.queueReader();
        return new NextIterator<InternalRow>(null, readerForPartition){
            private final ContinuousQueuedDataReader readerForPartition$1;

            public InternalRow getNext() {
                InternalRow internalRow;
                InternalRow internalRow2 = this.readerForPartition$1.next();
                if (internalRow2 == null) {
                    this.finished_$eq(true);
                    internalRow = null;
                } else {
                    internalRow = internalRow2;
                }
                return internalRow;
            }

            public void close() {
            }
            {
                this.readerForPartition$1 = readerForPartition$1;
            }
        };
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.castPartition(split).inputPartition().preferredLocations());
    }

    public ContinuousDataSourceRDD(SparkContext sc, int dataQueueSize, long epochPollIntervalMs, Seq<InputPartition> inputPartitions, StructType schema, ContinuousPartitionReaderFactory partitionReaderFactory) {
        this.dataQueueSize = dataQueueSize;
        this.epochPollIntervalMs = epochPollIntervalMs;
        this.inputPartitions = inputPartitions;
        this.schema = schema;
        this.partitionReaderFactory = partitionReaderFactory;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalRow.class));
    }
}

