/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka;

import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.message.MessageAndMetadata;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.VerifiableProperties;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.kafka.HasOffsetRanges;
import org.apache.spark.streaming.kafka.KafkaCluster;
import org.apache.spark.streaming.kafka.KafkaRDD$;
import org.apache.spark.streaming.kafka.KafkaRDDPartition;
import org.apache.spark.streaming.kafka.OffsetRange;
import org.apache.spark.util.NextIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rmd!B\u0001\u0003\u0001\ta!\u0001C&bM.\f'\u000b\u0012#\u000b\u0005\r!\u0011!B6bM.\f'BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h+\u001di1MZ<\u0002\u0012Y\u0019B\u0001\u0001\b$OA\u0019qB\u0005\u000b\u000e\u0003AQ!!\u0005\u0004\u0002\u0007I$G-\u0003\u0002\u0014!\t\u0019!\u000b\u0012#\u0011\u0005U1B\u0002\u0001\u0003\u0006/\u0001\u0011\r!\u0007\u0002\u0002%\u000e\u0001\u0011C\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0011\n\u0005\tb\"aA!osB\u0011A%J\u0007\u0002\r%\u0011aE\u0002\u0002\b\u0019><w-\u001b8h!\tA\u0013&D\u0001\u0003\u0013\tQ#AA\bICN|eMZ:fiJ\u000bgnZ3t\u0011!a\u0003A!A!\u0002\u0013i\u0013AA:d!\t!c&\u0003\u00020\r\ta1\u000b]1sW\u000e{g\u000e^3yi\"A\u0011\u0007\u0001B\u0001B\u0003%!'A\u0006lC\u001a\\\u0017\rU1sC6\u001c\b\u0003B\u001a7ser!a\u0007\u001b\n\u0005Ub\u0012A\u0002)sK\u0012,g-\u0003\u00028q\t\u0019Q*\u00199\u000b\u0005Ub\u0002CA\u001a;\u0013\tY\u0004H\u0001\u0004TiJLgn\u001a\u0005\t{\u0001\u0011)\u0019!C\u0001}\u0005aqN\u001a4tKR\u0014\u0016M\\4fgV\tq\bE\u0002\u001c\u0001\nK!!\u0011\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005!\u001a\u0015B\u0001#\u0003\u0005-yeMZ:fiJ\u000bgnZ3\t\u0011\u0019\u0003!\u0011!Q\u0001\n}\nQb\u001c4gg\u0016$(+\u00198hKN\u0004\u0003\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\u0002\u000f1,\u0017\rZ3sgB!1G\u000e&R!\tYu*D\u0001M\u0015\tie*\u0001\u0004d_6lwN\u001c\u0006\u0002\u0007%\u0011\u0001\u000b\u0014\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0003B\u000eSsQK!a\u0015\u000f\u0003\rQ+\b\u000f\\33!\tYR+\u0003\u0002W9\t\u0019\u0011J\u001c;\t\u0011a\u0003!\u0011!Q\u0001\ne\u000ba\"\\3tg\u0006<W\rS1oI2,'\u000f\u0005\u0003\u001c5r#\u0012BA.\u001d\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003^A\n,W\"\u00010\u000b\u0005}s\u0015aB7fgN\fw-Z\u0005\u0003Cz\u0013!#T3tg\u0006<W-\u00118e\u001b\u0016$\u0018\rZ1uCB\u0011Qc\u0019\u0003\u0006I\u0002\u0011\r!\u0007\u0002\u0002\u0017B\u0011QC\u001a\u0003\u0006O\u0002\u0011\r!\u0007\u0002\u0002-\"A\u0011\u000e\u0001B\u0002B\u0003-!.\u0001\u0006fm&$WM\\2fIE\u00022a\u001b8c\u001b\u0005a'BA7\u001d\u0003\u001d\u0011XM\u001a7fGRL!a\u001c7\u0003\u0011\rc\u0017m]:UC\u001eD\u0001\"\u001d\u0001\u0003\u0004\u0003\u0006YA]\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA6oK\"AA\u000f\u0001B\u0002B\u0003-Q/\u0001\u0006fm&$WM\\2fIM\u00022a\u001b8w!\t)r\u000fB\u0003y\u0001\t\u0007\u0011PA\u0001V#\tQ\"\u0010M\u0002|\u0003\u000b\u0001B\u0001`@\u0002\u00045\tQP\u0003\u0002\u007f\u001d\u0006Q1/\u001a:jC2L'0\u001a:\n\u0007\u0005\u0005QPA\u0004EK\u000e|G-\u001a:\u0011\u0007U\t)\u0001\u0002\u0006\u0002\b]\f\t\u0011!A\u0003\u0002e\u00111a\u0018\u00132\u0011)\tY\u0001\u0001B\u0002B\u0003-\u0011QB\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004\u0003B6o\u0003\u001f\u00012!FA\t\t\u001d\t\u0019\u0002\u0001b\u0001\u0003+\u0011\u0011\u0001V\t\u00045\u0005]\u0001\u0007BA\r\u0003;\u0001B\u0001`@\u0002\u001cA\u0019Q#!\b\u0005\u0017\u0005}\u0011\u0011CA\u0001\u0002\u0003\u0015\t!\u0007\u0002\u0004?\u0012\u0012\u0004BCA\u0012\u0001\t\r\t\u0015a\u0003\u0002&\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\u0007-tG\u0003\u0003\u0005\u0002*\u0001!\tABA\u0016\u0003\u0019a\u0014N\\5u}Qa\u0011QFA\u001e\u0003{\ty$!\u0011\u0002DQa\u0011qFA\u0019\u0003g\t)$a\u000e\u0002:AA\u0001\u0006\u00012fm\u0006=A\u0003\u0003\u0004j\u0003O\u0001\u001dA\u001b\u0005\u0007c\u0006\u001d\u00029\u0001:\t\rQ\f9\u0003q\u0001v\u0011!\tY!a\nA\u0004\u00055\u0001\u0002CA\u0012\u0003O\u0001\u001d!!\n\t\r1\n9\u00031\u0001.\u0011\u0019\t\u0014q\u0005a\u0001e!1Q(a\nA\u0002}Ba\u0001SA\u0014\u0001\u0004I\u0005B\u0002-\u0002(\u0001\u0007\u0011\fC\u0004\u0002H\u0001!\t%!\u0013\u0002\u001b\u001d,G\u000fU1si&$\u0018n\u001c8t+\t\tY\u0005\u0005\u0003\u001c\u0001\u00065\u0003c\u0001\u0013\u0002P%\u0019\u0011\u0011\u000b\u0004\u0003\u0013A\u000b'\u000f^5uS>t\u0007bBA+\u0001\u0011\u0005\u0013qK\u0001\u0006G>,h\u000e\u001e\u000b\u0003\u00033\u00022aGA.\u0013\r\ti\u0006\b\u0002\u0005\u0019>tw\rC\u0004\u0002b\u0001!\t%a\u0019\u0002\u0017\r|WO\u001c;BaB\u0014x\u000e\u001f\u000b\u0007\u0003K\n9(a\u001f\u0011\r\u0005\u001d\u0014QNA9\u001b\t\tIGC\u0002\u0002l\u0019\tq\u0001]1si&\fG.\u0003\u0003\u0002p\u0005%$!\u0004)beRL\u0017\r\u001c*fgVdG\u000f\u0005\u0003\u0002h\u0005M\u0014\u0002BA;\u0003S\u0012QBQ8v]\u0012,G\rR8vE2,\u0007\u0002CA=\u0003?\u0002\r!!\u0017\u0002\u000fQLW.Z8vi\"Q\u0011QPA0!\u0003\u0005\r!a \u0002\u0015\r|gNZ5eK:\u001cW\rE\u0002\u001c\u0003\u0003K1!a!\u001d\u0005\u0019!u.\u001e2mK\"9\u0011q\u0011\u0001\u0005B\u0005%\u0015aB5t\u000b6\u0004H/\u001f\u000b\u0003\u0003\u0017\u00032aGAG\u0013\r\ty\t\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\n\u0001C!\u0003+\u000bA\u0001^1lKR!\u0011qSAM!\rY\u0002\t\u0006\u0005\b\u00037\u000b\t\n1\u0001U\u0003\rqW/\u001c\u0005\b\u0003?\u0003A\u0011IAQ\u0003U9W\r\u001e)sK\u001a,'O]3e\u0019>\u001c\u0017\r^5p]N$B!a)\u0002<B)\u0011QUA[s9!\u0011qUAY\u001d\u0011\tI+a,\u000e\u0005\u0005-&bAAW1\u00051AH]8pizJ\u0011!H\u0005\u0004\u0003gc\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003o\u000bILA\u0002TKFT1!a-\u001d\u0011!\ti,!(A\u0002\u00055\u0013a\u0002;iKB\u000b'\u000f\u001e\u0005\b\u0003\u0003\u0004A\u0011BAb\u0003A)'O\u001d\"fO&t\u0017I\u001a;fe\u0016sG\rF\u0002:\u0003\u000bD\u0001\"a2\u0002@\u0002\u0007\u0011\u0011Z\u0001\u0005a\u0006\u0014H\u000fE\u0002)\u0003\u0017L1!!4\u0003\u0005EY\u0015MZ6b%\u0012#\u0005+\u0019:uSRLwN\u001c\u0005\b\u0003#\u0004A\u0011BAj\u0003I)'O\u001d*b]>+HOQ3g_J,WI\u001c3\u0015\u0007e\n)\u000e\u0003\u0005\u0002H\u0006=\u0007\u0019AAe\u0011\u001d\tI\u000e\u0001C\u0005\u00037\fa\"\u001a:s\u001fZ,'o\u001d5pi\u0016sG\rF\u0003:\u0003;\f\t\u000f\u0003\u0005\u0002`\u0006]\u0007\u0019AA-\u0003)IG/Z7PM\u001a\u001cX\r\u001e\u0005\t\u0003\u000f\f9\u000e1\u0001\u0002J\"9\u0011Q\u001d\u0001\u0005B\u0005\u001d\u0018aB2p[B,H/\u001a\u000b\u0007\u0003S\fy/!=\u0011\u000b\u0005\u0015\u00161\u001e\u000b\n\t\u00055\u0018\u0011\u0018\u0002\t\u0013R,'/\u0019;pe\"A\u0011QXAr\u0001\u0004\ti\u0005\u0003\u0005\u0002t\u0006\r\b\u0019AA{\u0003\u001d\u0019wN\u001c;fqR\u00042\u0001JA|\u0013\r\tIP\u0002\u0002\f)\u0006\u001c8nQ8oi\u0016DHO\u0002\u0004\u0002~\u0002!\u0011q \u0002\u0011\u0017\u000647.\u0019*E\t&#XM]1u_J\u001cB!a?\u0003\u0002A)!1\u0001B\u0005)5\u0011!Q\u0001\u0006\u0004\u0005\u000f1\u0011\u0001B;uS2LAAa\u0003\u0003\u0006\taa*\u001a=u\u0013R,'/\u0019;pe\"Y\u0011qYA~\u0005\u0003\u0005\u000b\u0011BAe\u0011-\t\u00190a?\u0003\u0002\u0003\u0006I!!>\t\u0011\u0005%\u00121 C\u0001\u0005'!bA!\u0006\u0003\u001a\tm\u0001\u0003\u0002B\f\u0003wl\u0011\u0001\u0001\u0005\t\u0003\u000f\u0014\t\u00021\u0001\u0002J\"A\u00111\u001fB\t\u0001\u0004\t)\u0010\u0003\u0006\u0003 \u0005m(\u0019!C\u0001\u0005C\t!a[2\u0016\u0005\t\r\u0002c\u0001\u0015\u0003&%\u0019!q\u0005\u0002\u0003\u0019-\u000bgm[1DYV\u001cH/\u001a:\t\u0013\t-\u00121 Q\u0001\n\t\r\u0012aA6dA!Q!qFA~\u0005\u0004%\tA!\r\u0002\u0015-,\u0017\u0010R3d_\u0012,'/\u0006\u0002\u00034A\u0019Ap 2\t\u0013\t]\u00121 Q\u0001\n\tM\u0012aC6fs\u0012+7m\u001c3fe\u0002B!Ba\u000f\u0002|\n\u0007I\u0011\u0001B\u001f\u000311\u0018\r\\;f\t\u0016\u001cw\u000eZ3s+\t\u0011y\u0004E\u0002}\u007f\u0016D\u0011Ba\u0011\u0002|\u0002\u0006IAa\u0010\u0002\u001bY\fG.^3EK\u000e|G-\u001a:!\u0011)\u00119%a?C\u0002\u0013\u0005!\u0011J\u0001\tG>t7/^7feV\u0011!1\n\t\u0005\u0005\u001b\u0012\t&\u0004\u0002\u0003P)\u0019!q\t(\n\t\tM#q\n\u0002\u000f'&l\u0007\u000f\\3D_:\u001cX/\\3s\u0011%\u00119&a?!\u0002\u0013\u0011Y%A\u0005d_:\u001cX/\\3sA!Q!1LA~\u0001\u0004%\tA!\u0018\u0002\u001bI,\u0017/^3ti>3gm]3u+\t\tI\u0006\u0003\u0006\u0003b\u0005m\b\u0019!C\u0001\u0005G\n\u0011C]3rk\u0016\u001cHo\u00144gg\u0016$x\fJ3r)\u0011\u0011)Ga\u001b\u0011\u0007m\u00119'C\u0002\u0003jq\u0011A!\u00168ji\"Q!Q\u000eB0\u0003\u0003\u0005\r!!\u0017\u0002\u0007a$\u0013\u0007C\u0005\u0003r\u0005m\b\u0015)\u0003\u0002Z\u0005q!/Z9vKN$xJ\u001a4tKR\u0004\u0003B\u0003B;\u0003w\u0004\r\u0011\"\u0001\u0003x\u0005!\u0011\u000e^3s+\t\u0011I\b\u0005\u0004\u0002&\u0006-(1\u0010\t\u0004;\nu\u0014b\u0001B@=\n\u0001R*Z:tC\u001e,\u0017I\u001c3PM\u001a\u001cX\r\u001e\u0005\u000b\u0005\u0007\u000bY\u00101A\u0005\u0002\t\u0015\u0015\u0001C5uKJ|F%Z9\u0015\t\t\u0015$q\u0011\u0005\u000b\u0005[\u0012\t)!AA\u0002\te\u0004\"\u0003BF\u0003w\u0004\u000b\u0015\u0002B=\u0003\u0015IG/\u001a:!\u0011!\u0011y)a?\u0005\n\t%\u0013!D2p]:,7\r\u001e'fC\u0012,'\u000f\u0003\u0005\u0003\u0014\u0006mH\u0011\u0002BK\u00039A\u0017M\u001c3mK\u001a+Go\u00195FeJ$BA!\u001a\u0003\u0018\"A!\u0011\u0014BI\u0001\u0004\u0011Y*\u0001\u0003sKN\u0004\b\u0003\u0002BO\u0005Gk!Aa(\u000b\u0007\t\u0005f*A\u0002ba&LAA!*\u0003 \nia)\u001a;dQJ+7\u000f]8og\u0016D\u0001B!+\u0002|\u0012%!qO\u0001\u000bM\u0016$8\r\u001b\"bi\u000eD\u0007\u0002\u0003BW\u0003w$\tEa,\u0002\u000b\rdwn]3\u0015\u0005\t\u0015\u0004\u0002\u0003BZ\u0003w$\tE!.\u0002\u000f\u001d,GOT3yiR\tA\u0003C\u0005\u0003:\u0002\t\n\u0011\"\u0011\u0003<\u0006)2m\\;oi\u0006\u0003\bO]8yI\u0011,g-Y;mi\u0012\u0012TC\u0001B_U\u0011\tyHa0,\u0005\t\u0005\u0007\u0003\u0002Bb\u0005\u001bl!A!2\u000b\t\t\u001d'\u0011Z\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa3\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0014)MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016<\u0001Ba5\u0003\u0011\u0003\u0011!Q[\u0001\t\u0017\u000647.\u0019*E\tB\u0019\u0001Fa6\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0003ZN1!q\u001bBn\u0005C\u00042a\u0007Bo\u0013\r\u0011y\u000e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007m\u0011\u0019/C\u0002\u0003fr\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"!\u000b\u0003X\u0012\u0005!\u0011\u001e\u000b\u0003\u0005+D\u0001B!<\u0003X\u0012\u0005!q^\u0001\u0006CB\u0004H._\u000b\r\u0005c\u0014IP!@\u0004\u0002\rE1\u0011\u0005\u000b\r\u0005g\u001c\tea\u0011\u0004F\r-3q\f\u000b\r\u0005k\u001c\u0019c!\u000b\u00040\rU21\b\t\rQ\u0001\u00119Pa?\u0003\u0000\u000e=1q\u0004\t\u0004+\teHA\u00023\u0003l\n\u0007\u0011\u0004E\u0002\u0016\u0005{$aa\u001aBv\u0005\u0004I\u0002cA\u000b\u0004\u0002\u00119\u0001Pa;C\u0002\r\r\u0011c\u0001\u000e\u0004\u0006A\"1qAB\u0006!\u0011axp!\u0003\u0011\u0007U\u0019Y\u0001B\u0006\u0004\u000e\r\u0005\u0011\u0011!A\u0001\u0006\u0003I\"aA0%gA\u0019Qc!\u0005\u0005\u0011\u0005M!1\u001eb\u0001\u0007'\t2AGB\u000ba\u0011\u00199ba\u0007\u0011\tq|8\u0011\u0004\t\u0004+\rmAaCB\u000f\u0007#\t\t\u0011!A\u0003\u0002e\u00111a\u0018\u00135!\r)2\u0011\u0005\u0003\u0007/\t-(\u0019A\r\t\u0015\r\u0015\"1^A\u0001\u0002\b\u00199#\u0001\u0006fm&$WM\\2fIY\u0002Ba\u001b8\u0003x\"Q11\u0006Bv\u0003\u0003\u0005\u001da!\f\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$s\u0007\u0005\u0003l]\nm\bBCB\u0019\u0005W\f\t\u0011q\u0001\u00044\u0005QQM^5eK:\u001cW\r\n\u001d\u0011\t-t'q \u0005\u000b\u0007o\u0011Y/!AA\u0004\re\u0012AC3wS\u0012,gnY3%sA!1N\\B\b\u0011)\u0019iDa;\u0002\u0002\u0003\u000f1qH\u0001\fKZLG-\u001a8dK\u0012\n\u0004\u0007\u0005\u0003l]\u000e}\u0001B\u0002\u0017\u0003l\u0002\u0007Q\u0006\u0003\u00042\u0005W\u0004\rA\r\u0005\t\u0007\u000f\u0012Y\u000f1\u0001\u0004J\u0005YaM]8n\u001f\u001a47/\u001a;t!\u0015\u0019dGSA-\u0011!\u0019iEa;A\u0002\r=\u0013\u0001D;oi&dwJ\u001a4tKR\u001c\b#B\u001a7\u0015\u000eE\u0003\u0003BB*\u00073r1\u0001KB+\u0013\r\u00199FA\u0001\r\u0017\u000647.Y\"mkN$XM]\u0005\u0005\u00077\u001aiF\u0001\u0007MK\u0006$WM](gMN,GOC\u0002\u0004X\tAq\u0001\u0017Bv\u0001\u0004\u0019\t\u0007\u0005\u0004\u001c5\u000e\r4q\u0004\t\u0007;\u0002\u00149Pa?\t\u0015\r\u001d$q[A\u0001\n\u0013\u0019I'A\u0006sK\u0006$'+Z:pYZ,GCAB6!\u0011\u0019iga\u001e\u000e\u0005\r=$\u0002BB9\u0007g\nA\u0001\\1oO*\u00111QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0004z\r=$AB(cU\u0016\u001cG\u000f")
public class KafkaRDD<K, V, U extends Decoder<?>, T extends Decoder<?>, R>
extends RDD<R>
implements HasOffsetRanges {
    public final Map<String, String> org$apache$spark$streaming$kafka$KafkaRDD$$kafkaParams;
    private final OffsetRange[] offsetRanges;
    public final Map<TopicAndPartition, Tuple2<String, Object>> org$apache$spark$streaming$kafka$KafkaRDD$$leaders;
    public final Function1<MessageAndMetadata<K, V>, R> org$apache$spark$streaming$kafka$KafkaRDD$$messageHandler;
    public final ClassTag<U> org$apache$spark$streaming$kafka$KafkaRDD$$evidence$3;
    public final ClassTag<T> org$apache$spark$streaming$kafka$KafkaRDD$$evidence$4;
    public final ClassTag<R> org$apache$spark$streaming$kafka$KafkaRDD$$evidence$5;

    public static <K, V, U extends Decoder<?>, T extends Decoder<?>, R> KafkaRDD<K, V, U, T, R> apply(SparkContext sparkContext, Map<String, String> map, Map<TopicAndPartition, Object> map2, Map<TopicAndPartition, KafkaCluster.LeaderOffset> map3, Function1<MessageAndMetadata<K, V>, R> function1, ClassTag<K> classTag, ClassTag<V> classTag2, ClassTag<U> classTag3, ClassTag<T> classTag4, ClassTag<R> classTag5) {
        return KafkaRDD$.MODULE$.apply(sparkContext, map, map2, map3, function1, classTag, classTag2, classTag3, classTag4, classTag5);
    }

    @Override
    public OffsetRange[] offsetRanges() {
        return this.offsetRanges;
    }

    public Partition[] getPartitions() {
        return (Partition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaRDD $outer;

            public final KafkaRDDPartition apply(Tuple2<OffsetRange, Object> x0$1) {
                Tuple2<OffsetRange, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    OffsetRange o = (OffsetRange)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)this.$outer.org$apache$spark$streaming$kafka$KafkaRDD$$leaders.apply((Object)new TopicAndPartition(o.topic(), o.partition()));
                    if (tuple22 != null) {
                        Tuple2 tuple23;
                        String host = (String)tuple22._1();
                        int port = tuple22._2$mcI$sp();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                        String host2 = (String)tuple24._1();
                        int port2 = tuple24._2$mcI$sp();
                        KafkaRDDPartition kafkaRDDPartition = new KafkaRDDPartition(i, o.topic(), o.partition(), o.fromOffset(), o.untilOffset(), host2, port2);
                        return kafkaRDDPartition;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaRDDPartition.class)))).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public long count() {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetRange x$2) {
                return x$2.count();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public PartialResult<BoundedDouble> countApprox(long timeout, double confidence) {
        long c = this.count();
        return new PartialResult((Object)new BoundedDouble((double)c, 1.0, (double)c, (double)c), true);
    }

    public double countApprox$default$2() {
        return 0.95;
    }

    public boolean isEmpty() {
        return this.count() == 0L;
    }

    public Object take(int num) {
        KafkaRDDPartition[] nonEmptyPartitions = (KafkaRDDPartition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.partitions()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaRDDPartition apply(Partition x$3) {
                return (KafkaRDDPartition)x$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaRDDPartition.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaRDDPartition x$4) {
                return x$4.count() > 0L;
            }
        });
        if (num < 1 || Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).size() < 1) {
            return this.org$apache$spark$streaming$kafka$KafkaRDD$$evidence$5.newArray(0);
        }
        Map parts = (Map)Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this, num){
            public static final long serialVersionUID = 0L;
            private final int num$1;

            public final Map<Object, Object> apply(Map<Object, Object> result, KafkaRDDPartition part) {
                Map map;
                int remain = this.num$1 - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if (remain > 0) {
                    long taken = Math.min((long)remain, part.count());
                    map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
                } else {
                    map = result;
                }
                return map;
            }
            {
                this.num$1 = num$1;
            }
        });
        ArrayBuffer buf = new ArrayBuffer();
        Object[] res = (Object[])this.context().runJob((RDD)this, (Function2)new Serializable(this, parts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaRDD $outer;
            private final Map parts$1;

            public final Object apply(TaskContext tc, Iterator<R> it) {
                return it.take(BoxesRunTime.unboxToInt((Object)this.parts$1.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(this.$outer.org$apache$spark$streaming$kafka$KafkaRDD$$evidence$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parts$1 = parts$1;
            }
        }, (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(this.org$apache$spark$streaming$kafka$KafkaRDD$$evidence$5.runtimeClass())));
        Predef$.MODULE$.refArrayOps(res).foreach((Function1)new Serializable(this, buf){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer buf$1;

            public final ArrayBuffer<R> apply(Object x$5) {
                return this.buf$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.genericArrayOps(x$5));
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return buf.toArray(this.org$apache$spark$streaming$kafka$KafkaRDD$$evidence$5);
    }

    public Seq<String> getPreferredLocations(Partition thePart) {
        KafkaRDDPartition part = (KafkaRDDPartition)thePart;
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{part.host()}));
    }

    public String org$apache$spark$streaming$kafka$KafkaRDD$$errBeginAfterEnd(KafkaRDDPartition part) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is after the ending offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)part.fromOffset()), BoxesRunTime.boxToLong((long)part.untilOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for topic ", " partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{part.topic(), BoxesRunTime.boxToInteger((int)part.partition())}))).append((Object)"You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString();
    }

    public String org$apache$spark$streaming$kafka$KafkaRDD$$errRanOutBeforeEnd(KafkaRDDPartition part) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ran out of messages before reaching ending offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)part.untilOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for topic ", " partition ", " start ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{part.topic(), BoxesRunTime.boxToInteger((int)part.partition()), BoxesRunTime.boxToLong((long)part.fromOffset())}))).append((Object)" This should not happen, and indicates that messages may have been lost").toString();
    }

    public String org$apache$spark$streaming$kafka$KafkaRDD$$errOvershotEnd(long itemOffset, KafkaRDDPartition part) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " > ending offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)itemOffset), BoxesRunTime.boxToLong((long)part.untilOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for topic ", " partition ", " start ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{part.topic(), BoxesRunTime.boxToInteger((int)part.partition()), BoxesRunTime.boxToLong((long)part.fromOffset())}))).append((Object)" This should not happen, and indicates a message may have been skipped").toString();
    }

    public Iterator<R> compute(Partition thePart, TaskContext context) {
        KafkaRDDIterator kafkaRDDIterator;
        KafkaRDDPartition part = (KafkaRDDPartition)thePart;
        Predef$.MODULE$.assert(part.fromOffset() <= part.untilOffset(), (Function0)new Serializable(this, part){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaRDD $outer;
            private final KafkaRDDPartition part$1;

            public final String apply() {
                return this.$outer.org$apache$spark$streaming$kafka$KafkaRDD$$errBeginAfterEnd(this.part$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.part$1 = part$1;
            }
        });
        if (part.fromOffset() == part.untilOffset()) {
            this.log().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is the same as ending offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)part.fromOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"skipping ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{part.topic(), BoxesRunTime.boxToInteger((int)part.partition())}))).toString());
            kafkaRDDIterator = package$.MODULE$.Iterator().empty();
        } else {
            kafkaRDDIterator = new KafkaRDDIterator(this, part, context);
        }
        return kafkaRDDIterator;
    }

    public KafkaRDD(SparkContext sc, Map<String, String> kafkaParams, OffsetRange[] offsetRanges, Map<TopicAndPartition, Tuple2<String, Object>> leaders, Function1<MessageAndMetadata<K, V>, R> messageHandler, ClassTag<K> evidence$1, ClassTag<V> evidence$2, ClassTag<U> evidence$3, ClassTag<T> evidence$4, ClassTag<R> evidence$5) {
        this.org$apache$spark$streaming$kafka$KafkaRDD$$kafkaParams = kafkaParams;
        this.offsetRanges = offsetRanges;
        this.org$apache$spark$streaming$kafka$KafkaRDD$$leaders = leaders;
        this.org$apache$spark$streaming$kafka$KafkaRDD$$messageHandler = messageHandler;
        this.org$apache$spark$streaming$kafka$KafkaRDD$$evidence$3 = evidence$3;
        this.org$apache$spark$streaming$kafka$KafkaRDD$$evidence$4 = evidence$4;
        this.org$apache$spark$streaming$kafka$KafkaRDD$$evidence$5 = evidence$5;
        super(sc, (Seq)Nil$.MODULE$, evidence$5);
    }

    public class KafkaRDDIterator
    extends NextIterator<R> {
        public final KafkaRDDPartition org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part;
        private final TaskContext context;
        private final KafkaCluster kc;
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;
        private final SimpleConsumer consumer;
        private long requestOffset;
        private Iterator<MessageAndOffset> iter;
        public final /* synthetic */ KafkaRDD $outer;

        public KafkaCluster kc() {
            return this.kc;
        }

        public Decoder<K> keyDecoder() {
            return this.keyDecoder;
        }

        public Decoder<V> valueDecoder() {
            return this.valueDecoder;
        }

        public SimpleConsumer consumer() {
            return this.consumer;
        }

        public long requestOffset() {
            return this.requestOffset;
        }

        public void requestOffset_$eq(long x$1) {
            this.requestOffset = x$1;
        }

        public Iterator<MessageAndOffset> iter() {
            return this.iter;
        }

        public void iter_$eq(Iterator<MessageAndOffset> x$1) {
            this.iter = x$1;
        }

        private SimpleConsumer connectLeader() {
            return this.context.attemptNumber() > 0 ? (SimpleConsumer)this.kc().connectLeader(this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.topic(), this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.partition()).fold((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaRDDIterator $outer;

                public final Nothing$ apply(ArrayBuffer<Throwable> errs) {
                    throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't connect to leader for topic ", " ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.topic(), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.partition())}))).append((Object)errs.mkString("\n")).toString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SimpleConsumer apply(SimpleConsumer consumer) {
                    return consumer;
                }
            }) : this.kc().connect(this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.host(), this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.port());
        }

        private void handleFetchErr(FetchResponse resp) {
            if (resp.hasError()) {
                short err = resp.errorCode(this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.topic(), this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.partition());
                if (err == ErrorMapping$.MODULE$.LeaderNotAvailableCode() || err == ErrorMapping$.MODULE$.NotLeaderForPartitionCode()) {
                    this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$$outer().log().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Lost leader for topic ", " partition ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.topic(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.partition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" sleeping for ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kc().config().refreshLeaderBackoffMs())}))).toString());
                    Thread.sleep(this.kc().config().refreshLeaderBackoffMs());
                }
                throw ErrorMapping$.MODULE$.exceptionFor(err);
            }
        }

        private Iterator<MessageAndOffset> fetchBatch() {
            FetchRequest req = new FetchRequestBuilder().addFetch(this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.topic(), this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.partition(), this.requestOffset(), this.kc().config().fetchMessageMaxBytes()).build();
            FetchResponse resp = this.consumer().fetch(req);
            this.handleFetchErr(resp);
            return resp.messageSet(this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.topic(), this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.partition()).iterator().dropWhile((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaRDDIterator $outer;

                public final boolean apply(MessageAndOffset x$6) {
                    return x$6.offset() < this.$outer.requestOffset();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void close() {
            if (this.consumer() != null) {
                this.consumer().close();
            }
        }

        public R getNext() {
            Object object;
            if (this.iter() == null || !this.iter().hasNext()) {
                this.iter_$eq(this.fetchBatch());
            }
            if (this.iter().hasNext()) {
                MessageAndOffset item = (MessageAndOffset)this.iter().next();
                if (item.offset() >= this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.untilOffset()) {
                    Predef$.MODULE$.assert(item.offset() == this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.untilOffset(), (Function0)new Serializable(this, item){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaRDDIterator $outer;
                        private final MessageAndOffset item$1;

                        public final String apply() {
                            return this.$outer.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$$outer().org$apache$spark$streaming$kafka$KafkaRDD$$errOvershotEnd(this.item$1.offset(), this.$outer.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.item$1 = item$1;
                        }
                    });
                    this.finished_$eq(true);
                    object = null;
                } else {
                    this.requestOffset_$eq(item.nextOffset());
                    object = this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$$outer().org$apache$spark$streaming$kafka$KafkaRDD$$messageHandler.apply((Object)new MessageAndMetadata(this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.topic(), this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.partition(), item.message(), item.offset(), this.keyDecoder(), this.valueDecoder()));
                }
            } else {
                Predef$.MODULE$.assert(this.requestOffset() == this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part.untilOffset(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaRDDIterator $outer;

                    public final String apply() {
                        return this.$outer.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$$outer().org$apache$spark$streaming$kafka$KafkaRDD$$errRanOutBeforeEnd(this.$outer.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.finished_$eq(true);
                object = null;
            }
            return object;
        }

        public /* synthetic */ KafkaRDD org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$$outer() {
            return this.$outer;
        }

        public KafkaRDDIterator(KafkaRDD<K, V, U, T, R> $outer, KafkaRDDPartition part, TaskContext context) {
            this.org$apache$spark$streaming$kafka$KafkaRDD$KafkaRDDIterator$$part = part;
            this.context = context;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            context.addTaskCompletionListener((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaRDDIterator $outer;

                public final void apply(TaskContext context) {
                    this.$outer.closeIfNeeded();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            $outer.log().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Computing topic ", ", partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{part.topic(), BoxesRunTime.boxToInteger((int)part.partition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offsets ", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)part.fromOffset()), BoxesRunTime.boxToLong((long)part.untilOffset())}))).toString());
            this.kc = new KafkaCluster($outer.org$apache$spark$streaming$kafka$KafkaRDD$$kafkaParams);
            this.keyDecoder = (Decoder)scala.reflect.package$.MODULE$.classTag($outer.org$apache$spark$streaming$kafka$KafkaRDD$$evidence$3).runtimeClass().getConstructor(VerifiableProperties.class).newInstance(this.kc().config().props());
            this.valueDecoder = (Decoder)scala.reflect.package$.MODULE$.classTag($outer.org$apache$spark$streaming$kafka$KafkaRDD$$evidence$4).runtimeClass().getConstructor(VerifiableProperties.class).newInstance(this.kc().config().props());
            this.consumer = this.connectLeader();
            this.requestOffset = part.fromOffset();
            this.iter = null;
        }
    }
}

