/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.ClassFileIClass;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.FilterWarningHandler;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.Benchmark;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.resource.DirectoryResourceCreator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.FileResource;
import org.codehaus.janino.util.resource.FileResourceCreator;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;

public class Compiler {
    private static final Logger LOGGER = Logger.getLogger(Compiler.class.getName());
    private static final String USAGE = "Usage:%n%n  java " + Compiler.class.getName() + " [ <option> ] ... <source-file> ...%n" + "%n" + "Supported <option>s are:%n" + "  -d <output-dir>           Where to save class files%n" + "  -sourcepath <dirlist>     Where to look for other source files%n" + "  -classpath <dirlist>      Where to look for other class files%n" + "  -extdirs <dirlist>        Where to look for other class files%n" + "  -bootclasspath <dirlist>  Where to look for other class files%n" + "  -encoding <encoding>      Encoding of source files, e.g. \"UTF-8\" or \"ISO-8859-1\"%n" + "  -verbose%n" + "  -g                        Generate all debugging info%n" + "  -g:none                   Generate no debugging info%n" + "  -g:{source,lines,vars}    Generate only some debugging info%n" + "  -warn:<pattern-list>      Issue certain warnings; examples:%n" + "    -warn:*                 Enables all warnings%n" + "    -warn:IASF              Only warn against implicit access to static fields%n" + "    -warn:*-IASF            Enables all warnings, except those against implicit%n" + "                            access to static fields%n" + "    -warn:*-IA*+IASF        Enables all warnings, except those against implicit%n" + "                            accesses, but do warn against implicit access to%n" + "                            static fields%n" + "  -rebuild                  Compile all source files, even if the class files%n" + "                            seems up-to-date%n" + "  -help%n" + "%n" + "The default encoding in this environment is \"" + Charset.defaultCharset().toString() + "\".";
    @Nullable
    public static final ResourceFinder FIND_NEXT_TO_SOURCE_FILE = null;
    @Nullable
    public static final ResourceCreator CREATE_NEXT_TO_SOURCE_FILE = null;
    @Nullable
    private final ResourceCreator classFileCreator;
    @Nullable
    private final ResourceFinder classFileFinder;
    @Nullable
    private final String optionalCharacterEncoding;
    private final Benchmark benchmark;
    private final boolean debugSource;
    private final boolean debugLines;
    private final boolean debugVars;
    @Nullable
    private WarningHandler optionalWarningHandler;
    @Nullable
    private ErrorHandler optionalCompileErrorHandler;
    private final IClassLoader iClassLoader;
    private final List<UnitCompiler> parsedCompilationUnits = new ArrayList<UnitCompiler>();
    @Nullable
    public static final File NO_DESTINATION_DIRECTORY = null;
    public static final StringPattern[] DEFAULT_WARNING_HANDLE_PATTERNS = StringPattern.PATTERNS_NONE;

    public static void main(String[] args) {
        String arg;
        int i;
        File destinationDirectory = NO_DESTINATION_DIRECTORY;
        File[] optionalSourcePath = null;
        File[] classPath = new File[]{new File(".")};
        File[] optionalExtDirs = null;
        File[] optionalBootClassPath = null;
        String optionalCharacterEncoding = null;
        boolean verbose = false;
        boolean debugSource = true;
        boolean debugLines = true;
        boolean debugVars = false;
        StringPattern[] warningHandlePatterns = DEFAULT_WARNING_HANDLE_PATTERNS;
        boolean rebuild = false;
        for (i = 0; i < args.length && (arg = args[i]).charAt(0) == '-'; ++i) {
            if ("-d".equals(arg)) {
                destinationDirectory = new File(args[++i]);
                continue;
            }
            if ("-sourcepath".equals(arg)) {
                optionalSourcePath = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if ("-classpath".equals(arg)) {
                classPath = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if ("-extdirs".equals(arg)) {
                optionalExtDirs = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if ("-bootclasspath".equals(arg)) {
                optionalBootClassPath = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if ("-encoding".equals(arg)) {
                optionalCharacterEncoding = args[++i];
                continue;
            }
            if ("-verbose".equals(arg)) {
                verbose = true;
                continue;
            }
            if ("-g".equals(arg)) {
                debugSource = true;
                debugLines = true;
                debugVars = true;
                continue;
            }
            if (arg.startsWith("-g:")) {
                if (arg.indexOf("none") != -1) {
                    debugVars = false;
                    debugLines = false;
                    debugSource = false;
                }
                if (arg.indexOf("source") != -1) {
                    debugSource = true;
                }
                if (arg.indexOf("lines") != -1) {
                    debugLines = true;
                }
                if (arg.indexOf("vars") == -1) continue;
                debugVars = true;
                continue;
            }
            if (arg.startsWith("-warn:")) {
                warningHandlePatterns = StringPattern.parseCombinedPattern(arg.substring(6));
                continue;
            }
            if ("-rebuild".equals(arg)) {
                rebuild = true;
                continue;
            }
            if ("-help".equals(arg)) {
                System.out.printf(USAGE, (Object[])null);
                System.exit(1);
                continue;
            }
            System.err.println("Unrecognized command line option \"" + arg + "\"; try \"-help\".");
            System.exit(1);
        }
        if (i == args.length) {
            System.err.println("No source files given on command line; try \"-help\".");
            System.exit(1);
        }
        File[] sourceFiles = new File[args.length - i];
        for (int j = i; j < args.length; ++j) {
            sourceFiles[j - i] = new File(args[j]);
        }
        Compiler compiler = new Compiler(optionalSourcePath, classPath, optionalExtDirs, optionalBootClassPath, destinationDirectory, optionalCharacterEncoding, verbose, debugSource, debugLines, debugVars, warningHandlePatterns, rebuild);
        try {
            compiler.compile(sourceFiles);
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            } else {
                System.err.println(e.toString());
            }
            System.exit(1);
        }
    }

    public Compiler(@Nullable File[] optionalSourcePath, File[] classPath, @Nullable File[] optionalExtDirs, @Nullable File[] optionalBootClassPath, @Nullable File destinationDirectory, @Nullable String optionalCharacterEncoding, boolean verbose, boolean debugSource, boolean debugLines, boolean debugVars, StringPattern[] warningHandlePatterns, boolean rebuild) {
        this(new PathResourceFinder(optionalSourcePath == null ? classPath : optionalSourcePath), IClassLoader.createJavacLikePathIClassLoader(optionalBootClassPath, optionalExtDirs, classPath), rebuild ? ResourceFinder.EMPTY_RESOURCE_FINDER : (destinationDirectory == null ? FIND_NEXT_TO_SOURCE_FILE : new DirectoryResourceFinder(destinationDirectory)), destinationDirectory == null ? CREATE_NEXT_TO_SOURCE_FILE : new DirectoryResourceCreator(destinationDirectory), optionalCharacterEncoding, verbose, debugSource, debugLines, debugVars, new FilterWarningHandler(warningHandlePatterns, new SimpleWarningHandler()));
        this.benchmark.report("*** JANINO - an embedded compiler for the Java(TM) programming language");
        this.benchmark.report("*** For more information visit http://janino.codehaus.org");
        this.benchmark.report("Source path", optionalSourcePath);
        this.benchmark.report("Class path", classPath);
        this.benchmark.report("Ext dirs", optionalExtDirs);
        this.benchmark.report("Boot class path", optionalBootClassPath);
        this.benchmark.report("Destination directory", destinationDirectory);
        this.benchmark.report("Character encoding", optionalCharacterEncoding);
        this.benchmark.report("Verbose", new Boolean(verbose));
        this.benchmark.report("Debug source", new Boolean(debugSource));
        this.benchmark.report("Debug lines", new Boolean(debugSource));
        this.benchmark.report("Debug vars", new Boolean(debugSource));
        this.benchmark.report("Warning handle patterns", warningHandlePatterns);
        this.benchmark.report("Rebuild", new Boolean(rebuild));
    }

    public Compiler(ResourceFinder sourceFinder, IClassLoader iClassLoader, @Nullable ResourceFinder classFileFinder, @Nullable ResourceCreator classFileCreator, @Nullable String optionalCharacterEncoding, boolean verbose, boolean debugSource, boolean debugLines, boolean debugVars, @Nullable WarningHandler optionalWarningHandler) {
        this.classFileFinder = classFileFinder;
        this.classFileCreator = classFileCreator;
        this.optionalCharacterEncoding = optionalCharacterEncoding;
        this.benchmark = new Benchmark(verbose);
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
        this.optionalWarningHandler = optionalWarningHandler;
        this.iClassLoader = new CompilerIClassLoader(sourceFinder, iClassLoader);
    }

    public void setCompileErrorHandler(@Nullable ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(@Nullable WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    public boolean compile(File[] sourceFiles) throws CompileException, IOException {
        this.benchmark.report("Source files", sourceFiles);
        Resource[] sourceFileResources = new Resource[sourceFiles.length];
        for (int i = 0; i < sourceFiles.length; ++i) {
            sourceFileResources[i] = new FileResource(sourceFiles[i]);
        }
        this.compile(sourceFileResources);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(Resource[] sourceResources) throws CompileException, IOException {
        ErrorHandler ceh = this.optionalCompileErrorHandler != null ? this.optionalCompileErrorHandler : new ErrorHandler(){
            int compileErrorCount;

            public void handleError(String message, @Nullable Location optionalLocation) throws CompileException {
                CompileException ex = new CompileException(message, optionalLocation);
                if (++this.compileErrorCount >= 20) {
                    throw ex;
                }
                System.err.println(ex.getMessage());
            }
        };
        this.benchmark.beginReporting();
        try {
            this.parsedCompilationUnits.clear();
            for (Resource sourceResource : sourceResources) {
                LOGGER.log(Level.FINE, "Compiling \"{0}\"", sourceResource);
                this.parsedCompilationUnits.add(new UnitCompiler(this.parseCompilationUnit(sourceResource.getFileName(), new BufferedInputStream(sourceResource.open()), this.optionalCharacterEncoding), this.iClassLoader));
            }
            for (int i = 0; i < this.parsedCompilationUnits.size(); ++i) {
                ClassFile[] classFiles;
                UnitCompiler unitCompiler = this.parsedCompilationUnits.get(i);
                Java.CompilationUnit compilationUnit = unitCompiler.getCompilationUnit();
                if (compilationUnit.optionalFileName == null) {
                    throw new JaninoRuntimeException();
                }
                File sourceFile = new File(compilationUnit.optionalFileName);
                unitCompiler.setCompileErrorHandler(ceh);
                unitCompiler.setWarningHandler(this.optionalWarningHandler);
                this.benchmark.beginReporting("Compiling compilation unit \"" + sourceFile + "\"");
                try {
                    classFiles = unitCompiler.compileUnit(this.debugSource, this.debugLines, this.debugVars);
                }
                finally {
                    this.benchmark.endReporting();
                }
                this.benchmark.beginReporting("Storing " + classFiles.length + " class file(s) resulting from compilation unit \"" + sourceFile + "\"");
                try {
                    for (ClassFile classFile : classFiles) {
                        this.storeClassFile(classFile, sourceFile);
                    }
                    continue;
                }
                finally {
                    this.benchmark.endReporting();
                }
            }
        }
        finally {
            this.benchmark.endReporting("Compiled " + this.parsedCompilationUnits.size() + " compilation unit(s)");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Java.CompilationUnit parseCompilationUnit(String fileName, InputStream inputStream, @Nullable String optionalCharacterEncoding) throws CompileException, IOException {
        try {
            Scanner scanner = new Scanner(fileName, inputStream, optionalCharacterEncoding);
            scanner.setWarningHandler(this.optionalWarningHandler);
            Parser parser = new Parser(scanner);
            parser.setWarningHandler(this.optionalWarningHandler);
            this.benchmark.beginReporting("Parsing \"" + fileName + "\"");
            try {
                Java.CompilationUnit compilationUnit = parser.parseCompilationUnit();
                this.benchmark.endReporting();
                return compilationUnit;
            }
            catch (Throwable throwable) {
                this.benchmark.endReporting();
                throw throwable;
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static File getClassFile(String className, File sourceFile, @Nullable File optionalDestinationDirectory) {
        if (optionalDestinationDirectory != null) {
            return new File(optionalDestinationDirectory, ClassFile.getClassFileResourceName(className));
        }
        int idx = className.lastIndexOf(46);
        return new File(sourceFile.getParentFile(), ClassFile.getClassFileResourceName(className.substring(idx + 1)));
    }

    public void storeClassFile(ClassFile classFile, final File sourceFile) throws IOException {
        ResourceCreator rc;
        String classFileResourceName = ClassFile.getClassFileResourceName(classFile.getThisClassName());
        if (this.classFileCreator != CREATE_NEXT_TO_SOURCE_FILE) {
            rc = this.classFileCreator;
            assert (rc != null);
        } else {
            rc = new FileResourceCreator(){

                @Override
                protected File getFile(String resourceName) {
                    return new File(sourceFile.getParentFile(), resourceName.substring(resourceName.lastIndexOf(47) + 1));
                }
            };
        }
        OutputStream os = rc.createResource(classFileResourceName);
        try {
            classFile.store(os);
        }
        catch (IOException ioe) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            os = null;
            if (!rc.deleteResource(classFileResourceName)) {
                IOException ioe2 = new IOException("Could not delete incompletely written class file \"" + classFileResourceName + "\"");
                ioe2.initCause(ioe);
                throw ioe2;
            }
            throw ioe;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class CompilerIClassLoader
    extends IClassLoader {
        private final ResourceFinder sourceFinder;

        CompilerIClassLoader(@Nullable ResourceFinder sourceFinder, IClassLoader optionalParentIClassLoader) {
            super(optionalParentIClassLoader);
            this.sourceFinder = sourceFinder;
            super.postConstruct();
        }

        @Override
        @Nullable
        protected IClass findIClass(String type) throws ClassNotFoundException {
            Resource classFileResource;
            LOGGER.entering(null, "findIClass", type);
            String className = Descriptor.toClassName(type);
            LOGGER.log(Level.FINE, "className={0}", className);
            if (className.startsWith("java.")) {
                return null;
            }
            int idx = className.indexOf(36);
            String topLevelClassName = idx == -1 ? className : className.substring(0, idx);
            for (int i = 0; i < Compiler.this.parsedCompilationUnits.size(); ++i) {
                UnitCompiler uc = (UnitCompiler)Compiler.this.parsedCompilationUnits.get(i);
                IClass res = uc.findClass(topLevelClassName);
                if (res == null) continue;
                if (!className.equals(topLevelClassName) && (res = uc.findClass(className)) == null) {
                    return null;
                }
                this.defineIClass(res);
                return res;
            }
            Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
            if (sourceResource == null) {
                return null;
            }
            ResourceFinder cff = Compiler.this.classFileFinder;
            if (cff != FIND_NEXT_TO_SOURCE_FILE) {
                assert (cff != null);
                classFileResource = cff.findResource(ClassFile.getClassFileResourceName(className));
            } else {
                if (!(sourceResource instanceof FileResource)) {
                    return null;
                }
                File classFile = new File(((FileResource)sourceResource).getFile().getParentFile(), ClassFile.getClassFileResourceName(className.substring(className.lastIndexOf(46) + 1)));
                Resource resource = classFileResource = classFile.exists() ? new FileResource(classFile) : null;
            }
            if (classFileResource != null && sourceResource.lastModified() <= classFileResource.lastModified()) {
                return this.defineIClassFromClassFileResource(classFileResource);
            }
            return this.defineIClassFromSourceResource(sourceResource, className);
        }

        private IClass defineIClassFromSourceResource(Resource sourceResource, String className) throws ClassNotFoundException {
            UnitCompiler uc;
            try {
                Java.CompilationUnit cu = Compiler.this.parseCompilationUnit(sourceResource.getFileName(), new BufferedInputStream(sourceResource.open()), Compiler.this.optionalCharacterEncoding);
                uc = new UnitCompiler(cu, Compiler.this.iClassLoader);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            catch (CompileException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            Compiler.this.parsedCompilationUnits.add(uc);
            IClass res = uc.findClass(className);
            if (res == null) {
                throw new ClassNotFoundException("\"" + sourceResource + "\" does not declare \"" + className + "\"");
            }
            this.defineIClass(res);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IClass defineIClassFromClassFileResource(Resource classFileResource) throws ClassNotFoundException {
            Compiler.this.benchmark.beginReporting("Loading class file \"" + classFileResource.getFileName() + "\"");
            try {
                ClassFile cf;
                InputStream is = null;
                try {
                    is = classFileResource.open();
                    cf = new ClassFile(new BufferedInputStream(is));
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Opening class file resource \"" + classFileResource + "\"", ex);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ClassFileIClass result = new ClassFileIClass(cf, this);
                this.defineIClass(result);
                result.resolveAllClasses();
                ClassFileIClass classFileIClass = result;
                return classFileIClass;
            }
            finally {
                Compiler.this.benchmark.endReporting();
            }
        }
    }

    public static class SimpleWarningHandler
    implements WarningHandler {
        public void handleWarning(@Nullable String handle, String message, @Nullable Location optionalLocation) {
            StringBuilder sb = new StringBuilder();
            if (optionalLocation != null) {
                sb.append(optionalLocation).append(": ");
            }
            if (handle == null) {
                sb.append("Warning: ");
            } else {
                sb.append("Warning ").append(handle).append(": ");
            }
            sb.append(message);
            System.err.println(sb.toString());
        }
    }
}

