/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.metamodel.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.StubMethod;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.hibernate.Version;
import org.hibernate.bytecode.enhance.VersionMismatchException;
import org.hibernate.bytecode.enhance.internal.bytebuddy.ByteBuddyEnhancementContext;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CodeTemplates;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerClassLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImplConstants;
import org.hibernate.bytecode.enhance.internal.bytebuddy.ModelTypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.PersistentAttributeTransformer;
import org.hibernate.bytecode.enhance.internal.tracker.CompositeOwnerTracker;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.Managed;
import org.hibernate.engine.spi.ManagedComposite;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.ManagedMappedSuperclass;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class EnhancerImpl
implements Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Enhancer.class);
    protected final ByteBuddyEnhancementContext enhancementContext;
    private final ByteBuddyState byteBuddyState;
    private final EnhancerClassLocator typePool;
    private final EnhancerImplConstants constants;

    public EnhancerImpl(EnhancementContext enhancementContext, ByteBuddyState byteBuddyState) {
        this(enhancementContext, byteBuddyState, ModelTypePool.buildModelTypePool(enhancementContext.getLoadingClassLoader()));
    }

    public EnhancerImpl(EnhancementContext enhancementContext, ByteBuddyState byteBuddyState, EnhancerClassLocator classLocator) {
        this.enhancementContext = new ByteBuddyEnhancementContext(enhancementContext);
        this.byteBuddyState = Objects.requireNonNull(byteBuddyState);
        this.typePool = Objects.requireNonNull(classLocator);
        this.constants = byteBuddyState.getEnhancerConstants();
    }

    @Override
    public byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        String safeClassName = className.replace('/', '.');
        this.typePool.registerClassNameAndBytes(safeClassName, originalBytes);
        try {
            TypeDescription typeDescription = this.typePool.describe(safeClassName).resolve();
            byte[] byArray = this.byteBuddyState.rewrite(this.typePool, safeClassName, byteBuddy -> this.doEnhance(() -> byteBuddy.ignore((ElementMatcher)ElementMatchers.isDefaultFinalizer()).redefine(typeDescription, this.typePool.asClassFileLocator()).annotateType(this.constants.HIBERNATE_VERSION_ANNOTATION), typeDescription));
            return byArray;
        }
        catch (EnhancementException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new EnhancementException("Failed to enhance class " + className, e);
        }
        finally {
            this.typePool.deregisterClassNameAndBytes(safeClassName);
        }
    }

    @Override
    public void discoverTypes(String className, byte[] originalBytes) {
        if (originalBytes != null) {
            this.typePool.registerClassNameAndBytes(className, originalBytes);
        }
        try {
            TypeDescription typeDescription = this.typePool.describe(className).resolve();
            this.enhancementContext.registerDiscoveredType(typeDescription, Type.PersistenceType.ENTITY);
            this.enhancementContext.discoverCompositeTypes(typeDescription, this.typePool);
        }
        catch (RuntimeException e) {
            throw new EnhancementException("Failed to discover types for class " + className, e);
        }
        finally {
            this.typePool.deregisterClassNameAndBytes(className);
        }
    }

    private DynamicType.Builder<?> doEnhance(Supplier<DynamicType.Builder<?>> builderSupplier, TypeDescription managedCtClass) {
        if (managedCtClass.isInterface()) {
            log.debugf("Skipping enhancement of [%s]: it's an interface", managedCtClass.getName());
            return null;
        }
        if (managedCtClass.isRecord()) {
            log.debugf("Skipping enhancement of [%s]: it's a record", managedCtClass.getName());
            return null;
        }
        if (this.alreadyEnhanced(managedCtClass)) {
            EnhancerImpl.verifyVersions(managedCtClass, this.enhancementContext);
            log.debugf("Skipping enhancement of [%s]: already enhanced", managedCtClass.getName());
            return null;
        }
        if (this.enhancementContext.isEntityClass(managedCtClass)) {
            if (this.hasUnsupportedAttributeNaming(managedCtClass)) {
                return null;
            }
            log.debugf("Enhancing [%s] as Entity", managedCtClass.getName());
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = builderSupplier.get();
            builder = builder.implement(new Type[]{ManagedEntity.class}).defineMethod("$$_hibernate_getEntityInstance", this.constants.TypeObject, this.constants.methodModifierPUBLIC).intercept((Implementation)FixedValue.self());
            builder = this.addFieldWithGetterAndSetter((DynamicType.Builder<?>)builder, this.constants.TypeEntityEntry, "$$_hibernate_entityEntryHolder", "$$_hibernate_getEntityEntry", "$$_hibernate_setEntityEntry");
            builder = this.addFieldWithGetterAndSetter((DynamicType.Builder<?>)builder, this.constants.TypeManagedEntity, "$$_hibernate_previousManagedEntity", "$$_hibernate_getPreviousManagedEntity", "$$_hibernate_setPreviousManagedEntity");
            builder = this.addFieldWithGetterAndSetter((DynamicType.Builder<?>)builder, this.constants.TypeManagedEntity, "$$_hibernate_nextManagedEntity", "$$_hibernate_getNextManagedEntity", "$$_hibernate_setNextManagedEntity");
            builder = this.addFieldWithGetterAndSetter((DynamicType.Builder<?>)builder, this.constants.TypeBooleanPrimitive, "$$_hibernate_useTracker", "$$_hibernate_useTracker", "$$_hibernate_setUseTracker");
            builder = this.addInterceptorHandling((DynamicType.Builder<?>)builder, managedCtClass);
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                List<AnnotatedFieldDescription> collectionFields = this.collectCollectionFields(managedCtClass);
                if (collectionFields.isEmpty()) {
                    builder = builder.implement(new Type[]{SelfDirtinessTracker.class}).defineField("$$_hibernate_tracker", DirtyTracker.class, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod("$$_hibernate_trackChange", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class}).intercept(this.constants.implementationTrackChange).defineMethod("$$_hibernate_getDirtyAttributes", this.constants.Type_Array_String, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationGetDirtyAttributesWithoutCollections).defineMethod("$$_hibernate_hasDirtyAttributes", this.constants.TypeBooleanPrimitive, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationAreFieldsDirtyWithoutCollections).defineMethod("$$_hibernate_clearDirtyAttributes", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationClearDirtyAttributesWithoutCollections).defineMethod("$$_hibernate_suspendDirtyTracking", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new TypeDefinition[]{this.constants.TypeBooleanPrimitive}).intercept(this.constants.implementationSuspendDirtyTracking).defineMethod("$$_hibernate_getCollectionTracker", this.constants.TypeCollectionTracker, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationGetCollectionTrackerWithoutCollections);
                } else {
                    builder = builder.implement(new Type[]{ExtendedSelfDirtinessTracker.class}).defineField("$$_hibernate_tracker", DirtyTracker.class, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineField("$$_hibernate_collectionTracker", this.constants.TypeCollectionTracker, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod("$$_hibernate_trackChange", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class}).intercept(this.constants.implementationTrackChange).defineMethod("$$_hibernate_getDirtyAttributes", this.constants.Type_Array_String, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationGetDirtyAttributes).defineMethod("$$_hibernate_hasDirtyAttributes", this.constants.TypeBooleanPrimitive, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationAreFieldsDirty).defineMethod("$$_hibernate_clearDirtyAttributes", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationClearDirtyAttributes).defineMethod("$$_hibernate_suspendDirtyTracking", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new TypeDefinition[]{this.constants.TypeBooleanPrimitive}).intercept(this.constants.implementationSuspendDirtyTracking).defineMethod("$$_hibernate_getCollectionTracker", this.constants.TypeCollectionTracker, this.constants.methodModifierPUBLIC).intercept((Implementation)FieldAccessor.ofField((String)"$$_hibernate_collectionTracker"));
                    StubMethod isDirty = StubMethod.INSTANCE;
                    StubMethod getDirtyNames = StubMethod.INSTANCE;
                    StubMethod clearDirtyNames = StubMethod.INSTANCE;
                    for (AnnotatedFieldDescription collectionField : collectionFields) {
                        Class adviceClearDirtyNames;
                        Class adviceGetDirtyNames;
                        Class adviceIsDirty;
                        String collectionFieldName = collectionField.getName();
                        if (collectionField.getType().asErasure().isAssignableTo(Map.class)) {
                            adviceIsDirty = CodeTemplates.MapAreCollectionFieldsDirty.class;
                            adviceGetDirtyNames = CodeTemplates.MapGetCollectionFieldDirtyNames.class;
                            adviceClearDirtyNames = CodeTemplates.MapGetCollectionClearDirtyNames.class;
                        } else {
                            adviceIsDirty = CodeTemplates.CollectionAreCollectionFieldsDirty.class;
                            adviceGetDirtyNames = CodeTemplates.CollectionGetCollectionFieldDirtyNames.class;
                            adviceClearDirtyNames = CodeTemplates.CollectionGetCollectionClearDirtyNames.class;
                        }
                        if (collectionField.isVisibleTo(managedCtClass)) {
                            FieldDescription fieldDescription = collectionField.getFieldDescription();
                            isDirty = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, fieldDescription).to(adviceIsDirty, this.constants.adviceLocator).wrap((Implementation)isDirty);
                            getDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, fieldDescription).to(adviceGetDirtyNames, this.constants.adviceLocator).wrap((Implementation)getDirtyNames);
                            clearDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, fieldDescription).to(adviceClearDirtyNames, this.constants.adviceLocator).wrap((Implementation)clearDirtyNames);
                            continue;
                        }
                        CodeTemplates.GetterMapping getterMapping = new CodeTemplates.GetterMapping(collectionField.getFieldDescription());
                        isDirty = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, (Advice.OffsetMapping)getterMapping).to(adviceIsDirty, this.constants.adviceLocator).wrap((Implementation)isDirty);
                        getDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, (Advice.OffsetMapping)getterMapping).to(adviceGetDirtyNames, this.constants.adviceLocator).wrap((Implementation)getDirtyNames);
                        clearDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, (Advice.OffsetMapping)getterMapping).to(adviceClearDirtyNames, this.constants.adviceLocator).wrap((Implementation)clearDirtyNames);
                    }
                    if (this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
                        clearDirtyNames = this.constants.adviceInitializeLazyAttributeLoadingInterceptor.wrap((Implementation)clearDirtyNames);
                    }
                    builder = builder.defineMethod("$$_hibernate_areCollectionFieldsDirty", this.constants.TypeBooleanPrimitive, this.constants.methodModifierPUBLIC).intercept((Implementation)isDirty).defineMethod("$$_hibernate_getCollectionFieldDirtyNames", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{DirtyTracker.class}).intercept((Implementation)getDirtyNames).defineMethod("$$_hibernate_clearDirtyCollectionNames", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).intercept(Advice.withCustomMapping().to(CodeTemplates.ClearDirtyCollectionNames.class, this.constants.adviceLocator).wrap((Implementation)StubMethod.INSTANCE)).defineMethod("$$_hibernate_removeDirtyFields", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{LazyAttributeLoadingInterceptor.class}).intercept((Implementation)clearDirtyNames);
                }
            }
            return this.createTransformer(managedCtClass).applyTo((DynamicType.Builder<?>)builder);
        }
        if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            if (this.hasUnsupportedAttributeNaming(managedCtClass)) {
                return null;
            }
            log.debugf("Enhancing [%s] as Composite", managedCtClass.getName());
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = builderSupplier.get();
            builder = builder.implement(new Type[]{ManagedComposite.class});
            builder = this.addInterceptorHandling((DynamicType.Builder<?>)builder, managedCtClass);
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                builder = builder.implement(new Type[]{CompositeTracker.class}).defineField("$$_hibernate_compositeOwners", CompositeOwnerTracker.class, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod("$$_hibernate_setOwner", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class, CompositeOwner.class}).intercept(this.constants.implementationSetOwner).defineMethod("$$_hibernate_clearOwner", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class}).intercept(this.constants.implementationClearOwner);
            }
            return this.createTransformer(managedCtClass).applyTo((DynamicType.Builder<?>)builder);
        }
        if (this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            if (this.hasUnsupportedAttributeNaming(managedCtClass)) {
                return null;
            }
            log.debugf("Enhancing [%s] as MappedSuperclass", managedCtClass.getName());
            DynamicType.Builder.MethodDefinition.ImplementationDefinition.Optional builder = builderSupplier.get();
            builder = builder.implement(new Type[]{ManagedMappedSuperclass.class});
            return this.createTransformer(managedCtClass).applyTo((DynamicType.Builder<?>)builder);
        }
        if (this.enhancementContext.doExtendedEnhancement(managedCtClass)) {
            log.debugf("Extended enhancement of [%s]", managedCtClass.getName());
            return this.createTransformer(managedCtClass).applyExtended(builderSupplier.get());
        }
        log.debugf("Skipping enhancement of [%s]: not entity or composite", managedCtClass.getName());
        return null;
    }

    private boolean hasUnsupportedAttributeNaming(TypeDescription managedCtClass) {
        boolean propertyHasAnnotation = false;
        MethodGraph.Linked methodGraph = MethodGraph.Compiler.Default.forJavaHierarchy().compile((TypeDefinition)managedCtClass);
        for (MethodGraph.Node node : methodGraph.listNodes()) {
            Object methodFieldName;
            String methodName;
            MethodDescription methodDescription = node.getRepresentative();
            if (methodDescription.getDeclaringType().represents(Object.class) || (methodName = methodDescription.getActualName()).equals("") || !methodName.startsWith("get") && !methodName.startsWith("set") && !methodName.startsWith("is")) continue;
            if (methodName.startsWith("is")) {
                methodFieldName = methodName.substring(2);
            } else {
                if (!methodName.startsWith("get") && !methodName.startsWith("set")) continue;
                methodFieldName = methodName.substring(3);
            }
            boolean propertyNameMatchesFieldName = false;
            methodFieldName = ((String)methodFieldName).substring(0, 1).toLowerCase() + ((String)methodFieldName).substring(1);
            TypeList typeList = methodDescription.getDeclaredAnnotations().asTypeList();
            if (typeList.stream().anyMatch(typeDefinitions -> typeDefinitions.getName().contains("jakarta.persistence"))) {
                propertyHasAnnotation = true;
            }
            for (FieldDescription ctField : methodDescription.getDeclaringType().getDeclaredFields()) {
                if (Modifier.isStatic(ctField.getModifiers())) continue;
                AnnotatedFieldDescription annotatedField = new AnnotatedFieldDescription(this.enhancementContext, ctField);
                boolean containsPropertyAccessorMethods = false;
                if (!this.enhancementContext.isPersistentField(annotatedField) || !((String)methodFieldName).equals(ctField.getActualName())) continue;
                propertyNameMatchesFieldName = true;
                break;
            }
            if (!propertyHasAnnotation || propertyNameMatchesFieldName) continue;
            log.debugf("Skipping enhancement of [%s]: due to class [%s] not having a property accessor method name matching field name [%s]", managedCtClass, methodDescription.getDeclaringType().getActualName(), methodFieldName);
            return true;
        }
        return false;
    }

    private static void verifyVersions(TypeDescription managedCtClass, ByteBuddyEnhancementContext enhancementContext) {
        AnnotationDescription.Loadable existingInfo = managedCtClass.getDeclaredAnnotations().ofType(EnhancementInfo.class);
        if (existingInfo == null) {
            return;
        }
        String enhancementVersion = EnhancerImpl.extractVersion((AnnotationDescription.Loadable<EnhancementInfo>)existingInfo);
        if (!Version.getVersionString().equals(enhancementVersion)) {
            throw new VersionMismatchException(managedCtClass, enhancementVersion, Version.getVersionString());
        }
    }

    private static String extractVersion(AnnotationDescription.Loadable<EnhancementInfo> annotation) {
        return ((EnhancementInfo)annotation.load()).version();
    }

    private PersistentAttributeTransformer createTransformer(TypeDescription typeDescription) {
        return PersistentAttributeTransformer.collectPersistentFields(typeDescription, this.enhancementContext, this.typePool);
    }

    private boolean alreadyEnhanced(TypeDescription managedCtClass) {
        for (TypeDescription.Generic declaredInterface : managedCtClass.getInterfaces()) {
            if (!declaredInterface.asErasure().isAssignableTo(Managed.class)) continue;
            return true;
        }
        return false;
    }

    private DynamicType.Builder<?> addInterceptorHandling(DynamicType.Builder<?> builder, TypeDescription managedCtClass) {
        if (this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            log.debugf("Weaving in PersistentAttributeInterceptable implementation on [%s]", managedCtClass.getName());
            builder = builder.implement(new Type[]{PersistentAttributeInterceptable.class});
            builder = this.addFieldWithGetterAndSetter(builder, this.constants.TypePersistentAttributeInterceptor, "$$_hibernate_attributeInterceptor", "$$_hibernate_getInterceptor", "$$_hibernate_setInterceptor");
        }
        return builder;
    }

    private DynamicType.Builder<?> addFieldWithGetterAndSetter(DynamicType.Builder<?> builder, TypeDefinition type, String fieldName, String getterName, String setterName) {
        return builder.defineField(fieldName, type, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod(getterName, type, this.constants.methodModifierPUBLIC).intercept((Implementation)FieldAccessor.ofField((String)fieldName)).defineMethod(setterName, this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new TypeDefinition[]{type}).intercept((Implementation)FieldAccessor.ofField((String)fieldName));
    }

    private List<AnnotatedFieldDescription> collectCollectionFields(TypeDescription managedCtClass) {
        ArrayList<AnnotatedFieldDescription> collectionList = new ArrayList<AnnotatedFieldDescription>();
        for (FieldDescription ctField : managedCtClass.getDeclaredFields()) {
            AnnotatedFieldDescription annotatedField;
            if (Modifier.isStatic(ctField.getModifiers()) || ctField.getName().startsWith("$$_hibernate_") || !this.enhancementContext.isPersistentField(annotatedField = new AnnotatedFieldDescription(this.enhancementContext, ctField)) || !this.enhancementContext.isMappedCollection(annotatedField) || !ctField.getType().asErasure().isAssignableTo(Collection.class) && !ctField.getType().asErasure().isAssignableTo(Map.class)) continue;
            collectionList.add(annotatedField);
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            collectionList.addAll(this.collectInheritCollectionFields((TypeDefinition)managedCtClass));
        }
        return collectionList;
    }

    private Collection<AnnotatedFieldDescription> collectInheritCollectionFields(TypeDefinition managedCtClass) {
        TypeDescription.Generic managedCtSuperclass = managedCtClass.getSuperClass();
        if (managedCtSuperclass == null || managedCtSuperclass.represents(Object.class)) {
            return Collections.emptyList();
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtSuperclass.asErasure())) {
            return this.collectInheritCollectionFields((TypeDefinition)managedCtSuperclass.asErasure());
        }
        ArrayList<AnnotatedFieldDescription> collectionList = new ArrayList<AnnotatedFieldDescription>();
        for (FieldDescription ctField : managedCtSuperclass.getDeclaredFields()) {
            AnnotatedFieldDescription annotatedField;
            if (Modifier.isStatic(ctField.getModifiers()) || !this.enhancementContext.isPersistentField(annotatedField = new AnnotatedFieldDescription(this.enhancementContext, ctField)) || !this.enhancementContext.isMappedCollection(annotatedField) || !ctField.getType().asErasure().isAssignableTo(Collection.class) && !ctField.getType().asErasure().isAssignableTo(Map.class)) continue;
            collectionList.add(annotatedField);
        }
        collectionList.addAll(this.collectInheritCollectionFields((TypeDefinition)managedCtSuperclass));
        return collectionList;
    }

    static String capitalize(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    static class AnnotatedFieldDescription
    implements UnloadedField {
        private final ByteBuddyEnhancementContext context;
        private final FieldDescription fieldDescription;
        private AnnotationList annotations;
        private Optional<MethodDescription> getter;

        AnnotatedFieldDescription(ByteBuddyEnhancementContext context, FieldDescription fieldDescription) {
            this.context = context;
            this.fieldDescription = fieldDescription;
        }

        @Override
        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return this.getAnnotations().isAnnotationPresent(annotationType);
        }

        public String toString() {
            return this.fieldDescription.toString();
        }

        <T extends Annotation> AnnotationDescription.Loadable<T> getAnnotation(Class<T> annotationType) {
            return this.getAnnotations().ofType(annotationType);
        }

        String getName() {
            return this.fieldDescription.getName();
        }

        TypeDefinition getDeclaringType() {
            return this.fieldDescription.getDeclaringType();
        }

        TypeDescription.Generic getType() {
            return this.fieldDescription.getType();
        }

        FieldDescription.InDefinedShape asDefined() {
            return (FieldDescription.InDefinedShape)this.fieldDescription.asDefined();
        }

        String getDescriptor() {
            return this.fieldDescription.getDescriptor();
        }

        boolean isVisibleTo(TypeDescription typeDescription) {
            return this.fieldDescription.isVisibleTo(typeDescription);
        }

        FieldDescription getFieldDescription() {
            return this.fieldDescription;
        }

        Optional<MethodDescription> getGetter() {
            if (this.getter == null) {
                this.getter = this.context.resolveGetter(this.fieldDescription);
            }
            return this.getter;
        }

        private AnnotationList getAnnotations() {
            if (this.annotations == null) {
                this.annotations = this.doGetAnnotations();
            }
            return this.annotations;
        }

        private AnnotationList doGetAnnotations() {
            AnnotationDescription.Loadable access = this.fieldDescription.getDeclaringType().asErasure().getDeclaredAnnotations().ofType(Access.class);
            if (access != null && ((Access)access.load()).value() == AccessType.PROPERTY) {
                Optional<MethodDescription> getter = this.getGetter();
                if (getter.isPresent()) {
                    return getter.get().getDeclaredAnnotations();
                }
                return this.fieldDescription.getDeclaredAnnotations();
            }
            if (access != null && ((Access)access.load()).value() == AccessType.FIELD) {
                return this.fieldDescription.getDeclaredAnnotations();
            }
            Optional<MethodDescription> getter = this.getGetter();
            ArrayList annotationDescriptions = new ArrayList();
            if (getter.isPresent()) {
                annotationDescriptions.addAll(getter.get().getDeclaredAnnotations());
            }
            annotationDescriptions.addAll(this.fieldDescription.getDeclaredAnnotations());
            return new AnnotationList.Explicit(annotationDescriptions);
        }
    }
}

