/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="cacheCredentialsMetaDataPopulator")
public final class CacheCredentialsMetaDataPopulator
implements AuthenticationMetaDataPopulator {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public void populateAttributes(AuthenticationBuilder builder, Credential credential) {
        this.logger.debug("Processing request to capture the credential for [{}]", (Object)credential.getId());
        UsernamePasswordCredential c = (UsernamePasswordCredential)credential;
        builder.addAttribute("credential", (Object)c.getPassword());
        this.logger.debug("Encrypted credential is added as the authentication attribute [{}] to the authentication", (Object)"credential");
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }
}

