/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.net.URL;
import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.AbstractAuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.util.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proxyAuthenticationHandler")
public final class HttpBasedServiceCredentialsAuthenticationHandler
extends AbstractAuthenticationHandler {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    @Autowired
    @Qualifier(value="supportsTrustStoreSslSocketFactoryHttpClient")
    private HttpClient httpClient;

    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException {
        HttpBasedServiceCredential httpCredential = (HttpBasedServiceCredential)credential;
        if (!httpCredential.getService().getProxyPolicy().isAllowedProxyCallbackUrl(httpCredential.getCallbackUrl())) {
            this.logger.warn("Proxy policy for service [{}] cannot authorize the requested callback url [{}].", (Object)httpCredential.getService().getServiceId(), (Object)httpCredential.getCallbackUrl());
            throw new FailedLoginException(httpCredential.getCallbackUrl() + " cannot be authorized");
        }
        this.logger.debug("Attempting to authenticate {}", (Object)httpCredential);
        URL callbackUrl = httpCredential.getCallbackUrl();
        if (!this.httpClient.isValidEndPoint(callbackUrl)) {
            throw new FailedLoginException(String.valueOf(callbackUrl.toExternalForm()) + " sent an unacceptable response status code");
        }
        return new DefaultHandlerResult((AuthenticationHandler)this, (CredentialMetaData)httpCredential, this.principalFactory.createPrincipal(httpCredential.getId()));
    }

    public boolean supports(Credential credential) {
        return credential instanceof HttpBasedServiceCredential;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

