/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="jaasAuthenticationHandler")
public class JaasAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_REALM = "CAS";
    private static final String SYS_PROP_KRB5_REALM = "java.security.krb5.realm";
    private static final String SYS_PROP_KERB5_KDC = "java.security.krb5.kdc";
    @NotNull
    private String realm = "CAS";
    private String kerberosRealmSystemProperty;
    private String kerberosKdcSystemProperty;

    public JaasAuthenticationHandler() {
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"Static Configuration cannot be null. Did you remember to specify \"java.security.auth.login.config\"?");
    }

    @Override
    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        if (this.kerberosKdcSystemProperty != null) {
            this.logger.debug("Setting kerberos system property {} to {}", (Object)SYS_PROP_KERB5_KDC, (Object)this.kerberosKdcSystemProperty);
            System.setProperty(SYS_PROP_KERB5_KDC, this.kerberosKdcSystemProperty);
        }
        if (this.kerberosRealmSystemProperty != null) {
            this.logger.debug("Setting kerberos system property {} to {}", (Object)SYS_PROP_KRB5_REALM, (Object)this.kerberosRealmSystemProperty);
            System.setProperty(SYS_PROP_KRB5_REALM, this.kerberosRealmSystemProperty);
        }
        String username = credential.getUsername();
        String password = this.getPasswordEncoder().encode(credential.getPassword());
        LoginContext lc = new LoginContext(this.realm, new UsernamePasswordCallbackHandler(username, password));
        try {
            this.logger.debug("Attempting authentication for: {}", (Object)username);
            lc.login();
        }
        finally {
            lc.logout();
        }
        org.jasig.cas.authentication.principal.Principal principal = null;
        Set<Principal> principals = lc.getSubject().getPrincipals();
        if (principals != null && !principals.isEmpty()) {
            Principal secPrincipal = principals.iterator().next();
            principal = this.principalFactory.createPrincipal(secPrincipal.getName());
        }
        return this.createHandlerResult(credential, principal, null);
    }

    @Autowired
    public void setRealm(@Value(value="${cas.authn.jaas.realm:CAS}") String realm) {
        this.realm = realm;
    }

    @Autowired
    public final void setKerberosRealmSystemProperty(@Value(value="${cas.authn.jaas.kerb.realm:}") String kerberosRealmSystemProperty) {
        this.kerberosRealmSystemProperty = kerberosRealmSystemProperty;
    }

    @Autowired
    public final void setKerberosKdcSystemProperty(@Value(value="${cas.authn.jaas.kerb.kdc:}") String kerberosKdcSystemProperty) {
        this.kerberosKdcSystemProperty = kerberosKdcSystemProperty;
    }

    protected static final class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String password;

        protected UsernamePasswordCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                if (callback.getClass().equals(NameCallback.class)) {
                    ((NameCallback)callback).setName(this.userName);
                } else if (callback.getClass().equals(PasswordCallback.class)) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                } else {
                    throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
                }
                ++n2;
            }
        }
    }
}

