/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="defaultPasswordPolicyConfiguration")
public class PasswordPolicyConfiguration {
    private static final int DEFAULT_PASSWORD_WARNING_NUMBER_OF_DAYS = 30;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean alwaysDisplayPasswordExpirationWarning;
    private int passwordWarningNumberOfDays = 30;
    private String passwordPolicyUrl;

    public boolean isAlwaysDisplayPasswordExpirationWarning() {
        return this.alwaysDisplayPasswordExpirationWarning;
    }

    @Autowired
    public void setAlwaysDisplayPasswordExpirationWarning(@Value(value="${password.policy.warnAll:false}") boolean alwaysDisplayPasswordExpirationWarning) {
        this.alwaysDisplayPasswordExpirationWarning = alwaysDisplayPasswordExpirationWarning;
    }

    public String getPasswordPolicyUrl() {
        return this.passwordPolicyUrl;
    }

    @Autowired
    public void setPasswordPolicyUrl(@Value(value="${password.policy.url:https://password.example.edu/change}") String passwordPolicyUrl) {
        this.passwordPolicyUrl = passwordPolicyUrl;
    }

    public int getPasswordWarningNumberOfDays() {
        return this.passwordWarningNumberOfDays;
    }

    @Autowired
    public void setPasswordWarningNumberOfDays(@Value(value="${password.policy.warningDays:30}") int days) {
        this.passwordWarningNumberOfDays = days;
    }
}

