/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Description;
import org.jmock.api.Action;
import org.jmock.api.ExpectationError;
import org.jmock.api.Invocation;

public class ActionSequence
implements Action {
    List<Action> actions;
    Iterator<Action> iterator;

    public ActionSequence(Action ... actions) {
        this.actions = new ArrayList<Action>(Arrays.asList(actions));
        this.iterator = this.actions.iterator();
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        if (this.iterator.hasNext()) {
            return this.iterator.next().invoke(invocation);
        }
        throw ExpectationError.unexpected("no more actions available", invocation);
    }

    public void describeTo(Description description) {
        description.appendList("", ", and then ", "", this.actions);
    }
}

