/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.jmock.api.Expectation;
import org.jmock.api.ExpectationError;
import org.jmock.api.Invocation;
import org.jmock.api.InvocationDispatcher;
import org.jmock.internal.StateMachine;

public class UnsynchronisedInvocationDispatcher
implements InvocationDispatcher {
    private final Collection<Expectation> expectations;
    private final Collection<StateMachine> stateMachines;

    public UnsynchronisedInvocationDispatcher() {
        this.expectations = new ArrayList<Expectation>();
        this.stateMachines = new ArrayList<StateMachine>();
    }

    public UnsynchronisedInvocationDispatcher(Collection<Expectation> theExpectations, Collection<StateMachine> theStateMachines) {
        this.expectations = theExpectations;
        this.stateMachines = theStateMachines;
    }

    @Override
    public StateMachine newStateMachine(String name) {
        StateMachine stateMachine = new StateMachine(name);
        this.stateMachines.add(stateMachine);
        return stateMachine;
    }

    @Override
    public void add(Expectation expectation) {
        this.expectations.add(expectation);
    }

    @Override
    public void describeTo(Description description) {
        this.describe(description, this.expectations);
    }

    @Override
    public void describeMismatch(Invocation invocation, Description description) {
        this.describe(description, this.describedWith(this.expectations, invocation));
    }

    private Iterable<SelfDescribing> describedWith(Iterable<Expectation> expectations, final Invocation invocation) {
        final Iterator<Expectation> iterator = expectations.iterator();
        return new Iterable<SelfDescribing>(){

            @Override
            public Iterator<SelfDescribing> iterator() {
                return new Iterator<SelfDescribing>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public SelfDescribing next() {
                        return new SelfDescribing(){

                            public void describeTo(Description description) {
                                ((Expectation)iterator.next()).describeMismatch(invocation, description);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    private void describe(Description description, Iterable<? extends SelfDescribing> selfDescribingExpectations) {
        if (this.expectations.isEmpty()) {
            description.appendText("no expectations specified: did you...\n - forget to start an expectation with a cardinality clause?\n - call a mocked method to specify the parameter of an expectation?");
        } else {
            description.appendList("expectations:\n  ", "\n  ", "", selfDescribingExpectations);
            if (!this.stateMachines.isEmpty()) {
                description.appendList("\nstates:\n  ", "\n  ", "", this.stateMachines);
            }
        }
    }

    @Override
    public boolean isSatisfied() {
        for (Expectation expectation : this.expectations) {
            if (expectation.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object dispatch(Invocation invocation) throws Throwable {
        for (Expectation expectation : this.expectations) {
            if (!expectation.matches(invocation)) continue;
            return expectation.invoke(invocation);
        }
        throw ExpectationError.unexpected("unexpected invocation", invocation);
    }
}

