/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.argumentMatching.AlwaysTrueMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.CaptureMatcher;
import mockit.internal.expectations.argumentMatching.ClassMatcher;
import mockit.internal.expectations.argumentMatching.HamcrestAdapter;
import mockit.internal.expectations.argumentMatching.InequalityMatcher;
import mockit.internal.expectations.argumentMatching.LenientEqualityMatcher;
import mockit.internal.expectations.argumentMatching.NonNullityMatcher;
import mockit.internal.expectations.argumentMatching.NullityMatcher;
import mockit.internal.expectations.argumentMatching.NumericEqualityMatcher;
import mockit.internal.expectations.argumentMatching.PatternMatcher;
import mockit.internal.expectations.argumentMatching.ReflectiveMatcher;
import mockit.internal.expectations.argumentMatching.SamenessMatcher;
import mockit.internal.expectations.argumentMatching.StringContainmentMatcher;
import mockit.internal.expectations.argumentMatching.StringPrefixMatcher;
import mockit.internal.expectations.argumentMatching.StringSuffixMatcher;
import mockit.internal.startup.Startup;
import mockit.internal.util.DefaultValues;
import org.hamcrest.Matcher;

abstract class Invocations {
    protected final Object any = null;
    protected final String anyString = new String();
    protected final Long anyLong = 0L;
    protected final Integer anyInt = 0;
    protected final Short anyShort = 0;
    protected final Byte anyByte = 0;
    protected final Boolean anyBoolean = false;
    protected final Character anyChar = Character.valueOf('\u0000');
    protected final Double anyDouble = 0.0;
    protected final Float anyFloat = Float.valueOf(0.0f);
    protected int times;
    protected int minTimes;
    protected int maxTimes;

    Invocations() {
    }

    @Nullable
    abstract TestOnlyPhase getCurrentPhase();

    protected final <T> T withArgThat(Matcher<? super T> argumentMatcher) {
        HamcrestAdapter matcher = new HamcrestAdapter(argumentMatcher);
        this.addMatcher(matcher);
        Object argValue = matcher.getInnerValue();
        return (T)argValue;
    }

    protected final <T> T with(Delegate<? super T> objectWithDelegateMethod) {
        Class<?> delegateClass = objectWithDelegateMethod.getClass();
        Type[] genericInterfaces = delegateClass.getGenericInterfaces();
        while (genericInterfaces.length == 0) {
            delegateClass = delegateClass.getSuperclass();
            genericInterfaces = delegateClass.getGenericInterfaces();
        }
        if (!(genericInterfaces[0] instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Delegate class lacks the parameter type");
        }
        ParameterizedType type = (ParameterizedType)genericInterfaces[0];
        Type parameterType = type.getActualTypeArguments()[0];
        this.addMatcher(new ReflectiveMatcher(objectWithDelegateMethod));
        return DefaultValues.computeForWrapperType(parameterType);
    }

    private void addMatcher(@Nonnull ArgumentMatcher<?> matcher) {
        TestOnlyPhase currentPhase = this.getCurrentPhase();
        if (currentPhase != null) {
            currentPhase.addArgMatcher(matcher);
        }
    }

    protected final <T> T withAny(T arg) {
        ArgumentMatcher<?> matcher = arg instanceof String ? AlwaysTrueMatcher.ANY_STRING : (arg instanceof Integer ? AlwaysTrueMatcher.ANY_INT : (arg instanceof Boolean ? AlwaysTrueMatcher.ANY_BOOLEAN : (arg instanceof Character ? AlwaysTrueMatcher.ANY_CHAR : (arg instanceof Double ? AlwaysTrueMatcher.ANY_DOUBLE : (arg instanceof Float ? AlwaysTrueMatcher.ANY_FLOAT : (arg instanceof Long ? AlwaysTrueMatcher.ANY_LONG : (arg instanceof Byte ? AlwaysTrueMatcher.ANY_BYTE : (arg instanceof Short ? AlwaysTrueMatcher.ANY_SHORT : AlwaysTrueMatcher.ANY_VALUE))))))));
        this.addMatcher(matcher);
        return arg;
    }

    protected final <T> T withCapture(List<T> valueHolderForMultipleInvocations) {
        this.addMatcher(new CaptureMatcher<T>(valueHolderForMultipleInvocations));
        return null;
    }

    protected final <T> T withEqual(T arg) {
        TestOnlyPhase currentPhase = this.getCurrentPhase();
        if (currentPhase != null) {
            Map<Object, Object> instanceMap = currentPhase.getInstanceMap();
            this.addMatcher(new LenientEqualityMatcher(arg, instanceMap));
        }
        return arg;
    }

    protected final double withEqual(double value, double delta) {
        this.addMatcher(new NumericEqualityMatcher(value, delta));
        return value;
    }

    protected final float withEqual(float value, double delta) {
        this.addMatcher(new NumericEqualityMatcher(value, delta));
        return value;
    }

    protected final <T> T withInstanceLike(T object) {
        this.addMatcher(ClassMatcher.create(object.getClass()));
        return object;
    }

    protected final <T> T withInstanceOf(Class<T> argClass) {
        this.addMatcher(ClassMatcher.create(argClass));
        return null;
    }

    protected final <T> T withNotEqual(T arg) {
        this.addMatcher(new InequalityMatcher(arg));
        return arg;
    }

    protected final <T> T withNull() {
        this.addMatcher(NullityMatcher.INSTANCE);
        return null;
    }

    protected final <T> T withNotNull() {
        this.addMatcher(NonNullityMatcher.INSTANCE);
        return null;
    }

    protected final <T> T withSameInstance(T object) {
        this.addMatcher(new SamenessMatcher(object));
        return object;
    }

    protected final <T extends CharSequence> T withSubstring(T text) {
        this.addMatcher(new StringContainmentMatcher(text));
        return text;
    }

    protected final <T extends CharSequence> T withPrefix(T text) {
        this.addMatcher(new StringPrefixMatcher(text));
        return text;
    }

    protected final <T extends CharSequence> T withSuffix(T text) {
        this.addMatcher(new StringSuffixMatcher(text));
        return text;
    }

    protected final <T extends CharSequence> T withMatch(T regex) {
        this.addMatcher(new PatternMatcher(regex.toString()));
        return regex;
    }

    static {
        Startup.verifyInitialization();
    }
}

