/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.lines;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CallPoint;
import mockit.coverage.Configuration;

public class LineSegmentData
implements Serializable {
    private static final long serialVersionUID = -6233980722802474992L;
    private static final int MAX_CALL_POINTS = Integer.parseInt(Configuration.getProperty("maxCallPoints", "10"));
    private boolean unreachable;
    private boolean empty;
    int executionCount;
    @Nullable
    private List<CallPoint> callPoints;

    public final void markAsUnreachable() {
        this.unreachable = true;
    }

    public final boolean isEmpty() {
        return this.empty;
    }

    final void markAsEmpty() {
        this.empty = true;
    }

    final boolean acceptsAdditionalCallPoints() {
        return this.callPoints == null || this.callPoints.size() < MAX_CALL_POINTS;
    }

    final int registerExecution(@Nullable CallPoint callPoint) {
        int previousExecutionCount = this.executionCount++;
        if (callPoint != null) {
            this.addCallPoint(callPoint);
        }
        return previousExecutionCount;
    }

    private void addCallPoint(@Nonnull CallPoint callPoint) {
        if (this.callPoints == null) {
            this.callPoints = new ArrayList<CallPoint>(MAX_CALL_POINTS);
        }
        for (int i = this.callPoints.size() - 1; i >= 0; --i) {
            CallPoint previousCallPoint = this.callPoints.get(i);
            if (!callPoint.isSameLineInTestCode(previousCallPoint)) continue;
            previousCallPoint.incrementRepetitionCount();
            return;
        }
        this.callPoints.add(callPoint);
    }

    public final boolean containsCallPoints() {
        return this.callPoints != null;
    }

    @Nullable
    public final List<CallPoint> getCallPoints() {
        return this.callPoints;
    }

    public final int getExecutionCount() {
        return this.executionCount;
    }

    final void setExecutionCount(int executionCount) {
        this.executionCount = executionCount;
    }

    public final boolean isCovered() {
        return this.unreachable || !this.empty && this.executionCount > 0;
    }

    final void addExecutionCountAndCallPointsFromPreviousTestRun(@Nonnull LineSegmentData previousData) {
        this.executionCount += previousData.executionCount;
        if (previousData.callPoints != null) {
            if (this.callPoints != null) {
                this.callPoints.addAll(0, previousData.callPoints);
            } else {
                this.callPoints = previousData.callPoints;
            }
        }
    }

    void reset() {
        this.executionCount = 0;
    }
}

