/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import java.security.ProtectionDomain;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.Expectations;
import mockit.MockUp;
import mockit.Verifications;
import mockit.internal.util.GeneratedClasses;

final class CapturedType {
    private static final ProtectionDomain JMOCKIT_DOMAIN = CapturedType.class.getProtectionDomain();
    @Nonnull
    final Class<?> baseType;

    CapturedType(@Nonnull Class<?> baseType) {
        this.baseType = baseType;
    }

    boolean isToBeCaptured(@Nonnull Class<?> aClass) {
        if (this.baseType == Object.class ? aClass.isArray() || MockUp.class.isAssignableFrom(aClass) || Delegate.class.isAssignableFrom(aClass) || Expectations.class.isAssignableFrom(aClass) || Verifications.class.isAssignableFrom(aClass) : aClass == this.baseType || !this.baseType.isAssignableFrom(aClass)) {
            return false;
        }
        return !aClass.isInterface() && !CapturedType.isNotToBeCaptured(aClass.getClassLoader(), aClass.getProtectionDomain(), aClass.getName());
    }

    static boolean isNotToBeCaptured(@Nullable ClassLoader loader, @Nullable ProtectionDomain protectionDomain, @Nonnull String classNameOrDesc) {
        if (loader == null && classNameOrDesc.startsWith("java") || protectionDomain == JMOCKIT_DOMAIN || GeneratedClasses.isGeneratedClass(classNameOrDesc)) {
            return true;
        }
        return classNameOrDesc.endsWith("Test") || classNameOrDesc.startsWith("junit") || classNameOrDesc.startsWith("sun") && !CapturedType.hasSubPackage(classNameOrDesc, 4, "management") || classNameOrDesc.startsWith("org") && CapturedType.hasSubPackage(classNameOrDesc, 4, "junit testng hamcrest") || classNameOrDesc.startsWith("com") && (CapturedType.hasSubPackage(classNameOrDesc, 4, "sun") && !CapturedType.hasSubPackage(classNameOrDesc, 8, "proxy org") || CapturedType.hasSubPackage(classNameOrDesc, 4, "intellij")) || GeneratedClasses.isExternallyGeneratedSubclass(classNameOrDesc);
    }

    private static boolean hasSubPackage(@Nonnull String nameOrDesc, int offset, @Nonnull String subPackages) {
        int subPackageEnd;
        int subPackageStart = 0;
        do {
            int subPackageLength;
            if (nameOrDesc.regionMatches(offset, subPackages, subPackageStart, subPackageLength = ((subPackageEnd = subPackages.indexOf(32, subPackageStart)) > 0 ? subPackageEnd : subPackages.length()) - subPackageStart)) {
                return true;
            }
            subPackageStart = subPackageEnd + 1;
        } while (subPackageEnd > 0);
        return false;
    }
}

