/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.classGeneration;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Attribute;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.FieldVisitor;
import mockit.external.asm.MethodVisitor;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.classGeneration.MockedTypeInfo;
import mockit.internal.util.TypeDescriptor;

public class BaseSubclassGenerator
extends BaseClassModifier {
    private static final int CLASS_ACCESS_MASK = 64511;
    private static final int CONSTRUCTOR_ACCESS_MASK = 5;
    @Nonnull
    Class<?> baseClass;
    @Nonnull
    private final String subclassName;
    @Nullable
    protected final MockedTypeInfo mockedTypeInfo;
    private final boolean copyConstructors;
    @Nonnull
    private final List<String> implementedMethods;
    @Nullable
    private String superClassOfSuperClass;
    private Set<String> superInterfaces;

    protected BaseSubclassGenerator(@Nonnull Class<?> baseClass, @Nonnull ClassReader classReader, @Nullable Type genericMockedType, @Nonnull String subclassName, boolean copyConstructors) {
        super(classReader);
        this.baseClass = baseClass;
        this.subclassName = subclassName.replace('.', '/');
        this.mockedTypeInfo = genericMockedType == null ? null : new MockedTypeInfo(genericMockedType);
        this.copyConstructors = copyConstructors;
        this.implementedMethods = new ArrayList<String>();
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        int subclassAccess = access & 0xFBFF | 0x10;
        String subclassSignature = this.mockedTypeInfo == null ? signature : this.mockedTypeInfo.implementationSignature;
        super.visit(version, subclassAccess, this.subclassName, subclassSignature, name, null);
        this.superClassOfSuperClass = superName;
        this.superInterfaces = new HashSet<String>();
        if (interfaces != null && interfaces.length > 0) {
            this.superInterfaces.addAll(Arrays.asList(interfaces));
        }
    }

    @Override
    public final void visitInnerClass(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
    }

    @Override
    public final void visitOuterClass(@Nonnull String owner, @Nullable String name, @Nullable String desc) {
    }

    @Override
    public final void visitAttribute(Attribute attr) {
    }

    @Override
    public final void visitSource(@Nullable String source, @Nullable String debug) {
    }

    @Override
    @Nullable
    public final FieldVisitor visitField(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        return null;
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (this.copyConstructors && "<init>".equals(name)) {
            if ((access & 5) != 0) {
                this.generateConstructorDelegatingToSuper(desc, signature, exceptions);
            }
        } else {
            this.generateImplementationIfAbstractMethod(this.superClassName, access, name, desc, signature, exceptions);
        }
        return null;
    }

    private void generateConstructorDelegatingToSuper(@Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        this.mw = this.cw.visitMethod(1, "<init>", desc, signature, exceptions);
        this.mw.visitVarInsn(25, 0);
        int varIndex = 1;
        for (mockit.external.asm.Type paramType : mockit.external.asm.Type.getArgumentTypes(desc)) {
            int loadOpcode = BaseSubclassGenerator.getLoadOpcodeForParameterType(paramType.getSort());
            this.mw.visitVarInsn(loadOpcode, varIndex);
            ++varIndex;
        }
        this.mw.visitMethodInsn(183, this.superClassName, "<init>", desc, false);
        this.generateEmptyImplementation();
    }

    private static int getLoadOpcodeForParameterType(int paramType) {
        if (paramType <= 5) {
            return 21;
        }
        switch (paramType) {
            case 6: {
                return 23;
            }
            case 7: {
                return 22;
            }
            case 8: {
                return 24;
            }
        }
        return 25;
    }

    private void generateImplementationIfAbstractMethod(String className, int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        String methodNameAndDesc;
        if (!"<init>".equals(name) && !this.implementedMethods.contains(methodNameAndDesc = name + desc)) {
            if ((access & 0x400) != 0) {
                this.generateMethodImplementation(className, access, name, desc, signature, exceptions);
            }
            this.implementedMethods.add(methodNameAndDesc);
        }
    }

    protected void generateMethodImplementation(String className, int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
    }

    @Override
    public void visitEnd() {
        this.generateImplementationsForInheritedAbstractMethods(this.superClassOfSuperClass);
        while (!this.superInterfaces.isEmpty()) {
            String superInterface = this.superInterfaces.iterator().next();
            this.generateImplementationsForInterfaceMethods(superInterface);
            this.superInterfaces.remove(superInterface);
        }
    }

    private void generateImplementationsForInheritedAbstractMethods(@Nullable String superName) {
        if (superName != null && !"java/lang/Object".equals(superName)) {
            new MethodModifierForSuperclass(superName);
        }
    }

    private void generateImplementationsForInterfaceMethods(String superName) {
        if (!"java/lang/Object".equals(superName)) {
            new MethodModifierForImplementedInterface(superName);
        }
    }

    private final class MethodModifierForImplementedInterface
    extends BaseMethodModifier {
        MethodModifierForImplementedInterface(String interfaceName) {
            super(interfaceName);
        }

        @Override
        public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            assert (interfaces != null);
            BaseSubclassGenerator.this.superInterfaces.addAll(Arrays.asList(interfaces));
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, String signature, String[] exceptions) {
            this.generateImplementationForInterfaceMethodIfMissing(access, name, desc, signature, exceptions);
            return null;
        }

        private void generateImplementationForInterfaceMethodIfMissing(int access, @Nonnull String name, @Nonnull String desc, String signature, String[] exceptions) {
            String methodNameAndDesc = name + desc;
            if (!BaseSubclassGenerator.this.implementedMethods.contains(methodNameAndDesc)) {
                if (!this.hasMethodImplementation(name, desc)) {
                    BaseSubclassGenerator.this.generateMethodImplementation(this.typeName, access, name, desc, signature, exceptions);
                }
                BaseSubclassGenerator.this.implementedMethods.add(methodNameAndDesc);
            }
        }

        private boolean hasMethodImplementation(@Nonnull String name, @Nonnull String desc) {
            Class<?>[] paramTypes = TypeDescriptor.getParameterTypes(desc);
            try {
                Method method = BaseSubclassGenerator.this.baseClass.getMethod(name, paramTypes);
                return !method.getDeclaringClass().isInterface();
            }
            catch (NoSuchMethodException ignore) {
                return false;
            }
        }
    }

    private final class MethodModifierForSuperclass
    extends BaseMethodModifier {
        String superClassName;

        MethodModifierForSuperclass(String className) {
            super(className);
        }

        @Override
        public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            this.superClassName = superName;
            if (interfaces != null) {
                BaseSubclassGenerator.this.superInterfaces.addAll(Arrays.asList(interfaces));
            }
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, String signature, String[] exceptions) {
            BaseSubclassGenerator.this.generateImplementationIfAbstractMethod(this.typeName, access, name, desc, signature, exceptions);
            return null;
        }

        @Override
        public void visitEnd() {
            BaseSubclassGenerator.this.generateImplementationsForInheritedAbstractMethods(this.superClassName);
        }
    }

    private static class BaseMethodModifier
    extends ClassVisitor {
        @Nonnull
        final String typeName;

        BaseMethodModifier(@Nonnull String typeName) {
            this.typeName = typeName;
            ClassFile.visitClass(typeName, this);
        }

        @Override
        @Nullable
        public final FieldVisitor visitField(int access, @Nonnull String name, @Nonnull String desc, String signature, Object value) {
            return null;
        }
    }
}

