/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.reflection.ConstructorReflection;

public abstract class InstanceFactory {
    @Nonnull
    final Class<?> concreteClass;
    @Nullable
    Object lastInstance;

    InstanceFactory(@Nonnull Class<?> concreteClass) {
        this.concreteClass = concreteClass;
    }

    @Nonnull
    public abstract Object create();

    @Nullable
    public final Object getLastInstance() {
        return this.lastInstance;
    }

    public abstract void clearLastInstance();

    static final class ClassInstanceFactory
    extends InstanceFactory {
        ClassInstanceFactory(@Nonnull Class<?> concreteClass) {
            super(concreteClass);
        }

        @Override
        @Nonnull
        public Object create() {
            this.lastInstance = ConstructorReflection.newUninitializedInstance(this.concreteClass);
            return this.lastInstance;
        }

        @Override
        public void clearLastInstance() {
            this.lastInstance = null;
        }
    }

    static final class InterfaceInstanceFactory
    extends InstanceFactory {
        @Nullable
        private Object emptyProxy;

        InterfaceInstanceFactory(@Nonnull Object emptyProxy) {
            super(emptyProxy.getClass());
            this.emptyProxy = emptyProxy;
        }

        @Override
        @Nonnull
        public Object create() {
            if (this.emptyProxy == null) {
                this.emptyProxy = ConstructorReflection.newUninitializedInstance(this.concreteClass);
            }
            this.lastInstance = this.emptyProxy;
            return this.emptyProxy;
        }

        @Override
        public void clearLastInstance() {
            this.emptyProxy = null;
            this.lastInstance = null;
        }
    }
}

