/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.external.asm.MethodWriter;
import mockit.external.asm.Type;
import mockit.internal.expectations.transformation.InvocationBlockModifier;

final class ArgumentMatching {
    private static final Type[] NO_PARAMETERS = new Type[0];
    private static final String ANY_FIELDS = "any anyString anyInt anyBoolean anyLong anyDouble anyFloat anyChar anyShort anyByte";
    private static final String WITH_METHODS = "withArgThat(Lorg/hamcrest/Matcher;)Ljava/lang/Object; with(Lmockit/Delegate;)Ljava/lang/Object; withAny(Ljava/lang/Object;)Ljava/lang/Object; withCapture()Ljava/lang/Object; withCapture(Ljava/util/List;)Ljava/lang/Object; withCapture(Ljava/lang/Object;)Ljava/util/List; withEqual(Ljava/lang/Object;)Ljava/lang/Object; withEqual(DD)D withEqual(FD)F withInstanceLike(Ljava/lang/Object;)Ljava/lang/Object; withInstanceOf(Ljava/lang/Class;)Ljava/lang/Object; withNotEqual(Ljava/lang/Object;)Ljava/lang/Object; withNull()Ljava/lang/Object; withNotNull()Ljava/lang/Object; withSameInstance(Ljava/lang/Object;)Ljava/lang/Object; withSubstring(Ljava/lang/CharSequence;)Ljava/lang/CharSequence; withPrefix(Ljava/lang/CharSequence;)Ljava/lang/CharSequence; withSuffix(Ljava/lang/CharSequence;)Ljava/lang/CharSequence; withMatch(Ljava/lang/CharSequence;)Ljava/lang/CharSequence;";
    @Nonnull
    private final InvocationBlockModifier modifier;
    @Nonnull
    private final int[] matcherStacks;
    @Nonnegative
    private int matcherCount;
    @Nonnull
    private Type[] parameterTypes;

    static boolean isAnyField(@Nonnull String name) {
        return name.startsWith("any") && ANY_FIELDS.contains(name);
    }

    static boolean isCallToArgumentMatcher(@Nonnull String name, @Nonnull String desc) {
        return name.startsWith("with") && WITH_METHODS.contains(name + desc);
    }

    ArgumentMatching(@Nonnull InvocationBlockModifier modifier) {
        this.modifier = modifier;
        this.matcherStacks = new int[40];
        this.parameterTypes = NO_PARAMETERS;
    }

    void addMatcher(@Nonnegative int stackSize) {
        this.matcherStacks[this.matcherCount++] = stackSize;
    }

    @Nonnegative
    int getMatcherCount() {
        return this.matcherCount;
    }

    @Nonnull
    Type getParameterType(@Nonnegative int parameterIndex) {
        return this.parameterTypes[parameterIndex];
    }

    void generateCodeToAddArgumentMatcherForAnyField(@Nonnull String fieldOwner, @Nonnull String name, @Nonnull String desc) {
        MethodWriter mw = this.modifier.getMethodWriter();
        mw.visitFieldInsn(180, fieldOwner, name, desc);
        this.modifier.generateCallToActiveInvocationsMethod(name);
    }

    boolean handleInvocationParameters(@Nonnegative int stackSize, @Nonnull String desc) {
        boolean mockedInvocationUsingTheMatchers;
        this.parameterTypes = Type.getArgumentTypes(desc);
        int stackAfter = stackSize - this.getSumOfParameterSizes();
        boolean bl = mockedInvocationUsingTheMatchers = stackAfter < this.matcherStacks[0];
        if (mockedInvocationUsingTheMatchers) {
            this.generateCallsToMoveArgMatchers(stackAfter);
            this.modifier.argumentCapturing.generateCallsToSetArgumentTypesToCaptureIfAny();
            this.matcherCount = 0;
        }
        return mockedInvocationUsingTheMatchers;
    }

    @Nonnegative
    private int getSumOfParameterSizes() {
        int sum = 0;
        for (Type argType : this.parameterTypes) {
            sum += argType.getSize();
        }
        return sum;
    }

    private void generateCallsToMoveArgMatchers(@Nonnegative int initialStack) {
        int stack = initialStack;
        int nextMatcher = 0;
        int matcherStack = this.matcherStacks[0];
        for (int i = 0; i < this.parameterTypes.length && nextMatcher < this.matcherCount; ++i) {
            if ((stack += this.parameterTypes[i].getSize()) != matcherStack && stack != matcherStack + 1) continue;
            if (nextMatcher < i) {
                this.generateCallToMoveArgMatcher(nextMatcher, i);
                this.modifier.argumentCapturing.updateCaptureIfAny(nextMatcher, i);
            }
            matcherStack = this.matcherStacks[++nextMatcher];
        }
    }

    private void generateCallToMoveArgMatcher(@Nonnegative int originalMatcherIndex, @Nonnegative int toIndex) {
        MethodWriter mw = this.modifier.getMethodWriter();
        mw.visitIntInsn(17, originalMatcherIndex);
        mw.visitIntInsn(17, toIndex);
        this.modifier.generateCallToActiveInvocationsMethod("moveArgMatcher", "(II)V");
    }
}

