/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.servlet.ServletConfig;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.injection.BeanExporter;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.LifecycleMethods;
import mockit.internal.injection.MultiValuedProvider;
import mockit.internal.injection.TestedClass;
import mockit.internal.reflection.FieldReflection;
import mockit.internal.reflection.GenericTypeReflection;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class InjectionState
implements BeanExporter {
    @Nonnull
    private static final Map<InjectionPoint, Object> globalDependencies = new ConcurrentHashMap<InjectionPoint, Object>(2);
    @Nonnull
    private final Map<ParameterizedType, Method> interfaceResolutionMethods = new HashMap<ParameterizedType, Method>();
    @Nonnull
    private final Map<InjectionPoint, Object> testedObjects = new LinkedHashMap<InjectionPoint, Object>();
    @Nonnull
    private final Map<InjectionPoint, Object> instantiatedDependencies = new LinkedHashMap<InjectionPoint, Object>();
    @Nonnull
    private List<MockedType> injectables = Collections.emptyList();
    @Nonnull
    private List<InjectionProvider> consumedInjectionProviders = new ArrayList<InjectionProvider>();
    @Nonnull
    public final LifecycleMethods lifecycleMethods = new LifecycleMethods();
    private GenericTypeReflection testedTypeReflection;
    private Object currentTestClassInstance;
    private Type typeOfInjectionPoint;

    InjectionState() {
    }

    void buildListsOfInjectables(@Nonnull Object testClassInstance, @Nonnull List<MockedType> injectables) {
        this.currentTestClassInstance = testClassInstance;
        this.injectables = new ArrayList<MockedType>(injectables);
        ParameterTypeRedefinitions paramTypeRedefs = TestRun.getExecutingTest().getParameterRedefinitions();
        if (paramTypeRedefs != null) {
            this.injectables.addAll(paramTypeRedefs.getInjectableParameters());
        }
        this.getServletConfigForInitMethodsIfAny(testClassInstance);
    }

    private void getServletConfigForInitMethodsIfAny(@Nonnull Object testClassInstance) {
        if (InjectionPoint.SERVLET_CLASS != null) {
            for (InjectionProvider injectionProvider : this.injectables) {
                if (injectionProvider.getDeclaredType() != ServletConfig.class) continue;
                this.lifecycleMethods.servletConfig = injectionProvider.getValue(testClassInstance);
                break;
            }
        }
    }

    void buildListsOfInjectables(@Nonnull Object testClassInstance, @Nonnull ParameterTypeRedefinitions paramTypeRedefs) {
        this.currentTestClassInstance = testClassInstance;
        this.injectables = new ArrayList<MockedType>(paramTypeRedefs.getInjectableParameters());
        this.getServletConfigForInitMethodsIfAny(testClassInstance);
    }

    Object getCurrentTestClassInstance() {
        return this.currentTestClassInstance;
    }

    void setTestedTypeReflection(@Nonnull GenericTypeReflection reflection) {
        this.testedTypeReflection = reflection;
    }

    public void setTypeOfInjectionPoint(@Nonnull Type typeOfInjectionPoint) {
        this.typeOfInjectionPoint = typeOfInjectionPoint;
    }

    public boolean isAssignableToInjectionPoint(@Nonnull Type injectableType) {
        ParameterizedType parameterizedType;
        Class classOfInjectionPoint;
        if (this.testedTypeReflection.areMatchingTypes(this.typeOfInjectionPoint, injectableType)) {
            return true;
        }
        if (this.typeOfInjectionPoint instanceof ParameterizedType && (Iterable.class.isAssignableFrom(classOfInjectionPoint = (Class)(parameterizedType = (ParameterizedType)this.typeOfInjectionPoint).getRawType()) || InjectionPoint.INJECT_CLASS != null && Provider.class.isAssignableFrom(classOfInjectionPoint))) {
            Type providedType = parameterizedType.getActualTypeArguments()[0];
            if (providedType.equals(injectableType)) {
                return true;
            }
            Class<?> injectableClass = Utilities.getClassType(injectableType);
            Class<?> providedClass = Utilities.getClassType(providedType);
            return providedClass.isAssignableFrom(injectableClass);
        }
        return false;
    }

    @Nullable
    public MockedType findNextInjectableForInjectionPoint() {
        for (MockedType injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable) || this.consumedInjectionProviders.contains(injectable)) continue;
            return injectable;
        }
        return null;
    }

    private boolean hasTypeAssignableToInjectionPoint(@Nonnull InjectionProvider injectable) {
        Type declaredType = injectable.getDeclaredType();
        return this.isAssignableToInjectionPoint(declaredType);
    }

    @Nonnull
    List<MockedType> findInjectablesByType() {
        ArrayList<MockedType> found = new ArrayList<MockedType>();
        for (MockedType injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable) || this.consumedInjectionProviders.contains(injectable)) continue;
            found.add(injectable);
        }
        return found;
    }

    @Nullable
    public InjectionProvider getProviderByTypeAndOptionallyName(@Nonnull String nameOfInjectionPoint) {
        Type elementTypeOfIterable = InjectionState.getElementTypeIfIterable(this.typeOfInjectionPoint);
        if (elementTypeOfIterable != null) {
            return this.findInjectablesByTypeOnly(elementTypeOfIterable);
        }
        return this.findInjectableByTypeAndOptionallyName(nameOfInjectionPoint);
    }

    @Nullable
    private static Type getElementTypeIfIterable(@Nonnull Type injectableType) {
        ParameterizedType parameterizedType;
        Class classOfInjectionPoint;
        if (injectableType instanceof ParameterizedType && Iterable.class.isAssignableFrom(classOfInjectionPoint = (Class)(parameterizedType = (ParameterizedType)injectableType).getRawType())) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    @Nullable
    private InjectionProvider findInjectablesByTypeOnly(@Nonnull Type elementType) {
        MultiValuedProvider found = null;
        for (MockedType injectable : this.injectables) {
            Type injectableType = injectable.getDeclaredType();
            Type elementTypeOfIterable = InjectionState.getElementTypeIfIterable(injectableType);
            if (elementTypeOfIterable != null && this.testedTypeReflection.areMatchingTypes(elementType, elementTypeOfIterable)) {
                return injectable;
            }
            if (!this.isAssignableToInjectionPoint(injectableType)) continue;
            if (found == null) {
                found = new MultiValuedProvider(elementType);
            }
            found.addInjectable(injectable);
        }
        return found;
    }

    @Nullable
    private InjectionProvider findInjectableByTypeAndOptionallyName(@Nonnull String nameOfInjectionPoint) {
        MockedType foundInjectable = null;
        for (MockedType injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable)) continue;
            if (nameOfInjectionPoint.equals(injectable.getName())) {
                return injectable;
            }
            if (foundInjectable != null) continue;
            foundInjectable = injectable;
        }
        return foundInjectable;
    }

    @Nullable
    public MockedType findInjectableByTypeAndName(@Nonnull String nameOfInjectionPoint) {
        for (MockedType injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable) || !nameOfInjectionPoint.equals(injectable.getName())) continue;
            return injectable;
        }
        return null;
    }

    @Nullable
    public Object getValueToInject(@Nonnull InjectionProvider injectionProvider) {
        if (this.consumedInjectionProviders.contains(injectionProvider)) {
            return null;
        }
        Object value = injectionProvider.getValue(this.currentTestClassInstance);
        if (value != null) {
            this.consumedInjectionProviders.add(injectionProvider);
        }
        return value;
    }

    void resetConsumedInjectionProviders() {
        this.consumedInjectionProviders.clear();
    }

    @Nonnull
    public List<InjectionProvider> saveConsumedInjectionProviders() {
        List<InjectionProvider> previouslyConsumed = this.consumedInjectionProviders;
        this.consumedInjectionProviders = new ArrayList<InjectionProvider>();
        return previouslyConsumed;
    }

    public void restoreConsumedInjectionProviders(@Nonnull List<InjectionProvider> previouslyConsumed) {
        this.consumedInjectionProviders = previouslyConsumed;
    }

    void saveTestedObject(@Nonnull InjectionPoint key, @Nonnull Object testedObject) {
        this.testedObjects.put(key, testedObject);
    }

    @Nullable
    Object getTestedInstance(@Nonnull Type testedType, @Nonnull String nameOfInjectionPoint) {
        Object testedInstance;
        Object object = testedInstance = this.instantiatedDependencies.isEmpty() ? null : this.findPreviouslyInstantiatedDependency(testedType, nameOfInjectionPoint);
        if (testedInstance == null) {
            testedInstance = this.testedObjects.isEmpty() ? null : this.getValueFromExistingTestedObject(testedType, nameOfInjectionPoint);
        }
        return testedInstance;
    }

    @Nullable
    private Object findPreviouslyInstantiatedDependency(@Nonnull Type testedType, @Nonnull String nameOfInjectionPoint) {
        InjectionPoint injectionPoint = new InjectionPoint(testedType, nameOfInjectionPoint);
        Object dependency = this.instantiatedDependencies.get(injectionPoint);
        if (dependency == null && (dependency = this.instantiatedDependencies.get(injectionPoint = new InjectionPoint(testedType))) == null) {
            dependency = this.findMatchingObject(this.instantiatedDependencies, null, injectionPoint);
        }
        return dependency;
    }

    @Nullable
    private Object getValueFromExistingTestedObject(@Nonnull Type testedType, @Nonnull String nameOfInjectionPoint) {
        InjectionPoint injectionPoint = new InjectionPoint(testedType, nameOfInjectionPoint);
        for (Object testedObject : this.testedObjects.values()) {
            Object fieldValue = InjectionState.getValueFromFieldOfEquivalentTypeAndName(injectionPoint, testedObject);
            if (fieldValue == null) continue;
            return fieldValue;
        }
        return null;
    }

    @Nullable
    private static Object getValueFromFieldOfEquivalentTypeAndName(@Nonnull InjectionPoint injectionPoint, @Nonnull Object testedObject) {
        for (Field internalField : testedObject.getClass().getDeclaredFields()) {
            String qualifiedName;
            boolean qualified;
            String fieldName;
            Type fieldType = internalField.getGenericType();
            InjectionPoint internalInjectionPoint = new InjectionPoint(fieldType, fieldName = (qualified = (qualifiedName = InjectionPoint.getQualifiedName(internalField.getDeclaredAnnotations())) != null) ? qualifiedName : internalField.getName(), qualified);
            if (!internalInjectionPoint.equals(injectionPoint)) continue;
            Object fieldValue = FieldReflection.getFieldValue(internalField, testedObject);
            return fieldValue;
        }
        return null;
    }

    @Nullable
    public <D> D getGlobalDependency(@Nonnull InjectionPoint key) {
        return (D)globalDependencies.get(key);
    }

    @Nullable
    public Object getTestedValue(@Nonnull TestedClass testedClass, @Nonnull InjectionPoint injectionPoint) {
        Object testedValue = this.testedObjects.get(injectionPoint);
        if (testedValue == null) {
            testedValue = this.findMatchingObject(this.testedObjects, testedClass.reflection, injectionPoint);
        }
        return testedValue;
    }

    @Nullable
    public Object getInstantiatedDependency(@Nonnull TestedClass testedClass, @Nonnull InjectionPoint dependencyKey) {
        Object dependency = this.testedObjects.get(dependencyKey);
        if (dependency == null && (dependency = this.findMatchingObject(this.testedObjects, testedClass.reflection, dependencyKey)) == null && (dependency = this.instantiatedDependencies.get(dependencyKey)) == null && (dependency = this.findMatchingObject(this.instantiatedDependencies, testedClass.reflection, dependencyKey)) == null) {
            dependency = this.findMatchingObject(globalDependencies, testedClass.reflection, dependencyKey);
        }
        return dependency;
    }

    @Nullable
    private Object findMatchingObject(@Nonnull Map<InjectionPoint, Object> availableObjects, @Nullable GenericTypeReflection reflection, @Nonnull InjectionPoint injectionPoint) {
        if (availableObjects.isEmpty()) {
            return null;
        }
        Type dependencyType = injectionPoint.type;
        Object found = null;
        for (Map.Entry<InjectionPoint, Object> injectionPointAndObject : availableObjects.entrySet()) {
            InjectionPoint dependencyIP = injectionPointAndObject.getKey();
            Object dependencyObject = injectionPointAndObject.getValue();
            if (injectionPoint.equals(dependencyIP)) {
                return dependencyObject;
            }
            if (reflection == null || !reflection.areMatchingTypes(dependencyType, dependencyIP.type)) continue;
            if (injectionPoint.hasSameName(dependencyIP)) {
                return dependencyObject;
            }
            if (injectionPoint.qualified) {
                return null;
            }
            if (found != null) continue;
            found = dependencyObject;
        }
        return found;
    }

    public void saveInstantiatedDependency(@Nonnull InjectionPoint dependencyKey, @Nonnull Object dependency) {
        this.instantiatedDependencies.put(dependencyKey, dependency);
    }

    public void saveGlobalDependency(@Nonnull InjectionPoint dependencyKey, @Nonnull Object dependency) {
        globalDependencies.put(dependencyKey, dependency);
    }

    void clearTestedObjectsAndInstantiatedDependencies() {
        this.testedObjects.clear();
        this.instantiatedDependencies.clear();
    }

    @Override
    public Object getBean(@Nonnull String name) {
        for (InjectionProvider injectionProvider : this.injectables) {
            if (!name.equals(injectionProvider.getName())) continue;
            return injectionProvider.getValue(this.currentTestClassInstance);
        }
        Object bean = this.findByName(this.testedObjects, name);
        if (bean == null && (bean = this.findByName(this.instantiatedDependencies, name)) == null) {
            bean = this.findByName(globalDependencies, name);
        }
        return bean;
    }

    @Nullable
    private Object findByName(@Nonnull Map<InjectionPoint, Object> injectionPointsAndObjects, @Nonnull String name) {
        for (Map.Entry<InjectionPoint, Object> injectionPointAndObject : injectionPointsAndObjects.entrySet()) {
            InjectionPoint injectionPoint = injectionPointAndObject.getKey();
            if (!name.equals(injectionPoint.name)) continue;
            return injectionPointAndObject.getValue();
        }
        return null;
    }

    void addInterfaceResolutionMethod(@Nonnull ParameterizedType interfaceType, @Nonnull Method resolutionMethod) {
        this.interfaceResolutionMethods.put(interfaceType, resolutionMethod);
    }

    @Nullable
    public Class<?> resolveInterface(@Nonnull Class<?> interfaceType) {
        if (this.interfaceResolutionMethods.isEmpty()) {
            return null;
        }
        Method resolutionMethod = null;
        for (Map.Entry<ParameterizedType, Method> typeAndMethod : this.interfaceResolutionMethods.entrySet()) {
            ParameterizedType acceptedType = typeAndMethod.getKey();
            Method method = typeAndMethod.getValue();
            Type targetType = acceptedType.getActualTypeArguments()[0];
            if (targetType == interfaceType) {
                resolutionMethod = method;
                break;
            }
            if (!(targetType instanceof WildcardType)) continue;
            resolutionMethod = method;
        }
        if (resolutionMethod != null) {
            Class implementationClass = (Class)MethodReflection.invoke(this.currentTestClassInstance, resolutionMethod, interfaceType);
            return implementationClass;
        }
        return null;
    }
}

