/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Tested;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.TestedObjectCreation;
import mockit.internal.injection.field.FieldInjection;
import mockit.internal.injection.full.FullInjection;
import mockit.internal.util.AutoBoxing;
import mockit.internal.util.DefaultValues;

abstract class TestedObject {
    @Nonnull
    final InjectionState injectionState;
    @Nonnull
    private final String testedName;
    @Nonnull
    final Tested metadata;
    @Nullable
    private final FullInjection fullInjection;
    @Nonnull
    private final TestedClass testedClass;
    @Nullable
    private final TestedObjectCreation testedObjectCreation;
    @Nullable
    private List<Field> targetFields;
    boolean createAutomatically;
    boolean requireDIAnnotation;

    @Nullable
    static Tested getTestedAnnotationIfPresent(@Nonnull Annotation annotation) {
        if (annotation instanceof Tested) {
            return (Tested)annotation;
        }
        return annotation.annotationType().getAnnotation(Tested.class);
    }

    TestedObject(@Nonnull InjectionState injectionState, @Nonnull Tested metadata, @Nonnull String testedName, @Nonnull Type testedType, @Nonnull Class<?> testedClass) {
        this.injectionState = injectionState;
        this.testedName = testedName;
        this.metadata = metadata;
        FullInjection fullInjection = this.fullInjection = metadata.fullyInitialized() ? new FullInjection(injectionState, testedClass, testedName) : null;
        if (testedClass.isInterface() || testedClass.isEnum() || testedClass.isPrimitive() || testedClass.isArray()) {
            this.testedObjectCreation = null;
            this.testedClass = new TestedClass(testedType, testedClass);
        } else {
            this.testedObjectCreation = new TestedObjectCreation(injectionState, this.fullInjection, testedType, testedClass);
            this.testedClass = this.testedObjectCreation.testedClass;
            injectionState.lifecycleMethods.findLifecycleMethods(testedClass);
        }
    }

    boolean isAvailableDuringSetup() {
        return this.metadata.availableDuringSetup();
    }

    void instantiateWithInjectableValues(@Nonnull Object testClassInstance) {
        if (this.alreadyInstantiated(testClassInstance)) {
            return;
        }
        Class<?> testedObjectClass = this.testedClass.targetClass;
        Object testedObject = this.getExistingTestedInstanceIfApplicable(testClassInstance);
        if (TestedObject.isNonInstantiableType(testedObjectClass, testedObject)) {
            this.reusePreviouslyCreatedInstance(testClassInstance);
            return;
        }
        this.injectionState.setTestedTypeReflection(this.testedClass.reflection);
        if (testedObject == null && this.createAutomatically) {
            if (this.reusePreviouslyCreatedInstance(testClassInstance)) {
                return;
            }
            testedObject = this.createAndRegisterNewObject(testClassInstance);
        } else if (testedObject != null) {
            this.registerTestedObject(testedObject);
            testedObjectClass = testedObject.getClass();
        }
        if (testedObject != null && testedObjectClass.getClassLoader() != null) {
            this.performFieldInjection(testedObjectClass, testedObject);
            this.executeInitializationMethodsIfAny(testedObjectClass, testedObject);
        }
    }

    boolean alreadyInstantiated(@Nonnull Object testClassInstance) {
        return false;
    }

    @Nullable
    abstract Object getExistingTestedInstanceIfApplicable(@Nonnull Object var1);

    private static boolean isNonInstantiableType(@Nonnull Class<?> targetClass, @Nullable Object currentValue) {
        return targetClass.isPrimitive() && DefaultValues.defaultValueForPrimitiveType(targetClass).equals(currentValue) || currentValue == null && (targetClass.isArray() || targetClass.isEnum() || targetClass.isAnnotation() || AutoBoxing.isWrapperOfPrimitiveType(targetClass));
    }

    private boolean reusePreviouslyCreatedInstance(@Nonnull Object testClassInstance) {
        Object previousInstance = this.injectionState.getTestedInstance(this.testedClass.declaredType, this.testedName);
        if (previousInstance != null) {
            this.setInstance(testClassInstance, previousInstance);
            return true;
        }
        return false;
    }

    void setInstance(@Nonnull Object testClassInstance, @Nullable Object testedInstance) {
    }

    @Nullable
    private Object createAndRegisterNewObject(@Nonnull Object testClassInstance) {
        Object testedInstance = null;
        if (this.testedObjectCreation != null) {
            testedInstance = this.testedObjectCreation.create();
            this.setInstance(testClassInstance, testedInstance);
            this.registerTestedObject(testedInstance);
        }
        return testedInstance;
    }

    private void registerTestedObject(@Nonnull Object testedObject) {
        InjectionPoint injectionPoint = new InjectionPoint(this.testedClass.declaredType, this.testedName);
        this.injectionState.saveTestedObject(injectionPoint, testedObject);
    }

    private void performFieldInjection(@Nonnull Class<?> targetClass, @Nonnull Object testedObject) {
        FieldInjection fieldInjection = new FieldInjection(this.injectionState, this.testedClass, this.fullInjection, this.requireDIAnnotation);
        if (this.targetFields == null) {
            this.targetFields = fieldInjection.findAllTargetInstanceFieldsInTestedClassHierarchy(targetClass);
            this.requireDIAnnotation = fieldInjection.isDIAnnotationRequired();
        }
        fieldInjection.injectIntoEligibleFields(this.targetFields, testedObject);
    }

    private void executeInitializationMethodsIfAny(@Nonnull Class<?> testedClass, @Nonnull Object testedObject) {
        if (this.createAutomatically) {
            this.injectionState.lifecycleMethods.executeInitializationMethodsIfAny(testedClass, testedObject);
        }
    }

    void clearIfAutomaticCreation(@Nonnull Object testClassInstance) {
        if (this.createAutomatically && !this.isAvailableDuringSetup()) {
            this.setInstance(testClassInstance, null);
        }
    }
}

