/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.print.PrintException;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.ClassWriter;
import mockit.internal.MockingBridge;
import mockit.internal.expectations.mocking.MockedBridge;
import mockit.internal.mockups.MockMethodBridge;
import mockit.internal.mockups.MockupBridge;

final class MockingBridgeFields {
    private MockingBridgeFields() {
    }

    @Nonnull
    static String createSyntheticFieldsInJREClassToHoldMockingBridges(@Nonnull Instrumentation instrumentation) {
        FieldAdditionTransformer fieldAdditionTransformer = new FieldAdditionTransformer(instrumentation);
        instrumentation.addTransformer(fieldAdditionTransformer);
        NegativeArraySizeException.class.getName();
        if (fieldAdditionTransformer.hostClassName == null) {
            PrintException.class.getName();
        }
        return fieldAdditionTransformer.hostClassName;
    }

    private static final class FieldAdditionTransformer
    implements ClassFileTransformer {
        private static final int FIELD_ACCESS = 4105;
        @Nonnull
        private final Instrumentation instrumentation;
        String hostClassName;

        FieldAdditionTransformer(@Nonnull Instrumentation instrumentation) {
            this.instrumentation = instrumentation;
        }

        @Override
        @Nullable
        public byte[] transform(@Nullable ClassLoader loader, @Nonnull String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] classfileBuffer) {
            ClassReader cr;
            if (loader == null && this.hostClassName == null && Modifier.isPublic((cr = new ClassReader(classfileBuffer)).getAccess())) {
                this.instrumentation.removeTransformer(this);
                this.hostClassName = className;
                return this.getModifiedJREClassWithAddedFields(cr);
            }
            return null;
        }

        @Nonnull
        private byte[] getModifiedJREClassWithAddedFields(@Nonnull ClassReader classReader) {
            final ClassWriter cw = new ClassWriter(classReader);
            ClassVisitor cv = new ClassVisitor(cw){

                @Override
                public void visitEnd() {
                    this.addField(MockedBridge.MB);
                    this.addField(MockupBridge.MB);
                    this.addField(MockMethodBridge.MB);
                }

                private void addField(@Nonnull MockingBridge mb) {
                    cw.visitField(4105, mb.id, "Ljava/lang/reflect/InvocationHandler;", null, null);
                }
            };
            classReader.accept(cv, 4);
            return cw.toByteArray();
        }
    }
}

