/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.ClassFile;
import mockit.internal.startup.InstrumentationHolder;

final class PathToAgentJar {
    private static final Pattern JAR_REGEX = Pattern.compile(".*jmockit[-.\\d]*.jar");

    PathToAgentJar() {
    }

    @Nonnull
    static String getPathToJarFile() {
        String jarFilePath = PathToAgentJar.findPathToJarFileFromClasspath();
        if (jarFilePath == null) {
            jarFilePath = PathToAgentJar.findOrCreateBootstrappingJarFileInTempDir();
        }
        return jarFilePath;
    }

    @Nullable
    private static String findPathToJarFileFromClasspath() {
        String[] classPath;
        for (String cpEntry : classPath = System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (!JAR_REGEX.matcher(cpEntry).matches()) continue;
            return cpEntry;
        }
        return null;
    }

    @Nonnull
    private static String findOrCreateBootstrappingJarFileInTempDir() {
        String tempDir = System.getProperty("java.io.tmpdir");
        String currentVersion = PathToAgentJar.currentVersion();
        File bootstrapJar = new File(tempDir, "jmockitAgent-" + currentVersion + ".jar");
        if (bootstrapJar.exists()) {
            return bootstrapJar.getPath();
        }
        PathToAgentJar.createBootstrapJarInTempDir(bootstrapJar);
        return bootstrapJar.getPath();
    }

    @Nonnull
    private static String currentVersion() {
        Class<PathToAgentJar> thisClass = PathToAgentJar.class;
        String currentVersion = thisClass.getPackage().getImplementationVersion();
        if (currentVersion == null) {
            ProtectionDomain pd = thisClass.getProtectionDomain();
            String versionFile = pd.getCodeSource().getLocation().getPath() + "../../../version.txt";
            try {
                currentVersion = new RandomAccessFile(versionFile, "r").readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return currentVersion;
    }

    private static void createBootstrapJarInTempDir(@Nonnull File bootstrapJar) {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.putValue("Manifest-Version", "1.0");
        attrs.putValue("Agent-Class", InstrumentationHolder.class.getName());
        attrs.putValue("Can-Redefine-Classes", "true");
        attrs.putValue("Can-Retransform-Classes", "true");
        byte[] classFile = ClassFile.readFromFile(InstrumentationHolder.class).b;
        try {
            JarOutputStream output = new JarOutputStream((OutputStream)new FileOutputStream(bootstrapJar), manifest);
            JarEntry classEntry = new JarEntry(InstrumentationHolder.class.getName().replace('.', '/') + ".class");
            output.putNextEntry(classEntry);
            output.write(classFile);
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

