/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Type;
import mockit.internal.state.MockedTypeCascade;
import mockit.internal.util.Utilities;

public final class CascadingTypes {
    @Nonnull
    private final Map<java.lang.reflect.Type, MockedTypeCascade> mockedTypesToCascades = new ConcurrentHashMap<java.lang.reflect.Type, MockedTypeCascade>(4);

    CascadingTypes() {
    }

    public void add(boolean fromMockField, @Nonnull java.lang.reflect.Type mockedType) {
        Class<?> mockedClass = Utilities.getClassType(mockedType);
        String mockedTypeDesc = Type.getInternalName(mockedClass);
        this.add(mockedTypeDesc, fromMockField, mockedType);
    }

    @Nonnull
    MockedTypeCascade add(@Nonnull String mockedTypeDesc, boolean fromMockField, @Nonnull java.lang.reflect.Type mockedType) {
        MockedTypeCascade cascade = this.mockedTypesToCascades.get(mockedType);
        if (cascade == null) {
            cascade = new MockedTypeCascade(fromMockField, mockedType, mockedTypeDesc);
            this.mockedTypesToCascades.put(mockedType, cascade);
        }
        return cascade;
    }

    @Nonnull
    MockedTypeCascade getCascade(@Nonnull java.lang.reflect.Type mockedType) {
        return this.mockedTypesToCascades.get(mockedType);
    }

    @Nullable
    public MockedTypeCascade getCascade(@Nonnull String mockedTypeDesc, @Nullable Object mockInstance) {
        MockedTypeCascade cascade;
        if (this.mockedTypesToCascades.isEmpty()) {
            return null;
        }
        if (mockInstance != null && (cascade = this.findCascadeForInstance(mockInstance)) != null) {
            return cascade;
        }
        for (MockedTypeCascade cascade2 : this.mockedTypesToCascades.values()) {
            if (!cascade2.mockedTypeDesc.equals(mockedTypeDesc)) continue;
            return cascade2;
        }
        return null;
    }

    @Nullable
    private MockedTypeCascade findCascadeForInstance(@Nonnull Object mockInstance) {
        for (MockedTypeCascade cascade : this.mockedTypesToCascades.values()) {
            if (!cascade.hasInstance(mockInstance)) continue;
            return cascade;
        }
        return null;
    }

    void clearNonSharedCascadingTypes() {
        if (!this.mockedTypesToCascades.isEmpty()) {
            Iterator<MockedTypeCascade> itr = this.mockedTypesToCascades.values().iterator();
            while (itr.hasNext()) {
                MockedTypeCascade cascade = itr.next();
                if (cascade.fromMockField) {
                    cascade.discardCascadedMocks();
                    continue;
                }
                itr.remove();
            }
        }
    }

    public void clear() {
        this.mockedTypesToCascades.clear();
    }

    public void addInstance(@Nonnull java.lang.reflect.Type mockedType, @Nonnull Object cascadingInstance) {
        MockedTypeCascade cascade = this.mockedTypesToCascades.get(mockedType);
        if (cascade != null) {
            cascade.addInstance(cascadingInstance);
        }
    }
}

