/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TestMethod {
    @Nonnull
    public final String testClassDesc;
    @Nonnull
    public final String testMethodDesc;
    @Nonnull
    private final Type[] parameterTypes;
    @Nonnull
    private final Class<?>[] parameterClasses;
    @Nonnull
    private final Annotation[][] parameterAnnotations;
    @Nonnull
    private final Object[] parameterValues;

    public TestMethod(@Nonnull Method testMethod, @Nonnull Object[] parameterValues) {
        this.testClassDesc = mockit.external.asm.Type.getInternalName(testMethod.getDeclaringClass());
        this.testMethodDesc = testMethod.getName() + mockit.external.asm.Type.getMethodDescriptor(testMethod);
        this.parameterTypes = testMethod.getGenericParameterTypes();
        this.parameterClasses = testMethod.getParameterTypes();
        this.parameterAnnotations = testMethod.getParameterAnnotations();
        this.parameterValues = parameterValues;
    }

    @Nonnegative
    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    @Nonnull
    public Type getParameterType(@Nonnegative int index) {
        return this.parameterTypes[index];
    }

    @Nonnull
    public Class<?> getParameterClass(@Nonnegative int index) {
        return this.parameterClasses[index];
    }

    @Nonnull
    public Annotation[] getParameterAnnotations(@Nonnegative int index) {
        return this.parameterAnnotations[index];
    }

    @Nullable
    public Object getParameterValue(@Nonnegative int index) {
        return this.parameterValues[index];
    }

    public void setParameterValue(@Nonnegative int index, @Nullable Object value) {
        this.parameterValues[index] = value;
    }
}

