/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.AutoBoxing;

public final class Utilities {
    @Nonnull
    public static final Object[] NO_ARGS = new Object[0];
    public static final float JAVA_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    public static final boolean JAVA8 = JAVA_VERSION >= 1.8f;
    public static final boolean JAVA9 = JAVA_VERSION >= 9.0f;
    public static final boolean HOTSPOT_VM;

    private Utilities() {
    }

    public static void ensureThatMemberIsAccessible(@Nonnull AccessibleObject classMember) {
        if (!classMember.isAccessible()) {
            classMember.setAccessible(true);
        }
    }

    @Nonnull
    public static Class<?> getClassType(@Nonnull Type declaredType) {
        while (true) {
            if (declaredType instanceof Class) {
                return (Class)declaredType;
            }
            if (declaredType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)declaredType).getRawType();
            }
            if (declaredType instanceof TypeVariable) {
                declaredType = ((TypeVariable)declaredType).getBounds()[0];
                continue;
            }
            if (!(declaredType instanceof WildcardType)) break;
            declaredType = ((WildcardType)declaredType).getUpperBounds()[0];
        }
        throw new IllegalArgumentException("Type of unexpected kind: " + declaredType);
    }

    public static boolean containsReference(@Nonnull List<?> references, @Nullable Object toBeFound) {
        return Utilities.indexOfReference(references, toBeFound) >= 0;
    }

    public static int indexOfReference(@Nonnull List<?> references, @Nullable Object toBeFound) {
        int n = references.size();
        for (int i = 0; i < n; ++i) {
            if (references.get(i) != toBeFound) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfReference(@Nonnull Object[] references, @Nullable Object toBeFound) {
        int n = references.length;
        for (int i = 0; i < n; ++i) {
            if (references[i] != toBeFound) continue;
            return i;
        }
        return -1;
    }

    public static boolean isClassAssignableTo(@Nonnull List<Class<?>> fromClasses, @Nonnull Class<?> toClass) {
        int n = fromClasses.size();
        for (int i = 0; i < n; ++i) {
            Class<?> fromClass = fromClasses.get(i);
            if (toClass != fromClass && !toClass.isAssignableFrom(fromClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Class<?> findClassAssignableFrom(@Nonnull List<Class<?>> toClasses, @Nonnull Class<?> fromClass) {
        for (int i = 0; i < toClasses.size(); ++i) {
            Class<?> toClass = toClasses.get(i);
            if (toClass != fromClass && !toClass.isAssignableFrom(fromClass)) continue;
            return toClass;
        }
        return null;
    }

    @Nullable
    public static Object convertFromString(@Nonnull Class<?> targetType, @Nullable String value) {
        if (value != null) {
            if (targetType == String.class) {
                return value;
            }
            if (targetType == Character.TYPE || targetType == Character.class) {
                return Character.valueOf(value.charAt(0));
            }
            if (targetType.isPrimitive()) {
                Class<?> wrapperClass = AutoBoxing.getWrapperType(targetType);
                assert (wrapperClass != null);
                return Utilities.newWrapperInstance(wrapperClass, value);
            }
            if (AutoBoxing.isWrapperOfPrimitiveType(targetType)) {
                return Utilities.newWrapperInstance(targetType, value);
            }
            if (targetType == BigDecimal.class) {
                return new BigDecimal(value.trim());
            }
            if (targetType == BigInteger.class) {
                return new BigInteger(value.trim());
            }
            if (targetType == AtomicInteger.class) {
                return new AtomicInteger(Integer.parseInt(value.trim()));
            }
            if (targetType == AtomicLong.class) {
                return new AtomicLong(Long.parseLong(value.trim()));
            }
            if (targetType.isEnum()) {
                Class<?> enumType = targetType;
                return Enum.valueOf(enumType, value);
            }
        }
        return null;
    }

    @Nonnull
    private static Object newWrapperInstance(@Nonnull Class<?> wrapperClass, @Nonnull String value) {
        for (Constructor<?> constructor : wrapperClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes;
            if (!Modifier.isPublic(constructor.getModifiers()) || (parameterTypes = constructor.getParameterTypes()).length != 1 || parameterTypes[0] != String.class) continue;
            try {
                return constructor.newInstance(value.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Unable to instantiate " + wrapperClass + " with value \"" + value + "\"");
    }

    public static boolean calledFromSpecialThread() {
        Thread currentThread = Thread.currentThread();
        return "java.awt.EventDispatchThread".equals(currentThread.getClass().getName()) || "system".equals(currentThread.getThreadGroup().getName());
    }

    static {
        String vmName = System.getProperty("java.vm.name");
        HOTSPOT_VM = vmName.contains("HotSpot") || vmName.contains("OpenJDK");
    }
}

