/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.controlFlow;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.constantPool.Item;
import mockit.asm.constantPool.LongValueItem;
import mockit.asm.constantPool.StringItem;
import mockit.asm.constantPool.TypeOrMemberItem;
import mockit.asm.controlFlow.Edge;
import mockit.asm.controlFlow.Frame;
import mockit.asm.controlFlow.Label;
import mockit.asm.jvmConstants.JVMInstruction;
import mockit.asm.util.ByteVector;

public final class CFGAnalysis {
    @Nonnull
    private final ConstantPoolGeneration cp;
    @Nonnull
    private final String classDesc;
    @Nonnull
    private final ByteVector code;
    private final boolean computeFrames;
    @Nonnull
    private final Label labels;
    @Nullable
    private Label previousBlock;
    @Nullable
    private Label currentBlock;
    @Nonnegative
    private int stackSize;
    @Nonnegative
    private int maxStackSize;

    public CFGAnalysis(@Nonnull ConstantPoolGeneration cp, @Nonnull String classDesc, @Nonnull ByteVector code, boolean computeFrames) {
        this.cp = cp;
        this.classDesc = classDesc;
        this.code = code;
        this.computeFrames = computeFrames;
        this.labels = new Label();
        this.labels.markAsPushed();
        this.updateCurrentBlockForLabelBeforeNextInstruction(this.labels);
    }

    @Nonnull
    public Label getLabelForFirstBasicBlock() {
        return this.labels;
    }

    public Frame getFirstFrame() {
        return this.labels.frame;
    }

    @Nullable
    public Label getLabelForCurrentBasicBlock() {
        return this.currentBlock;
    }

    public void updateCurrentBlockForZeroOperandInstruction(int opcode) {
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.execute(opcode);
            } else {
                int sizeVariation = JVMInstruction.SIZE[opcode];
                this.updateStackSize(sizeVariation);
            }
            if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                this.noSuccessor();
            }
        }
    }

    private void updateStackSize(int sizeVariation) {
        int newSize = this.stackSize + sizeVariation;
        if (newSize > this.maxStackSize) {
            this.maxStackSize = newSize;
        }
        this.stackSize = newSize;
    }

    private void noSuccessor() {
        if (this.computeFrames) {
            Label l = new Label();
            l.frame = new Frame(this.cp, l);
            l.resolve(this.code);
            this.previousBlock.successor = l;
            this.previousBlock = l;
        } else {
            this.currentBlock.outputStackMax = this.maxStackSize;
        }
        this.currentBlock = null;
    }

    private void addSuccessor(int info, @Nonnull Label successor) {
        Edge edge = new Edge(info, successor);
        this.currentBlock.setSuccessors(edge);
    }

    public void updateCurrentBlockForSingleIntOperandInstruction(int opcode, int operand) {
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.executeINT(opcode, operand);
            } else if (opcode != 188) {
                this.updateStackSize(1);
            }
        }
    }

    public void updateCurrentBlockForLocalVariableInstruction(int opcode, @Nonnegative int varIndex) {
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.executeVAR(opcode, varIndex);
            } else {
                int sizeVariation = JVMInstruction.SIZE[opcode];
                this.updateStackSize(sizeVariation);
            }
        }
    }

    public void updateCurrentBlockForTypeInstruction(int opcode, @Nonnull StringItem typeItem) {
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.executeTYPE(opcode, this.code.getLength(), typeItem);
            } else if (opcode == 187) {
                this.updateStackSize(1);
            }
        }
    }

    public void updateCurrentBlockForFieldInstruction(int opcode, @Nonnull TypeOrMemberItem fieldItem, @Nonnull String fieldTypeDesc) {
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.execute(opcode, fieldItem);
            } else {
                char typeCode = fieldTypeDesc.charAt(0);
                int sizeVariation = CFGAnalysis.computeSizeVariationForFieldAccess(opcode, typeCode);
                this.updateStackSize(sizeVariation);
            }
        }
    }

    private static int computeSizeVariationForFieldAccess(int fieldAccessOpcode, char fieldTypeCode) {
        boolean doubleSizeType = fieldTypeCode == 'D' || fieldTypeCode == 'J';
        switch (fieldAccessOpcode) {
            case 178: {
                return doubleSizeType ? 2 : 1;
            }
            case 179: {
                return doubleSizeType ? -2 : -1;
            }
            case 180: {
                return doubleSizeType ? 1 : 0;
            }
        }
        return doubleSizeType ? -3 : -2;
    }

    public void updateCurrentBlockForInvokeInstruction(@Nonnull TypeOrMemberItem invokeItem, int opcode, @Nonnull String desc) {
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.execute(opcode, invokeItem);
            } else {
                int argSize = invokeItem.getArgSizeComputingIfNeeded(desc);
                int sizeVariation = -(argSize >> 2) + (argSize & 3);
                if (opcode == 184 || opcode == 186) {
                    ++sizeVariation;
                }
                this.updateStackSize(sizeVariation);
            }
        }
    }

    @Nullable
    public Label updateCurrentBlockForJumpInstruction(int opcode, @Nonnull Label label) {
        Label nextInsn = null;
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.executeJUMP(opcode);
                label.getFirst().markAsTarget();
                this.addSuccessor(0, label);
                if (opcode != 167) {
                    nextInsn = new Label();
                }
            } else {
                this.stackSize += JVMInstruction.SIZE[opcode];
                this.addSuccessor(this.stackSize, label);
            }
        }
        return nextInsn;
    }

    public void updateCurrentBlockForJumpTarget(int opcode, @Nullable Label nextInsn) {
        if (this.currentBlock != null) {
            if (nextInsn != null) {
                this.updateCurrentBlockForLabelBeforeNextInstruction(nextInsn);
            }
            if (opcode == 167) {
                this.noSuccessor();
            }
        }
    }

    public void updateCurrentBlockForLabelBeforeNextInstruction(@Nonnull Label label) {
        label.resolve(this.code);
        if (label.isDebug()) {
            return;
        }
        if (this.computeFrames) {
            if (this.currentBlock != null) {
                if (label.position == this.currentBlock.position) {
                    this.currentBlock.markAsTarget(label);
                    label.frame = this.currentBlock.frame;
                    return;
                }
                this.addSuccessor(0, label);
            }
            this.currentBlock = label;
            if (label.frame == null) {
                label.frame = new Frame(this.cp, label);
            }
            if (this.previousBlock != null) {
                if (label.position == this.previousBlock.position) {
                    this.previousBlock.markAsTarget(label);
                    label.frame = this.previousBlock.frame;
                    this.currentBlock = this.previousBlock;
                    return;
                }
                this.previousBlock.successor = label;
            }
        } else {
            if (this.currentBlock != null) {
                this.currentBlock.outputStackMax = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
            }
            this.currentBlock = label;
            this.stackSize = 0;
            this.maxStackSize = 0;
            if (this.previousBlock != null) {
                this.previousBlock.successor = label;
            }
        }
        this.previousBlock = label;
    }

    public void updateCurrentBlockForLDCInstruction(@Nonnull Item constItem) {
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.executeLDC(constItem);
            } else {
                int sizeVariation = constItem instanceof LongValueItem ? 2 : 1;
                this.updateStackSize(sizeVariation);
            }
        }
    }

    public void updateCurrentBlockForIINCInstruction(@Nonnegative int varIndex) {
        if (this.currentBlock != null && this.computeFrames) {
            this.currentBlock.frame.executeIINC(varIndex);
        }
    }

    public void updateCurrentBlockForSwitchInstruction(@Nonnull Label dflt, @Nonnull Label[] caseLabels) {
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.executeSWITCH();
                this.addSuccessor(0, dflt);
                dflt.getFirst().markAsTarget();
                for (Label label : caseLabels) {
                    this.addSuccessor(0, label);
                    label.getFirst().markAsTarget();
                }
            } else {
                --this.stackSize;
                this.addSuccessor(this.stackSize, dflt);
                this.addSuccessorForEachCase(caseLabels);
            }
            this.noSuccessor();
        }
    }

    private void addSuccessorForEachCase(@Nonnull Label[] caseLabels) {
        for (Label label : caseLabels) {
            this.addSuccessor(this.stackSize, label);
        }
    }

    public void updateCurrentBlockForMULTIANEWARRAYInstruction(@Nonnull StringItem arrayTypeItem, @Nonnegative int dims) {
        if (this.currentBlock != null) {
            if (this.computeFrames) {
                this.currentBlock.frame.executeMULTIANEWARRAY(dims, arrayTypeItem);
            } else {
                this.stackSize += 1 - dims;
            }
        }
    }

    @Nonnegative
    public int computeMaxStackSizeFromComputedFrames() {
        int max = 0;
        Label changed = this.labels;
        while (changed != null) {
            Label l = changed;
            changed = changed.next;
            l.next = null;
            Frame frame = l.frame;
            if (l.isTarget()) {
                l.markAsStoringFrame();
            }
            l.markAsReachable();
            int blockMax = frame.inputStack.length + l.outputStackMax;
            if (blockMax > max) {
                max = blockMax;
            }
            changed = this.updateSuccessorsOfCurrentBasicBlock(changed, frame, l);
        }
        return max;
    }

    @Nullable
    private Label updateSuccessorsOfCurrentBasicBlock(@Nullable Label changed, @Nonnull Frame frame, @Nonnull Label label) {
        Edge edge = label.successors;
        while (edge != null) {
            Label n = edge.successor.getFirst();
            boolean change = frame.merge(this.classDesc, n.frame, edge.info);
            if (change && n.next == null) {
                n.next = changed;
                changed = n;
            }
            edge = edge.next;
        }
        return changed;
    }

    @Nonnegative
    public int computeMaxStackSize() {
        int max = 0;
        Label stack = this.labels;
        while (stack != null) {
            Label label = stack;
            stack = stack.next;
            int start = label.inputStackTop;
            int blockMax = start + label.outputStackMax;
            if (blockMax > max) {
                max = blockMax;
            }
            stack = CFGAnalysis.analyzeBlockSuccessors(stack, label, start);
        }
        return max;
    }

    @Nullable
    private static Label analyzeBlockSuccessors(@Nullable Label stack, @Nonnull Label label, @Nonnegative int start) {
        Edge block = label.successors;
        while (block != null) {
            Label successor = block.successor;
            if (!successor.isPushed()) {
                successor.inputStackTop = block.info == Integer.MAX_VALUE ? 1 : start + block.info;
                successor.markAsPushed();
                successor.next = stack;
                stack = successor;
            }
            block = block.next;
        }
        return stack;
    }
}

