/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.methods;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotatedReader;
import mockit.asm.annotations.AnnotationVisitor;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassVisitor;
import mockit.asm.controlFlow.Label;
import mockit.asm.jvmConstants.JVMInstruction;
import mockit.asm.methods.MethodVisitor;
import mockit.asm.methods.MethodWriter;
import mockit.asm.util.MethodHandle;

public final class MethodReader
extends AnnotatedReader {
    @Nonnull
    private final ClassReader cr;
    @Nonnull
    private final ClassVisitor cv;
    @Nullable
    private String[] throwsClauseTypes;
    private String name;
    private String desc;
    @Nonnegative
    private int methodStartCodeIndex;
    @Nonnegative
    private int bodyStartCodeIndex;
    @Nonnegative
    private int parameterAnnotationsCodeIndex;
    private Label[] labels;
    private MethodVisitor mv;

    public MethodReader(@Nonnull ClassReader cr, @Nonnull ClassVisitor cv) {
        super(cr);
        this.cr = cr;
        this.cv = cv;
    }

    @Nonnegative
    public int readMethods() {
        for (int methodCount = this.readUnsignedShort(); methodCount > 0; --methodCount) {
            this.readMethod();
        }
        return this.codeIndex;
    }

    private void readMethod() {
        this.readMethodDeclaration();
        this.parameterAnnotationsCodeIndex = 0;
        this.readAttributes();
        int currentCodeIndex = this.codeIndex;
        this.readMethodBody();
        this.codeIndex = currentCodeIndex;
    }

    private void readMethodDeclaration() {
        this.access = this.readUnsignedShort();
        this.name = this.readNonnullUTF8();
        this.desc = this.readNonnullUTF8();
        this.methodStartCodeIndex = this.codeIndex;
        this.bodyStartCodeIndex = 0;
        this.throwsClauseTypes = null;
    }

    @Override
    @Nullable
    protected Boolean readAttribute(@Nonnull String attributeName) {
        switch (attributeName) {
            case "Code": {
                this.bodyStartCodeIndex = this.codeIndex;
                return false;
            }
            case "Exceptions": {
                this.readExceptionsInThrowsClause();
                return true;
            }
            case "RuntimeVisibleParameterAnnotations": {
                this.parameterAnnotationsCodeIndex = this.codeIndex;
                return false;
            }
        }
        return null;
    }

    private void readExceptionsInThrowsClause() {
        int n = this.readUnsignedShort();
        String[] typeDescs = new String[n];
        for (int i = 0; i < n; ++i) {
            typeDescs[i] = this.readNonnullClass();
        }
        this.throwsClauseTypes = typeDescs;
    }

    private void readMethodBody() {
        this.mv = this.cv.visitMethod(this.access, this.name, this.desc, this.signature, this.throwsClauseTypes);
        if (this.mv == null) {
            return;
        }
        if (this.mv instanceof MethodWriter) {
            this.copyMethodBody();
            return;
        }
        this.readAnnotations(this.mv);
        this.readAnnotationsOnAllParameters();
        if (this.bodyStartCodeIndex > 0) {
            this.codeIndex = this.bodyStartCodeIndex;
            this.readCode();
        }
        this.mv.visitEnd();
    }

    private void copyMethodBody() {
        MethodWriter mw = (MethodWriter)this.mv;
        mw.classReaderOffset = this.methodStartCodeIndex;
        mw.classReaderLength = this.codeIndex - this.methodStartCodeIndex;
    }

    private void readAnnotationsOnAllParameters() {
        if (this.parameterAnnotationsCodeIndex > 0) {
            this.codeIndex = this.parameterAnnotationsCodeIndex;
            int parameters = this.readUnsignedByte();
            for (int i = 0; i < parameters; ++i) {
                this.readParameterAnnotations(i);
            }
        }
    }

    private void readParameterAnnotations(@Nonnegative int parameterIndex) {
        for (int annotationCount = this.readUnsignedShort(); annotationCount > 0; --annotationCount) {
            String annotationTypeDesc = this.readNonnullUTF8();
            AnnotationVisitor av = this.mv.visitParameterAnnotation(parameterIndex, annotationTypeDesc);
            this.readAnnotationValues(av);
        }
    }

    private void readCode() {
        int maxStack = this.readUnsignedShort();
        this.codeIndex += 2;
        int codeLength = this.readInt();
        this.labels = new Label[codeLength + 2];
        int codeStartIndex = this.codeIndex;
        int codeEndIndex = codeStartIndex + codeLength;
        this.readAllLabelsInCodeBlock(codeStartIndex, codeEndIndex);
        this.readTryCatchBlocks();
        int varTableCodeIndex = 0;
        int[] typeTable = null;
        block10: for (int attributeCount = this.readUnsignedShort(); attributeCount > 0; --attributeCount) {
            String attrName = this.readNonnullUTF8();
            int codeOffset = this.readInt();
            switch (attrName) {
                case "LocalVariableTable": {
                    varTableCodeIndex = this.codeIndex;
                    this.readLocalVariableTable();
                    continue block10;
                }
                case "LocalVariableTypeTable": {
                    typeTable = this.readLocalVariableTypeTable();
                    continue block10;
                }
                case "LineNumberTable": {
                    this.readLineNumberTable();
                    continue block10;
                }
                default: {
                    this.codeIndex += codeOffset;
                }
            }
        }
        this.readBytecodeInstructionsInCodeBlock(codeStartIndex, codeEndIndex);
        this.visitEndLabel(codeLength);
        this.readLocalVariableTables(varTableCodeIndex, typeTable);
        this.mv.visitMaxStack(maxStack);
    }

    private void readAllLabelsInCodeBlock(@Nonnegative int codeStart, @Nonnegative int codeEnd) {
        this.getOrCreateLabel(codeEnd - codeStart + 1);
        while (this.codeIndex < codeEnd) {
            int offset = this.codeIndex - codeStart;
            this.readLabelForInstructionIfAny(offset);
        }
    }

    @Nonnull
    private Label getOrCreateLabel(@Nonnegative int offset) {
        Label label = this.labels[offset];
        if (label == null) {
            this.labels[offset] = label = new Label();
        }
        return label;
    }

    private void readLabelForInstructionIfAny(@Nonnegative int offset) {
        boolean tablInsn;
        int opcode = this.readUnsignedByte();
        byte instructionType = JVMInstruction.TYPE[opcode];
        boolean bl = tablInsn = instructionType == 14;
        if (tablInsn || instructionType == 15) {
            this.readLabelsForSwitchInstruction(offset, tablInsn);
        } else {
            this.readLabelsForNonSwitchInstruction(offset, instructionType);
        }
    }

    private void readLabelsForSwitchInstruction(@Nonnegative int offset, boolean tableNotLookup) {
        int caseCount;
        this.readSwitchDefaultLabel(offset);
        if (tableNotLookup) {
            int min = this.readInt();
            int max = this.readInt();
            caseCount = max - min + 1;
        } else {
            caseCount = this.readInt();
        }
        while (caseCount > 0) {
            if (!tableNotLookup) {
                this.codeIndex += 4;
            }
            int caseOffset = offset + this.readInt();
            this.getOrCreateLabel(caseOffset);
            --caseCount;
        }
    }

    @Nonnull
    private Label readSwitchDefaultLabel(@Nonnegative int offset) {
        this.codeIndex += 3 - (offset & 3);
        int defaultLabelOffset = this.readInt();
        return this.getOrCreateLabel(offset + defaultLabelOffset);
    }

    private void readLabelsForNonSwitchInstruction(@Nonnegative int offset, byte instructionType) {
        int codeIndexSize = 0;
        switch (instructionType) {
            case 0: 
            case 4: {
                return;
            }
            case 9: {
                int labelOffset = offset + this.readShort();
                this.getOrCreateLabel(labelOffset);
                return;
            }
            case 10: {
                int labelOffsetW = offset + this.readInt();
                this.getOrCreateLabel(labelOffsetW);
                return;
            }
            case 17: {
                int opcode = this.readUnsignedByte();
                codeIndexSize = opcode == 132 ? 4 : 2;
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                codeIndexSize = 1;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                codeIndexSize = 2;
                break;
            }
            case 7: 
            case 8: {
                codeIndexSize = 4;
                break;
            }
            case 16: {
                codeIndexSize = 3;
            }
        }
        this.codeIndex += codeIndexSize;
    }

    private void readTryCatchBlocks() {
        for (int blockCount = this.readUnsignedShort(); blockCount > 0; --blockCount) {
            Label start = this.getOrCreateLabel(this.readUnsignedShort());
            Label end = this.getOrCreateLabel(this.readUnsignedShort());
            Label handler = this.getOrCreateLabel(this.readUnsignedShort());
            String type = this.readUTF8(this.readItem());
            this.mv.visitTryCatchBlock(start, end, handler, type);
        }
    }

    private void readLocalVariableTable() {
        for (int localVarCount = this.readUnsignedShort(); localVarCount > 0; --localVarCount) {
            int labelOffset = this.readUnsignedShort();
            this.getOrCreateDebugLabel(labelOffset);
            this.getOrCreateDebugLabel(labelOffset += this.readUnsignedShort());
            this.codeIndex += 6;
        }
    }

    @Nonnull
    private Label getOrCreateDebugLabel(@Nonnegative int offset) {
        Label label = this.labels[offset];
        if (label == null) {
            label = new Label();
            label.markAsDebug();
            this.labels[offset] = label;
        }
        return label;
    }

    @Nonnull
    private int[] readLocalVariableTypeTable() {
        int typeTableSize = 3 * this.readUnsignedShort();
        int[] typeTable = new int[typeTableSize];
        while (typeTableSize > 0) {
            int startIndex = this.readUnsignedShort();
            int signatureCodeIndex = this.codeIndex + 4;
            this.codeIndex += 6;
            int varIndex = this.readUnsignedShort();
            typeTable[--typeTableSize] = signatureCodeIndex;
            typeTable[--typeTableSize] = varIndex;
            typeTable[--typeTableSize] = startIndex;
        }
        return typeTable;
    }

    private void readLineNumberTable() {
        for (int lineCount = this.readUnsignedShort(); lineCount > 0; --lineCount) {
            int labelOffset = this.readUnsignedShort();
            Label debugLabel = this.getOrCreateDebugLabel(labelOffset);
            debugLabel.line = this.readUnsignedShort();
        }
    }

    private void readBytecodeInstructionsInCodeBlock(@Nonnegative int codeStartIndex, @Nonnegative int codeEndIndex) {
        this.codeIndex = codeStartIndex;
        while (this.codeIndex < codeEndIndex) {
            int offset = this.codeIndex - codeStartIndex;
            this.visitLabelAndLineNumber(offset);
            int opcode = this.readUnsignedByte();
            switch (JVMInstruction.TYPE[opcode]) {
                case 0: {
                    this.mv.visitInsn(opcode);
                    break;
                }
                case 3: {
                    this.readVariableAccessInstruction(opcode);
                    break;
                }
                case 4: {
                    this.readInstructionWithImplicitVariable(opcode);
                    break;
                }
                case 5: {
                    this.readTypeInsn(opcode);
                    break;
                }
                case 9: {
                    this.readJump(opcode, offset);
                    break;
                }
                case 10: {
                    this.readWideJump(opcode, offset);
                    break;
                }
                case 11: {
                    this.readLDC();
                    break;
                }
                case 12: {
                    this.readLDCW();
                    break;
                }
                case 13: {
                    this.readIInc();
                    break;
                }
                case 1: {
                    this.readInstructionTakingASignedByte(opcode);
                    break;
                }
                case 2: {
                    this.readInstructionTakingASignedShort(opcode);
                    break;
                }
                case 14: {
                    this.readSwitchInstruction(offset, true);
                    break;
                }
                case 15: {
                    this.readSwitchInstruction(offset, false);
                    break;
                }
                case 16: {
                    this.readMultiANewArray();
                    break;
                }
                case 17: {
                    this.readWideInstruction();
                    break;
                }
                case 6: 
                case 7: {
                    this.readFieldOrInvokeInstruction(opcode);
                    break;
                }
                case 8: {
                    this.readInvokeDynamicInstruction();
                }
            }
        }
    }

    private void visitLabelAndLineNumber(@Nonnegative int offset) {
        Label label = this.labels[offset];
        if (label != null) {
            this.mv.visitLabel(label);
            int lineNumber = label.line;
            if (lineNumber > 0) {
                this.mv.visitLineNumber(lineNumber, label);
            }
        }
    }

    private void readVariableAccessInstruction(int opcode) {
        int varIndex = this.readUnsignedByte();
        this.mv.visitVarInsn(opcode, varIndex);
    }

    private void readInstructionWithImplicitVariable(int opcode) {
        int opcodeBase;
        if (opcode > 54) {
            opcode -= 59;
            opcodeBase = 54;
        } else {
            opcode -= 26;
            opcodeBase = 21;
        }
        int localVarOpcode = opcodeBase + (opcode >> 2);
        int varIndex = opcode & 3;
        this.mv.visitVarInsn(localVarOpcode, varIndex);
    }

    private void readTypeInsn(int opcode) {
        String typeDesc = this.readNonnullClass();
        this.mv.visitTypeInsn(opcode, typeDesc);
    }

    private void readJump(int opcode, @Nonnegative int offset) {
        short targetIndex = this.readShort();
        Label targetLabel = this.labels[offset + targetIndex];
        this.mv.visitJumpInsn(opcode, targetLabel);
    }

    private void readWideJump(int opcode, @Nonnegative int offset) {
        int targetIndex = this.readInt();
        Label targetLabel = this.labels[offset + targetIndex];
        this.mv.visitJumpInsn(opcode - 33, targetLabel);
    }

    private void readLDC() {
        int constIndex = this.readUnsignedByte();
        Object cst = this.readConst(constIndex);
        this.mv.visitLdcInsn(cst);
    }

    private void readLDCW() {
        Object cst = this.readConstItem();
        this.mv.visitLdcInsn(cst);
    }

    private void readIInc() {
        int varIndex = this.readUnsignedByte();
        int increment = this.readSignedByte();
        this.mv.visitIincInsn(varIndex, increment);
    }

    private void readInstructionTakingASignedByte(int opcode) {
        int operand = this.readSignedByte();
        this.mv.visitIntInsn(opcode, operand);
    }

    private void readInstructionTakingASignedShort(int opcode) {
        short operand = this.readShort();
        this.mv.visitIntInsn(opcode, operand);
    }

    private void readSwitchInstruction(@Nonnegative int offset, boolean tableNotLookup) {
        int[] keys;
        int caseCount;
        int max;
        int min;
        Label dfltLabel = this.readSwitchDefaultLabel(offset);
        if (tableNotLookup) {
            min = this.readInt();
            max = this.readInt();
            caseCount = max - min + 1;
            keys = null;
        } else {
            max = 0;
            min = 0;
            caseCount = this.readInt();
            keys = new int[caseCount];
        }
        Label[] handlerLabels = this.readSwitchCaseLabels(offset, caseCount, keys);
        if (tableNotLookup) {
            this.mv.visitTableSwitchInsn(min, max, dfltLabel, handlerLabels);
        } else {
            this.mv.visitLookupSwitchInsn(dfltLabel, keys, handlerLabels);
        }
    }

    @Nonnull
    private Label[] readSwitchCaseLabels(@Nonnegative int offset, @Nonnegative int caseCount, @Nullable int[] keys) {
        Label[] caseLabels = new Label[caseCount];
        for (int i = 0; i < caseCount; ++i) {
            if (keys != null) {
                keys[i] = this.readInt();
            }
            int labelOffset = offset + this.readInt();
            caseLabels[i] = this.labels[labelOffset];
        }
        return caseLabels;
    }

    private void readMultiANewArray() {
        String arrayTypeDesc = this.readNonnullClass();
        int dims = this.readUnsignedByte();
        this.mv.visitMultiANewArrayInsn(arrayTypeDesc, dims);
    }

    private void readWideInstruction() {
        int opcode = this.readUnsignedByte();
        int varIndex = this.readUnsignedShort();
        if (opcode == 132) {
            short increment = this.readShort();
            this.mv.visitIincInsn(varIndex, increment);
        } else {
            this.mv.visitVarInsn(opcode, varIndex);
            this.codeIndex += 2;
        }
    }

    private void readFieldOrInvokeInstruction(int opcode) {
        int ownerCodeIndex = this.readItem();
        String owner = this.readNonnullClass(ownerCodeIndex);
        int nameCodeIndex = this.readItem(ownerCodeIndex + 2);
        String memberName = this.readNonnullUTF8(nameCodeIndex);
        String memberDesc = this.readNonnullUTF8(nameCodeIndex + 2);
        if (opcode < 182) {
            this.mv.visitFieldInsn(opcode, owner, memberName, memberDesc);
        } else {
            boolean itf = this.code[ownerCodeIndex - 1] == 11;
            this.mv.visitMethodInsn(opcode, owner, memberName, memberDesc, itf);
            if (opcode == 185) {
                this.codeIndex += 2;
            }
        }
    }

    private void readInvokeDynamicInstruction() {
        int cpIndex = this.readItem();
        int bsmStartIndex = this.readUnsignedShort(cpIndex);
        int nameCodeIndex = this.readItem(cpIndex + 2);
        String bsmName = this.readNonnullUTF8(nameCodeIndex);
        String bsmDesc = this.readNonnullUTF8(nameCodeIndex + 2);
        int bsmCodeIndex = this.cr.getBSMCodeIndex(bsmStartIndex);
        MethodHandle bsmHandle = this.readMethodHandleItem(bsmCodeIndex);
        int bsmArgCount = this.readUnsignedShort(bsmCodeIndex + 2);
        bsmCodeIndex += 4;
        Object[] bsmArgs = new Object[bsmArgCount];
        for (int i = 0; i < bsmArgCount; ++i) {
            bsmArgs[i] = this.readConstItem(bsmCodeIndex);
            bsmCodeIndex += 2;
        }
        this.mv.visitInvokeDynamicInsn(bsmName, bsmDesc, bsmHandle, bsmArgs);
        this.codeIndex += 2;
    }

    private void visitEndLabel(@Nonnegative int codeLength) {
        Label label = this.labels[codeLength];
        if (label != null) {
            this.mv.visitLabel(label);
        }
    }

    private void readLocalVariableTables(@Nonnegative int varTableCodeIndex, @Nullable int[] typeTable) {
        if (varTableCodeIndex > 0) {
            this.codeIndex = varTableCodeIndex;
            for (int localVarCount = this.readUnsignedShort(); localVarCount > 0; --localVarCount) {
                int start = this.readUnsignedShort();
                int length = this.readUnsignedShort();
                String varName = this.readNonnullUTF8();
                String varDesc = this.readNonnullUTF8();
                int index = this.readUnsignedShort();
                String varSignature = typeTable == null ? null : this.getLocalVariableSignature(typeTable, start, index);
                this.mv.visitLocalVariable(varName, varDesc, varSignature, this.labels[start], this.labels[start + length], index);
            }
        }
    }

    @Nullable
    private String getLocalVariableSignature(@Nonnull int[] typeTable, @Nonnegative int start, @Nonnegative int index) {
        int n = typeTable.length;
        for (int i = 0; i < n; i += 3) {
            if (typeTable[i] != start || typeTable[i + 1] != index) continue;
            String varSignature = this.readNonnullUTF8(typeTable[i + 2]);
            return varSignature;
        }
        return null;
    }
}

