/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.Configuration;
import mockit.coverage.CoverageCheck;
import mockit.coverage.OutputFileGenerator;
import mockit.coverage.TestRun;
import mockit.coverage.data.CoverageData;
import mockit.coverage.modification.ClassModification;
import mockit.internal.startup.Startup;

public final class CodeCoverage
implements ClassFileTransformer {
    private static CodeCoverage instance;
    @Nonnull
    private final ClassModification classModification = new ClassModification();
    @Nonnull
    private final OutputFileGenerator outputGenerator = CodeCoverage.createOutputFileGenerator(this.classModification);
    private boolean outputPendingForShutdown = true;
    private boolean inactive;

    public static void main(@Nonnull String[] args) {
        OutputFileGenerator generator = CodeCoverage.createOutputFileGenerator(null);
        generator.generateAggregateReportFromInputFiles(args);
    }

    @Nonnull
    private static OutputFileGenerator createOutputFileGenerator(@Nullable ClassModification classModification) {
        OutputFileGenerator generator = new OutputFileGenerator(classModification);
        CoverageData.instance().setWithCallPoints(generator.isWithCallPoints());
        return generator;
    }

    public CodeCoverage() {
        instance = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TestRun.terminate();
                if (CodeCoverage.this.outputPendingForShutdown) {
                    if (CodeCoverage.this.outputGenerator.isOutputToBeGenerated()) {
                        CodeCoverage.this.outputGenerator.generate(CodeCoverage.this);
                    }
                    new CoverageCheck().verifyThresholds();
                }
                Startup.instrumentation().removeTransformer(CodeCoverage.this);
            }
        });
    }

    public static boolean active() {
        String coverageOutput = Configuration.getProperty("output");
        String coverageClasses = Configuration.getProperty("classes");
        return (coverageOutput != null || coverageClasses != null) && !"none".equals(coverageOutput) && !"none".equals(coverageClasses);
    }

    @Nonnull
    public static CodeCoverage create(boolean generateOutputOnShutdown) {
        instance = new CodeCoverage();
        CodeCoverage.instance.outputPendingForShutdown = generateOutputOnShutdown;
        return instance;
    }

    public static void generateOutput() {
        CodeCoverage.instance.outputGenerator.generate(null);
        CodeCoverage.instance.outputPendingForShutdown = false;
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @Nonnull String internalClassName, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] originalClassfile) {
        if (loader == null || classBeingRedefined != null || protectionDomain == null || this.inactive) {
            return null;
        }
        String className = internalClassName.replace('/', '.');
        byte[] modifiedClassfile = this.classModification.modifyClass(className, protectionDomain, originalClassfile);
        return modifiedClassfile;
    }

    void deactivate() {
        this.inactive = true;
    }
}

