/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.Configuration;
import mockit.coverage.data.CoverageData;

final class CoverageCheck {
    @Nullable
    private final List<Threshold> thresholds;
    private boolean allThresholdsSatisfied;

    CoverageCheck() {
        String configuration = Configuration.getProperty("check", "");
        if (configuration.isEmpty()) {
            this.thresholds = null;
            return;
        }
        String[] configurationParameters = configuration.split(";");
        int n = configurationParameters.length;
        this.thresholds = new ArrayList<Threshold>(n);
        for (String configurationParameter : configurationParameters) {
            this.thresholds.add(new Threshold(configurationParameter));
        }
    }

    void verifyThresholds() {
        if (this.thresholds == null) {
            return;
        }
        this.allThresholdsSatisfied = true;
        for (Threshold threshold : this.thresholds) {
            this.allThresholdsSatisfied &= threshold.verifyMinimum();
        }
        this.createOrDeleteIndicatorFile();
        if (!this.allThresholdsSatisfied) {
            throw new AssertionError((Object)"JMockit: minimum coverage percentages not reached; see previous messages.");
        }
    }

    private void createOrDeleteIndicatorFile() {
        String parentDir = Configuration.getOrChooseOutputDirectory("");
        File indicatorFile = new File(parentDir, "coverage.check.failed");
        if (indicatorFile.exists()) {
            if (this.allThresholdsSatisfied) {
                indicatorFile.delete();
            } else {
                indicatorFile.setLastModified(System.currentTimeMillis());
            }
        } else if (!this.allThresholdsSatisfied) {
            try {
                indicatorFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class Threshold {
        private static final Pattern PARAMETER_SEPARATORS = Pattern.compile(":|=");
        @Nullable
        private final String sourceFilePrefix;
        @Nonnull
        private final String scopeDescription;
        @Nonnegative
        private int minPercentage;

        Threshold(@Nonnull String configurationParameter) {
            String textualPercentage;
            String[] sourceFilePrefixAndMinPercentage = PARAMETER_SEPARATORS.split(configurationParameter);
            if (sourceFilePrefixAndMinPercentage.length == 1) {
                this.sourceFilePrefix = null;
                this.scopeDescription = "";
                textualPercentage = sourceFilePrefixAndMinPercentage[0];
            } else {
                String scope = sourceFilePrefixAndMinPercentage[0].trim();
                if (Threshold.isPerFile(scope)) {
                    this.sourceFilePrefix = scope;
                    this.scopeDescription = " for some source files";
                } else {
                    this.sourceFilePrefix = scope.replace('.', '/');
                    this.scopeDescription = " for " + scope;
                }
                textualPercentage = sourceFilePrefixAndMinPercentage[1];
            }
            try {
                this.minPercentage = Integer.parseInt(textualPercentage.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private static boolean isPerFile(@Nullable String scope) {
            return "perFile".equalsIgnoreCase(scope);
        }

        boolean verifyMinimum() {
            CoverageData coverageData = CoverageData.instance();
            int percentage = Threshold.isPerFile(this.sourceFilePrefix) ? coverageData.getSmallestPerFilePercentage() : coverageData.getPercentage(this.sourceFilePrefix);
            return percentage < 0 || this.verifyMinimum(percentage);
        }

        private boolean verifyMinimum(int percentage) {
            if (percentage < this.minPercentage) {
                System.out.println("JMockit: coverage too low" + this.scopeDescription + ": " + percentage + "% < " + this.minPercentage + '%');
                return false;
            }
            return true;
        }
    }
}

