/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.annotations.AnnotationVisitor;
import mockit.asm.classes.ClassInfo;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassWriter;
import mockit.asm.classes.WrappingClassVisitor;
import mockit.asm.controlFlow.Label;
import mockit.asm.fields.FieldVisitor;
import mockit.asm.methods.MethodVisitor;
import mockit.asm.methods.MethodWriter;
import mockit.asm.methods.WrappingMethodVisitor;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.modification.VisitInterruptedException;
import mockit.internal.ClassFile;

final class CoverageModifier
extends WrappingClassVisitor {
    private static final Map<String, CoverageModifier> INNER_CLASS_MODIFIERS = new HashMap<String, CoverageModifier>();
    private static final int FIELD_MODIFIERS_TO_IGNORE = 4112;
    @Nullable
    private String internalClassName;
    @Nullable
    private String simpleClassName;
    @Nonnull
    private String sourceFileName = "";
    @Nullable
    private FileCoverageData fileData;
    private final boolean forInnerClass;
    private boolean forEnumClass;
    @Nullable
    private String kindOfTopLevelType;
    private int currentLine;

    @Nullable
    static byte[] recoverModifiedByteCodeIfAvailable(@Nonnull String innerClassName) {
        CoverageModifier modifier = INNER_CLASS_MODIFIERS.remove(innerClassName);
        return modifier == null ? null : modifier.toByteArray();
    }

    @Nullable
    static ClassReader createClassReader(@Nonnull Class<?> aClass) {
        return ClassFile.createClassReader(aClass.getClassLoader(), aClass.getName().replace('.', '/'));
    }

    CoverageModifier(@Nonnull ClassReader cr) {
        this(cr, false);
    }

    private CoverageModifier(@Nonnull ClassReader cr, boolean forInnerClass) {
        super(new ClassWriter(cr));
        this.forInnerClass = forInnerClass;
    }

    private CoverageModifier(@Nonnull ClassReader cr, @Nonnull CoverageModifier other, @Nullable String simpleClassName) {
        this(cr, true);
        this.sourceFileName = other.sourceFileName;
        this.fileData = other.fileData;
        this.internalClassName = other.internalClassName;
        this.simpleClassName = simpleClassName;
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nonnull ClassInfo additionalInfo) {
        boolean nestedType;
        if ((access & 0x1000) != 0) {
            throw new VisitInterruptedException();
        }
        boolean bl = nestedType = name.indexOf(36) > 0;
        if (!nestedType && this.kindOfTopLevelType == null) {
            this.kindOfTopLevelType = CoverageModifier.getKindOfJavaType(access, additionalInfo.superName);
        }
        this.forEnumClass = (access & 0x4000) != 0;
        String sourceFileDebugName = CoverageModifier.getSourceFileDebugName(additionalInfo);
        if (!this.forInnerClass) {
            boolean cannotModify;
            this.extractClassAndSourceFileName(name);
            boolean bl2 = cannotModify = (access & 0x2000) != 0;
            if (cannotModify) {
                throw VisitInterruptedException.INSTANCE;
            }
            this.registerAsInnerClassModifierIfApplicable(access, name, nestedType);
            this.createFileData(sourceFileDebugName);
        }
        this.cw.visit(version, access, name, additionalInfo);
    }

    @Nonnull
    private static String getKindOfJavaType(int typeModifiers, @Nonnull String superName) {
        if ((typeModifiers & 0x2000) != 0) {
            return "annotation";
        }
        if ((typeModifiers & 0x200) != 0) {
            return "interface";
        }
        if ((typeModifiers & 0x4000) != 0) {
            return "enum";
        }
        if ((typeModifiers & 0x400) != 0) {
            return "abstractClass";
        }
        if (superName.endsWith("Exception") || superName.endsWith("Error")) {
            return "exception";
        }
        return "class";
    }

    @Nonnull
    private static String getSourceFileDebugName(@Nonnull ClassInfo additionalInfo) {
        String sourceFileDebugName = additionalInfo.sourceFileName;
        if (sourceFileDebugName == null || !sourceFileDebugName.endsWith(".java")) {
            throw VisitInterruptedException.INSTANCE;
        }
        return sourceFileDebugName;
    }

    private void extractClassAndSourceFileName(@Nonnull String className) {
        this.internalClassName = className;
        int p = className.lastIndexOf(47);
        if (p < 0) {
            this.simpleClassName = className;
            this.sourceFileName = "";
        } else {
            this.simpleClassName = className.substring(p + 1);
            this.sourceFileName = className.substring(0, p + 1);
        }
    }

    private void registerAsInnerClassModifierIfApplicable(int access, @Nonnull String name, boolean nestedType) {
        if (!this.forEnumClass && (access & 0x20) != 0 && nestedType) {
            INNER_CLASS_MODIFIERS.put(name.replace('/', '.'), this);
        }
    }

    private void createFileData(@Nonnull String sourceFileDebugName) {
        this.sourceFileName = this.sourceFileName + sourceFileDebugName;
        this.fileData = CoverageData.instance().getOrAddFile(this.sourceFileName, this.kindOfTopLevelType);
    }

    @Override
    public void visitInnerClass(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        this.cw.visitInnerClass(name, outerName, innerName, access);
        if (this.forInnerClass || CoverageModifier.isSyntheticOrEnumClass(access) || !this.isNestedInsideClassBeingModified(name, outerName)) {
            return;
        }
        String innerClassName = name.replace('/', '.');
        if (INNER_CLASS_MODIFIERS.containsKey(innerClassName)) {
            return;
        }
        ClassReader innerCR = ClassFile.createClassReader(CoverageModifier.class.getClassLoader(), name);
        if (innerCR != null) {
            CoverageModifier innerClassModifier = new CoverageModifier(innerCR, this, innerName);
            innerCR.accept(innerClassModifier);
            INNER_CLASS_MODIFIERS.put(innerClassName, innerClassModifier);
        }
    }

    private static boolean isSyntheticOrEnumClass(int access) {
        return (access & 0x1000) != 0 || access == 16392;
    }

    private boolean isNestedInsideClassBeingModified(@Nonnull String internalName, @Nullable String outerName) {
        String className = outerName == null ? internalName : outerName;
        int p = className.indexOf(36);
        String outerClassName = p < 0 ? className : className.substring(0, p);
        return outerClassName.equals(this.internalClassName);
    }

    @Override
    public FieldVisitor visitField(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        if (this.fileData != null && this.simpleClassName != null && (access & 0x1010) == 0) {
            this.fileData.dataCoverageInfo.addField(this.simpleClassName, name, (access & 8) != 0);
        }
        return this.cw.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        MethodWriter mw = this.cw.visitMethod(access, name, desc, signature, exceptions);
        if (this.fileData == null || (access & 0x1000) != 0) {
            return mw;
        }
        if (name.charAt(0) == '<') {
            if (name.charAt(1) == 'c') {
                return this.forEnumClass ? mw : new StaticBlockModifier(mw);
            }
            return new ConstructorModifier(mw);
        }
        return new MethodModifier(mw);
    }

    private final class StaticBlockModifier
    extends BaseMethodModifier {
        StaticBlockModifier(MethodWriter mw) {
            super(mw);
        }

        @Override
        public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
            if (opcode == 182 && "java/lang/Class".equals(owner) && "desiredAssertionStatus".equals(name)) {
                this.assertFoundInCurrentLine = true;
                this.ignoreUntilNextLabel = true;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private final class ConstructorModifier
    extends MethodOrConstructorModifier {
        ConstructorModifier(MethodWriter mw) {
            super(mw);
        }
    }

    private final class MethodModifier
    extends MethodOrConstructorModifier {
        MethodModifier(MethodWriter mw) {
            super(mw);
        }

        @Override
        public AnnotationVisitor visitAnnotation(@Nonnull String desc) {
            boolean isTestMethod;
            boolean bl = isTestMethod = desc.startsWith("Lorg/junit/") || desc.startsWith("Lorg/testng/");
            if (isTestMethod) {
                throw VisitInterruptedException.INSTANCE;
            }
            return this.mw.visitAnnotation(desc);
        }
    }

    private class MethodOrConstructorModifier
    extends BaseMethodModifier {
        MethodOrConstructorModifier(MethodWriter mw) {
            super(mw);
        }

        @Override
        public final void visitFieldInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
            boolean getField = opcode == 178 || opcode == 180;
            boolean isStatic = opcode == 179 || opcode == 178;
            char fieldType = desc.charAt(0);
            boolean size2 = fieldType == 'J' || fieldType == 'D';
            String classAndFieldNames = null;
            boolean fieldHasData = false;
            if (!owner.startsWith("java/")) {
                classAndFieldNames = owner.substring(owner.lastIndexOf(47) + 1) + '.' + name;
                assert (CoverageModifier.this.fileData != null);
                fieldHasData = ((CoverageModifier)CoverageModifier.this).fileData.dataCoverageInfo.isFieldWithCoverageData(classAndFieldNames);
                if (fieldHasData && !isStatic) {
                    this.generateCodeToSaveInstanceReferenceOnTheStack(getField, size2);
                }
            }
            super.visitFieldInsn(opcode, owner, name, desc);
            if (fieldHasData) {
                this.generateCallToRegisterFieldCoverage(getField, isStatic, size2, classAndFieldNames);
            }
        }

        private void generateCodeToSaveInstanceReferenceOnTheStack(boolean getField, boolean size2) {
            if (getField) {
                this.mw.visitInsn(89);
            } else if (size2) {
                this.mw.visitInsn(93);
                this.mw.visitInsn(88);
                this.mw.visitInsn(91);
                this.mw.visitInsn(91);
                this.mw.visitInsn(87);
            } else {
                this.mw.visitInsn(90);
                this.mw.visitInsn(87);
                this.mw.visitInsn(90);
                this.mw.visitInsn(90);
                this.mw.visitInsn(87);
            }
        }

        private void generateCallToRegisterFieldCoverage(boolean getField, boolean isStatic, boolean size2, @Nonnull String classAndFieldNames) {
            if (!isStatic && getField) {
                if (size2) {
                    this.mw.visitInsn(93);
                    this.mw.visitInsn(88);
                } else {
                    this.mw.visitInsn(90);
                    this.mw.visitInsn(87);
                }
            }
            this.mw.visitLdcInsn(CoverageModifier.this.sourceFileName);
            this.mw.visitLdcInsn(classAndFieldNames);
            String methodToCall = getField ? "fieldRead" : "fieldAssigned";
            String methodDesc = isStatic ? "(Ljava/lang/String;Ljava/lang/String;)V" : "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V";
            this.mw.visitMethodInsn(184, "mockit/coverage/TestRun", methodToCall, methodDesc, false);
        }

        @Override
        public final void visitLookupSwitchInsn(@Nonnull Label dflt, @Nonnull int[] keys, @Nonnull Label[] labels) {
            if (this.ignoreUntilNextSwitch == 1) {
                this.ignoreUntilNextSwitch = 2;
            }
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    private class BaseMethodModifier
    extends WrappingMethodVisitor {
        static final String DATA_RECORDING_CLASS = "mockit/coverage/TestRun";
        @Nonnull
        protected final List<Label> visitedLabels;
        @Nonnull
        private final List<Label> jumpTargetsForCurrentLine;
        @Nonnull
        private final List<Integer> pendingBranches;
        @Nonnull
        private final PerFileLineCoverage lineCoverageInfo;
        private int lineExpectingInstructionAfterJump;
        boolean assertFoundInCurrentLine;
        boolean ignoreUntilNextLabel;
        private boolean foundPotentialAssertFalse;
        private int foundPotentialBooleanExpressionValue;
        int ignoreUntilNextSwitch;

        BaseMethodModifier(MethodWriter mw) {
            super(mw);
            this.visitedLabels = new ArrayList<Label>();
            this.jumpTargetsForCurrentLine = new ArrayList<Label>(4);
            this.pendingBranches = new ArrayList<Integer>(6);
            assert (CoverageModifier.this.fileData != null);
            this.lineCoverageInfo = CoverageModifier.this.fileData.getLineCoverageData();
        }

        @Override
        public void visitLineNumber(@Nonnegative int line, @Nonnull Label start) {
            if (!this.pendingBranches.isEmpty()) {
                this.pendingBranches.clear();
            }
            this.lineCoverageInfo.addLine(line);
            CoverageModifier.this.currentLine = line;
            this.jumpTargetsForCurrentLine.clear();
            this.generateCallToRegisterLineExecution();
            this.mw.visitLineNumber(line, start);
        }

        private void generateCallToRegisterLineExecution() {
            assert (CoverageModifier.this.fileData != null);
            this.mw.visitIntInsn(17, ((CoverageModifier)CoverageModifier.this).fileData.index);
            this.pushCurrentLineOnTheStack();
            this.mw.visitMethodInsn(184, DATA_RECORDING_CLASS, "lineExecuted", "(II)V", false);
        }

        private void pushCurrentLineOnTheStack() {
            if (CoverageModifier.this.currentLine <= Short.MAX_VALUE) {
                this.mw.visitIntInsn(17, CoverageModifier.this.currentLine);
            } else {
                this.mw.visitLdcInsn(CoverageModifier.this.currentLine);
            }
        }

        @Override
        public void visitJumpInsn(int opcode, @Nonnull Label label) {
            if (CoverageModifier.this.currentLine == 0 || this.ignoreUntilNextLabel || this.ignoreUntilNextSwitch > 0 || this.visitedLabels.contains(label) || !this.isConditionalJump(opcode)) {
                this.assertFoundInCurrentLine = false;
                this.mw.visitJumpInsn(opcode, label);
                if (opcode == 167 && this.foundPotentialBooleanExpressionValue == 1) {
                    this.foundPotentialBooleanExpressionValue = 2;
                }
                return;
            }
            Label jumpingFrom = this.mw.getCurrentBlock();
            assert (jumpingFrom != null);
            jumpingFrom.info = CoverageModifier.this.currentLine;
            if (!this.jumpTargetsForCurrentLine.contains(label)) {
                this.jumpTargetsForCurrentLine.add(label);
            }
            LineCoverageData lineData = this.lineCoverageInfo.getOrCreateLineData(CoverageModifier.this.currentLine);
            int sourceBranchIndex = lineData.addBranchingPoint(jumpingFrom, label);
            this.pendingBranches.add(sourceBranchIndex);
            if (this.assertFoundInCurrentLine) {
                BranchCoverageData branchData = this.lineCoverageInfo.getBranchData(CoverageModifier.this.currentLine, sourceBranchIndex + 1);
                branchData.markAsUnreachable();
            }
            this.mw.visitJumpInsn(opcode, label);
            this.lineExpectingInstructionAfterJump = 0;
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.lineExpectingInstructionAfterJump = CoverageModifier.this.currentLine;
        }

        final boolean isConditionalJump(int opcode) {
            return opcode != 167;
        }

        private void generateCallToRegisterBranchTargetExecutionIfPending() {
            if (this.ignoreUntilNextLabel || this.ignoreUntilNextSwitch > 0) {
                return;
            }
            this.foundPotentialAssertFalse = false;
            this.foundPotentialBooleanExpressionValue = 0;
            if (!this.pendingBranches.isEmpty()) {
                for (Integer pendingBranchIndex : this.pendingBranches) {
                    this.generateCallToRegisterBranchTargetExecution(pendingBranchIndex);
                }
                this.pendingBranches.clear();
            }
            if (this.lineExpectingInstructionAfterJump > 0) {
                if (CoverageModifier.this.currentLine > this.lineExpectingInstructionAfterJump) {
                    this.lineCoverageInfo.markLastLineSegmentAsEmpty(this.lineExpectingInstructionAfterJump);
                }
                this.lineExpectingInstructionAfterJump = 0;
            }
        }

        private void generateCallToRegisterBranchTargetExecution(@Nonnegative int branchIndex) {
            assert (CoverageModifier.this.fileData != null);
            this.mw.visitIntInsn(17, ((CoverageModifier)CoverageModifier.this).fileData.index);
            this.pushCurrentLineOnTheStack();
            this.mw.visitIntInsn(17, branchIndex);
            this.mw.visitMethodInsn(184, DATA_RECORDING_CLASS, "branchExecuted", "(III)V", false);
        }

        @Override
        public void visitLabel(@Nonnull Label label) {
            if (this.ignoreUntilNextLabel || this.ignoreUntilNextSwitch > 0) {
                this.mw.visitLabel(label);
                this.ignoreUntilNextLabel = false;
                return;
            }
            this.visitedLabels.add(label);
            this.mw.visitLabel(label);
            int jumpTargetIndex = this.jumpTargetsForCurrentLine.indexOf(label);
            if (jumpTargetIndex >= 0) {
                label.info = label.line > 0 ? label.line : CoverageModifier.this.currentLine;
                int targetBranchIndex = 2 * jumpTargetIndex + 1;
                this.pendingBranches.add(targetBranchIndex);
                this.assertFoundInCurrentLine = false;
            }
            this.foundPotentialBooleanExpressionValue = 0;
        }

        @Override
        public void visitInsn(int opcode) {
            if ((opcode == 3 || opcode == 4) && this.foundPotentialBooleanExpressionValue == 0) {
                this.generateCallToRegisterBranchTargetExecutionIfPending();
                this.foundPotentialBooleanExpressionValue = 1;
            } else {
                this.generateCallToRegisterBranchTargetExecutionIfPending();
            }
            this.mw.visitInsn(opcode);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitIntInsn(opcode, operand);
        }

        @Override
        public void visitVarInsn(int opcode, @Nonnegative int varIndex) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitVarInsn(opcode, varIndex);
        }

        @Override
        public void visitTypeInsn(int opcode, @Nonnull String typeDesc) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitTypeInsn(opcode, typeDesc);
        }

        @Override
        public void visitFieldInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitFieldInsn(opcode, owner, name, desc);
            if (opcode == 178 && "$assertionsDisabled".equals(name)) {
                this.assertFoundInCurrentLine = true;
                this.ignoreUntilNextLabel = true;
            }
            this.foundPotentialAssertFalse = true;
        }

        @Override
        public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitMethodInsn(opcode, owner, name, desc, itf);
            if (opcode == 182 && "hashCode".equals(name) && "java/lang/String".equals(owner) && this.ignoreUntilNextSwitch == 0) {
                this.ignoreUntilNextSwitch = 1;
            }
        }

        @Override
        public void visitLdcInsn(@Nonnull Object cst) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitLdcInsn(cst);
        }

        @Override
        public void visitIincInsn(@Nonnegative int varIndex, int increment) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitIincInsn(varIndex, increment);
        }

        @Override
        public void visitTryCatchBlock(@Nonnull Label start, @Nonnull Label end, @Nonnull Label handler, @Nullable String type) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitTryCatchBlock(start, end, handler, type);
        }

        @Override
        public void visitLookupSwitchInsn(@Nonnull Label dflt, @Nonnull int[] keys, @Nonnull Label[] labels) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, @Nonnull Label dflt, Label ... labels) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitTableSwitchInsn(min, max, dflt, labels);
        }

        @Override
        public void visitMultiANewArrayInsn(@Nonnull String desc, @Nonnegative int dims) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitMultiANewArrayInsn(desc, dims);
        }
    }
}

