/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.packages;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.reporting.OutputFile;
import mockit.coverage.reporting.packages.ListWithFilesAndPercentages;
import mockit.coverage.reporting.packages.PackageCoverageReport;
import mockit.coverage.testRedundancy.TestCoverage;

public final class IndexPage
extends ListWithFilesAndPercentages {
    @Nullable
    private final List<File> sourceDirs;
    @Nonnull
    private final Map<String, List<String>> packageToFiles;
    @Nonnull
    private final Map<String, Integer> packageToPackagePercentages;
    @Nonnull
    private final PackageCoverageReport packageReport;
    @Nonnegative
    private final int totalFileCount;

    public IndexPage(@Nonnull File outputFile, @Nullable List<File> sourceDirs, @Nullable Collection<String> sourceFilesNotFound, @Nonnull Map<String, List<String>> packageToFiles, @Nonnull Map<String, FileCoverageData> fileToFileData) throws IOException {
        super(new OutputFile(outputFile), "    ");
        this.sourceDirs = sourceDirs;
        this.packageToFiles = packageToFiles;
        this.packageToPackagePercentages = new HashMap<String, Integer>();
        this.packageReport = new PackageCoverageReport(this.output, sourceFilesNotFound, fileToFileData, packageToFiles.values());
        this.totalFileCount = IndexPage.totalNumberOfSourceFilesWithCoverageData(fileToFileData.values());
    }

    @Nonnegative
    private static int totalNumberOfSourceFilesWithCoverageData(@Nonnull Collection<FileCoverageData> fileData) {
        return fileData.size() - Collections.frequency(fileData, null);
    }

    public void generate() {
        try {
            this.writeHeader();
            ArrayList<String> packages = new ArrayList<String>(this.packageToFiles.keySet());
            this.writeMetricsForEachFile(null, packages);
            this.writeLineWithCoverageTotal();
            this.output.println("  </table>");
            this.writeListOfRedundantTestsIfAny();
            this.writeFooter();
        }
        finally {
            this.output.close();
        }
    }

    private void writeHeader() {
        ((OutputFile)this.output).writeCommonHeader("Code Coverage Report");
        this.output.println("  <table id='packages'>");
        this.writeTableCaption();
        this.writeTableFirstRowWithColumnTitles();
    }

    private void writeTableCaption() {
        if (this.sourceDirs == null) {
            this.output.println("    <caption>All Packages and Files</caption>");
        } else {
            this.output.write("    <caption>All Packages and Files<div style='font-size: smaller'>");
            this.output.write(this.getCommaSeparatedListOfSourceDirs());
            this.output.println("</div></caption>");
        }
    }

    @Nonnull
    private String getCommaSeparatedListOfSourceDirs() {
        List<File> dirs = this.sourceDirs;
        assert (dirs != null);
        IndexPage.removeRedundantSourceDirectories(dirs);
        String concatenatedSourceDirs = dirs.toString();
        String prefixToRemove = ".." + File.separatorChar;
        String commaSepDirs = concatenatedSourceDirs.replace(prefixToRemove, "");
        return commaSepDirs.substring(1, commaSepDirs.length() - 1);
    }

    private static void removeRedundantSourceDirectories(@Nonnull List<File> dirs) {
        for (int i = 0; i < dirs.size(); ++i) {
            i = IndexPage.removeRedundantSourceDirectory(dirs, i);
        }
    }

    private static int removeRedundantSourceDirectory(@Nonnull List<File> dirs, @Nonnegative int i) {
        String dir1 = dirs.get(i).getPath();
        int j = i + 1;
        while (j < dirs.size()) {
            String dir2 = dirs.get(j).getPath();
            if (dir1.startsWith(dir2)) {
                dirs.remove(j);
                continue;
            }
            if (dir2.startsWith(dir1)) {
                dirs.remove(i);
                --i;
                break;
            }
            ++j;
        }
        return i;
    }

    private void writeTableFirstRowWithColumnTitles() {
        this.output.println("    <tr>");
        this.output.write("      <th style='cursor: col-resize' onclick='showHideAllFiles()'>Packages: ");
        this.output.print(this.packageToFiles.keySet().size());
        this.output.println("</th>");
        this.output.write("      <th onclick='location.reload()' style='cursor: n-resize' title='Click on the column title to the right to sort by size (total number of items).'>Files: ");
        this.output.print(this.totalFileCount);
        this.output.println("</th>");
        this.writeHeaderCellWithMetricNameAndDescription();
        this.output.println("    </tr>");
    }

    private void writeHeaderCellWithMetricNameAndDescription() {
        this.output.write("      <th onclick='sortTables()' style='cursor: n-resize' title='Measures how much of the executable production code (executable lines and fields) was exercised by tests.\r\nAn executable line of code contains one or more executable segments, separated by branching points\r\n(if..else instructions, logical operators, etc.).\r\nTo be fully exercised, a field must have the last value assigned to it read by at least one test.\r\nPercentages are calculated as 100*(NE + NFE)/(NS + NF), where NS is the number of segments, NF the number\r\nof non-final fields, NE the number of executed segments, and NFE the number of fully exercised fields.'>Cvrg</th>");
    }

    private void writeLineWithCoverageTotal() {
        this.output.println("    <tr class='total'>");
        this.output.println("      <td>Total</td><td>&nbsp;</td>");
        int covered = this.coveredItems;
        int total = this.totalItems;
        int percentage = CoveragePercentage.calculate(covered, total);
        this.printCoveragePercentage(covered, total, percentage);
        this.output.println("    </tr>");
    }

    @Override
    protected void writeMetricsForFile(String unused, @Nonnull String packageName) {
        this.writeRowStart();
        this.writeTableCellWithPackageName(packageName);
        this.writeInternalTableForSourceFiles(packageName);
        this.writeCoveragePercentageForPackage(packageName);
        this.writeRowClose();
    }

    private void writeTableCellWithPackageName(@Nonnull String packageName) {
        this.printIndent();
        this.output.write("  <td class='package");
        List<String> filesInPackage = this.packageToFiles.get(packageName);
        if (filesInPackage.size() > 1) {
            this.output.write(" click' onclick='showHideFiles(this)");
        }
        this.output.write("'>");
        this.output.write(packageName.replace('/', '.'));
        this.output.println("</td>");
    }

    private void writeInternalTableForSourceFiles(@Nonnull String packageName) {
        this.printIndent();
        this.output.println("  <td>");
        this.printIndent();
        this.output.println("    <table width='100%'>");
        List<String> fileNames = this.packageToFiles.get(packageName);
        this.packageReport.writeMetricsForEachFile(packageName, fileNames);
        this.recordCoverageInformationForPackage(packageName);
        this.printIndent();
        this.output.println("    </table>");
        this.printIndent();
        this.writeInitiallyHiddenSourceFileCount(fileNames.size());
        this.output.println("  </td>");
    }

    private void recordCoverageInformationForPackage(@Nonnull String packageName) {
        int coveredInPackage = this.packageReport.coveredItems;
        int totalInPackage = this.packageReport.totalItems;
        int packagePercentage = CoveragePercentage.calculate(coveredInPackage, totalInPackage);
        this.totalItems += totalInPackage;
        this.coveredItems += coveredInPackage;
        this.packageToPackagePercentages.put(packageName, packagePercentage);
    }

    private void writeInitiallyHiddenSourceFileCount(@Nonnegative int fileCount) {
        this.output.write("    <span>(");
        this.output.print(fileCount);
        this.output.println(" source files)</span>");
    }

    private void writeCoveragePercentageForPackage(@Nonnull String packageName) {
        int filePercentage = this.packageToPackagePercentages.get(packageName);
        this.printCoveragePercentage(this.packageReport.coveredItems, this.packageReport.totalItems, filePercentage);
    }

    @Override
    protected void writeClassAttributeForCoveragePercentageCell() {
        this.output.write("class='pt' ");
    }

    private void writeListOfRedundantTestsIfAny() {
        TestCoverage testCoverage = TestCoverage.INSTANCE;
        if (testCoverage == null) {
            return;
        }
        List<Method> redundantTests = testCoverage.getRedundantTests();
        if (!redundantTests.isEmpty()) {
            this.output.println("  <br/>Redundant tests:");
            this.output.println("  <ol title=\"Tests are regarded as redundant when they don't cover any additional line segments or fields that haven't already been covered by a previous test.\nNote this means the list of redundant tests depends on the order of test execution.\nSuch a test can be removed without weakening the test suite, as long as another test for the same scenario performs its assertions.\">");
            for (Method testMethod : redundantTests) {
                String testDescription = testMethod.getDeclaringClass().getSimpleName() + '.' + testMethod.getName();
                this.output.append("");
                this.output.write("    <li>");
                this.output.write(testDescription);
                this.output.println("</li>");
            }
            this.output.println("  </ol>");
        }
    }

    private void writeFooter() {
        this.output.println("  <p>");
        this.output.println("    <a href='http://jmockit.github.io'><img src='logo.png'></a>");
        this.output.write("    Generated on ");
        this.output.println(new Date());
        this.output.println("  </p>");
        ((OutputFile)this.output).writeCommonFooter();
    }
}

